/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel.graph;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.capability.CapabilityTunnel;
import dev.compactmods.machines.codec.NbtListCollector;
import dev.compactmods.machines.core.Tunnels;
import dev.compactmods.machines.graph.CompactGraphs;
import dev.compactmods.machines.graph.IGraphEdge;
import dev.compactmods.machines.graph.IGraphNode;
import dev.compactmods.machines.machine.graph.CompactMachineNode;
import dev.compactmods.machines.tunnel.graph.TunnelMachineEdge;
import dev.compactmods.machines.tunnel.graph.TunnelNode;
import dev.compactmods.machines.tunnel.graph.TunnelTypeEdge;
import dev.compactmods.machines.tunnel.graph.TunnelTypeNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.logging.log4j.Logger;

public class TunnelConnectionGraph
implements INBTSerializable<CompoundTag> {
    private final MutableValueGraph<IGraphNode, IGraphEdge> graph = ValueGraphBuilder.directed().build();
    private final Map<BlockPos, TunnelNode> tunnels = new HashMap<BlockPos, TunnelNode>();
    private final Map<Integer, CompactMachineNode> machines = new HashMap<Integer, CompactMachineNode>();
    private final Map<ResourceLocation, TunnelTypeNode> tunnelTypes = new HashMap<ResourceLocation, TunnelTypeNode>();

    public Optional<Integer> connectedMachine(BlockPos tunnel) {
        if (!this.tunnels.containsKey(tunnel)) {
            return Optional.empty();
        }
        TunnelNode tNode = this.tunnels.get(tunnel);
        return this.graph.successors((Object)tNode).stream().filter(CompactMachineNode.class::isInstance).findFirst().map(mNode -> ((CompactMachineNode)mNode).machineId());
    }

    public boolean registerTunnel(BlockPos tunnelPos, TunnelDefinition type, int machineId, Direction side) {
        CompactMachineNode machineNode = this.getOrCreateMachineNode(machineId);
        TunnelNode tunnelNode = this.getOrCreateTunnelNode(tunnelPos);
        if (this.graph.hasEdgeConnecting((Object)tunnelNode, (Object)machineNode)) {
            this.graph.edgeValue((Object)tunnelNode, (Object)machineNode).ifPresent(edge -> CompactMachines.LOGGER.info("Tunnel already registered for machine {} at position {}.", (Object)machineId, (Object)tunnelPos));
            return false;
        }
        Set tunnelsForSide = this.getTunnelsForSide(machineId, side).collect(Collectors.toSet());
        TunnelTypeNode tunnelTypeNode = this.getOrCreateTunnelTypeNode(type);
        if (!tunnelsForSide.isEmpty()) {
            for (TunnelNode sidedTunnel : tunnelsForSide) {
                Optional existingConn = this.graph.edgeValue((Object)sidedTunnel, (Object)tunnelTypeNode);
                if (!existingConn.isPresent()) continue;
                CompactMachines.LOGGER.info("Tunnel type {} already registered for side {} at position {}.", (Object)type.getRegistryName(), (Object)side.m_7912_(), (Object)sidedTunnel.position());
                return false;
            }
        }
        this.createTunnelAndLink(tunnelNode, side, machineNode, tunnelTypeNode);
        return true;
    }

    private void createTunnelAndLink(TunnelNode newTunnel, Direction side, CompactMachineNode machNode, TunnelTypeNode typeNode) {
        TunnelMachineEdge newEdge = new TunnelMachineEdge(side);
        this.graph.putEdgeValue((Object)newTunnel, (Object)machNode, (Object)newEdge);
        this.graph.putEdgeValue((Object)newTunnel, (Object)typeNode, (Object)new TunnelTypeEdge());
    }

    @Nonnull
    public TunnelNode getOrCreateTunnelNode(BlockPos tunnelPos) {
        if (this.tunnels.containsKey(tunnelPos)) {
            return this.tunnels.get(tunnelPos);
        }
        TunnelNode newTunnel = new TunnelNode(tunnelPos);
        this.graph.addNode((Object)newTunnel);
        this.tunnels.put(tunnelPos, newTunnel);
        return newTunnel;
    }

    public CompactMachineNode getOrCreateMachineNode(int machineId) {
        CompactMachineNode node;
        boolean machineRegistered = this.machines.containsKey(machineId);
        if (!machineRegistered) {
            node = new CompactMachineNode(machineId);
            this.machines.put(machineId, node);
            this.graph.addNode((Object)node);
        } else {
            node = this.machines.get(machineId);
        }
        return node;
    }

    public TunnelTypeNode getOrCreateTunnelTypeNode(TunnelDefinition definition) {
        ResourceLocation id = definition.getRegistryName();
        if (this.tunnelTypes.containsKey(id)) {
            return this.tunnelTypes.get(id);
        }
        TunnelTypeNode newType = new TunnelTypeNode(id);
        this.graph.addNode((Object)newType);
        this.tunnelTypes.put(id, newType);
        return newType;
    }

    public int size() {
        return this.graph.nodes().size();
    }

    public Stream<TunnelNode> getTunnelNodesByType(TunnelDefinition type) {
        TunnelTypeNode defNode = this.tunnelTypes.get(type.getRegistryName());
        if (defNode == null) {
            return Stream.empty();
        }
        return this.graph.predecessors((Object)defNode).stream().filter(n -> n instanceof TunnelNode).map(TunnelNode.class::cast);
    }

    public Set<BlockPos> getTunnelsByType(TunnelDefinition type) {
        return this.getTunnelNodesByType(type).map(TunnelNode::position).map(BlockPos::m_7949_).collect(Collectors.toSet());
    }

    public Optional<Direction> getTunnelSide(BlockPos pos) {
        if (!this.tunnels.containsKey(pos)) {
            return Optional.empty();
        }
        TunnelNode node = this.tunnels.get(pos);
        return this.graph.successors((Object)node).stream().filter(outNode -> outNode instanceof CompactMachineNode).map(mn -> this.graph.edgeValue((Object)node, mn)).filter(Optional::isPresent).map(Optional::get).map(TunnelMachineEdge.class::cast).map(TunnelMachineEdge::side).findFirst();
    }

    public Stream<IGraphNode> nodes() {
        return this.graph.nodes().stream();
    }

    public CompoundTag serializeNBT() {
        this.cleanupOrphans();
        CompoundTag tag = new CompoundTag();
        HashMap nodeIds = new HashMap();
        ListTag nodeList = this.nodes().map(node -> {
            CompoundTag nodeInfo = new CompoundTag();
            Codec codec = node.codec();
            DataResult encoded = codec.encodeStart((DynamicOps)NbtOps.f_128958_, node);
            Tag nodeEncoded = (Tag)encoded.getOrThrow(false, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
            UUID id = UUID.randomUUID();
            nodeInfo.m_128362_("id", id);
            nodeInfo.m_128365_("data", nodeEncoded);
            nodeIds.put(node, id);
            return nodeInfo;
        }).collect(NbtListCollector.toNbtList());
        tag.m_128365_("nodes", (Tag)nodeList);
        ListTag edges = new ListTag();
        for (EndpointPair edge : this.graph.edges()) {
            CompoundTag edgeInfo = new CompoundTag();
            IGraphEdge realEdge = (IGraphEdge)this.graph.edgeValue(edge).get();
            Codec codec = realEdge.codec();
            DataResult encoded = codec.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)realEdge);
            Tag edgeEnc = (Tag)encoded.getOrThrow(false, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
            edgeInfo.m_128362_("from", (UUID)nodeIds.get(edge.nodeU()));
            edgeInfo.m_128362_("to", (UUID)nodeIds.get(edge.nodeV()));
            edgeInfo.m_128365_("data", edgeEnc);
            edges.add((Object)edgeInfo);
        }
        tag.m_128365_("edges", (Tag)edges);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (!tag.m_128441_("nodes")) {
            return;
        }
        ListTag nodes = tag.m_128437_("nodes", 10);
        HashMap<UUID, Record> nodeMap = new HashMap<UUID, Record>(nodes.size());
        for (Tag nodeNbt : nodes) {
            CompoundTag nt;
            if (!(nodeNbt instanceof CompoundTag) || !(nt = (CompoundTag)nodeNbt).m_128441_("data") || !nt.m_128403_("id")) continue;
            UUID nodeId = nt.m_128342_("id");
            CompoundTag nodeData = nt.m_128469_("data");
            ResourceLocation nodeType = new ResourceLocation(nodeData.m_128461_("type"));
            Codec<IGraphNode> codec = CompactGraphs.getCodecForNode(nodeType);
            if (codec == null) continue;
            DataResult res = codec.parse((DynamicOps)NbtOps.f_128958_, (Object)nodeData);
            try {
                IGraphNode node = (IGraphNode)res.getOrThrow(false, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
                if (node instanceof CompactMachineNode) {
                    CompactMachineNode m = (CompactMachineNode)node;
                    CompactMachineNode mn = this.getOrCreateMachineNode(m.machineId());
                    nodeMap.putIfAbsent(nodeId, mn);
                }
                if (node instanceof TunnelNode) {
                    TunnelNode t = (TunnelNode)node;
                    TunnelNode tn = this.getOrCreateTunnelNode(t.position());
                    nodeMap.putIfAbsent(nodeId, tn);
                }
                if (!(node instanceof TunnelTypeNode)) continue;
                TunnelTypeNode tt = (TunnelTypeNode)node;
                TunnelTypeNode ttn = this.getOrCreateTunnelTypeNode(Tunnels.getDefinition(tt.id()));
                nodeMap.putIfAbsent(nodeId, ttn);
            }
            catch (RuntimeException runtimeException) {}
        }
        if (!tag.m_128441_("edges")) {
            return;
        }
        ListTag edgeTags = tag.m_128437_("edges", 10);
        for (Tag edgeTag : edgeTags) {
            Codec<IGraphEdge> edgeCodec;
            CompoundTag edge;
            if (!(edgeTag instanceof CompoundTag) || !(edge = (CompoundTag)edgeTag).m_128441_("data") || !edge.m_128403_("from") || !edge.m_128403_("to")) continue;
            IGraphNode nodeFrom = (IGraphNode)nodeMap.get(edge.m_128342_("from"));
            IGraphNode nodeTo = (IGraphNode)nodeMap.get(edge.m_128342_("to"));
            if (nodeFrom == null || nodeTo == null || (edgeCodec = CompactGraphs.getCodecForEdge(new ResourceLocation(edge.m_128469_("data").m_128461_("type")))) == null) continue;
            IGraphEdge edgeData = (IGraphEdge)edgeCodec.parse((DynamicOps)NbtOps.f_128958_, (Object)edge.m_128469_("data")).getOrThrow(false, arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0));
            this.graph.putEdgeValue((Object)nodeFrom, (Object)nodeTo, (Object)edgeData);
        }
    }

    public boolean hasTunnel(BlockPos zero) {
        return this.tunnels.containsKey(zero);
    }

    public <T> Stream<BlockPos> getTunnelsSupporting(int machine, Direction side, Capability<T> capability) {
        IGraphNode node = this.machines.get(machine);
        if (node == null) {
            return Stream.empty();
        }
        return this.getTunnelsForSide(machine, side).filter(sided -> this.graph.successors(sided).stream().filter(TunnelTypeNode.class::isInstance).map(TunnelTypeNode.class::cast).anyMatch(ttn -> {
            TunnelDefinition def = Tunnels.getDefinition(ttn.id());
            if (!(def instanceof CapabilityTunnel)) {
                return false;
            }
            CapabilityTunnel tcp = (CapabilityTunnel)((Object)def);
            return tcp.getSupportedCapabilities().contains((Object)capability);
        })).map(TunnelNode::position);
    }

    public Stream<TunnelDefinition> getTypesForSide(int machine, Direction side) {
        IGraphNode node = this.machines.get(machine);
        if (node == null) {
            return Stream.empty();
        }
        return this.getTunnelsForSide(machine, side).flatMap(tn -> this.graph.successors(tn).stream()).filter(TunnelTypeNode.class::isInstance).map(TunnelTypeNode.class::cast).map(type -> Tunnels.getDefinition(type.id())).distinct();
    }

    public Stream<TunnelNode> getTunnelsForSide(int machine, Direction side) {
        CompactMachineNode node = this.machines.get(machine);
        if (node == null) {
            return Stream.empty();
        }
        return this.graph.incidentEdges((Object)node).stream().filter(e -> this.graph.edgeValue(e).map(ed -> {
            TunnelMachineEdge tme;
            return ed instanceof TunnelMachineEdge && (tme = (TunnelMachineEdge)ed).side() == side;
        }).orElse(false)).map(EndpointPair::nodeU).filter(TunnelNode.class::isInstance).map(TunnelNode.class::cast);
    }

    public Stream<Direction> getTunnelSides(TunnelDefinition type) {
        if (!this.tunnelTypes.containsKey(type.getRegistryName())) {
            return Stream.empty();
        }
        return this.getTunnelsByType(type).stream().map(this::getTunnelSide).filter(Optional::isPresent).map(Optional::get);
    }

    public void deleteMachine(int machine) {
        if (!this.machines.containsKey(machine)) {
            return;
        }
        CompactMachineNode node = this.machines.get(machine);
        this.graph.predecessors((Object)node).stream().filter(TunnelNode.class::isInstance).map(TunnelNode.class::cast).forEach(node1 -> {
            BlockPos p = node1.position();
            this.tunnels.remove(p);
            this.graph.removeNode(node1);
        });
        this.graph.removeNode((Object)node);
        this.machines.remove(machine);
    }

    public void clear() {
        for (CompactMachineNode machine : this.machines.values()) {
            this.graph.removeNode((Object)machine);
        }
        this.machines.clear();
        for (TunnelTypeNode t : this.tunnelTypes.values()) {
            this.graph.removeNode((Object)t);
        }
        this.tunnelTypes.clear();
        for (TunnelNode tun : this.tunnels.values()) {
            this.graph.removeNode((Object)tun);
        }
        this.tunnels.clear();
    }

    public Stream<BlockPos> getMachineTunnels(int machine, TunnelDefinition type) {
        return this.getTunnelNodesByType(type).map(TunnelNode::position).filter(position -> this.connectedMachine((BlockPos)position).map(m -> m == machine).orElse(false)).map(BlockPos::m_7949_);
    }

    public void unregister(BlockPos pos) {
        if (!this.hasTunnel(pos)) {
            return;
        }
        TunnelNode existing = this.tunnels.get(pos);
        this.graph.removeNode((Object)existing);
        this.tunnels.remove(pos);
        this.cleanupOrphanedTypes();
        this.cleanupOrphanedMachines();
    }

    private void cleanupOrphans() {
        this.cleanupOrphanedTunnels();
        this.cleanupOrphanedTypes();
        this.cleanupOrphanedMachines();
    }

    private void cleanupOrphanedTypes() {
        HashSet removedTypes = new HashSet();
        this.tunnelTypes.forEach((type, node) -> {
            if (this.graph.degree(node) == 0) {
                this.graph.removeNode(node);
                removedTypes.add(type);
            }
        });
        removedTypes.forEach(this.tunnelTypes::remove);
    }

    private void cleanupOrphanedTunnels() {
        HashSet removed = new HashSet();
        this.tunnels.forEach((pos, node) -> {
            if (this.graph.degree(node) == 0) {
                this.graph.removeNode(node);
                removed.add(pos);
            }
        });
        removed.forEach(this.tunnels::remove);
    }

    private void cleanupOrphanedMachines() {
        HashSet removed = new HashSet();
        this.machines.forEach((machine, node) -> {
            if (this.graph.degree(node) == 0) {
                this.graph.removeNode(node);
                removed.add(machine);
            }
        });
        removed.forEach(this.machines::remove);
    }

    public void rotateTunnel(BlockPos tunnel, Direction newSide) {
        if (!this.tunnels.containsKey(tunnel)) {
            return;
        }
        Optional<Integer> connected = this.connectedMachine(tunnel);
        connected.ifPresent(machine -> {
            if (!this.machines.containsKey(machine)) {
                return;
            }
            TunnelNode t = this.tunnels.get(tunnel);
            CompactMachineNode m = this.machines.get(machine);
            this.graph.removeEdge((Object)t, (Object)m);
            this.graph.putEdgeValue((Object)t, (Object)m, (Object)new TunnelMachineEdge(newSide));
        });
    }

    public Stream<Integer> getMachines() {
        return this.machines.keySet().stream();
    }
}

