/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.core.Registration;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class DimensionUtil {
    public static void createAndRegisterWorldAndDimension(MinecraftServer server) {
        Map map = server.forgeGetWorldMap();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)Registration.COMPACT_DIMENSION.m_135782_());
        ResourceManager serverResources = server.m_177941_();
        if (FMLEnvironment.production && !DimensionUtil.doLevelFileBackup(server)) {
            return;
        }
        RegistryAccess.Frozen reg = server.m_206579_();
        DimensionType cmDimType = (DimensionType)reg.m_175515_(Registry.f_122818_).m_6246_(Registration.COMPACT_DIMENSION_DIM_TYPE);
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)reg);
        RegistryResourceAccess resourceAccess = RegistryResourceAccess.m_195881_((ResourceManager)serverResources);
        Collection dims = resourceAccess.m_183590_(Registry.f_122819_);
        Optional<ResourceKey> cmDim = dims.stream().filter(d -> d.m_135782_().equals((Object)Registration.COMPACT_DIMENSION.m_135782_())).findFirst();
        cmDim.ifPresent(lev -> {
            Optional parsed = resourceAccess.m_183313_((DynamicOps)ops, Registry.f_122820_, dimensionKey, (Decoder)LevelStem.f_63970_);
            LevelStem stem = (LevelStem)((RegistryResourceAccess.ParsedEntry)((DataResult)parsed.orElseThrow()).result().orElseThrow()).f_195950_();
            ChunkProgressListener chunkProgressListener = server.f_129756_.m_9620_(11);
            Executor executor = server.f_129738_;
            LevelStorageSource.LevelStorageAccess anvilConverter = server.f_129744_;
            WorldData worldData = server.m_129910_();
            WorldGenSettings worldGenSettings = worldData.m_5961_();
            DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, worldData.m_5996_());
            Registry patt4190$temp = worldGenSettings.m_204655_();
            if (!(patt4190$temp instanceof MappedRegistry)) {
                CompactMachines.LOGGER.fatal("Failed to re-register compact machines dimension; registry was not the expected class type.");
                return;
            }
            MappedRegistry stems = (MappedRegistry)patt4190$temp;
            stems.unfreeze();
            Registry.m_194579_((Registry)stems, (ResourceKey)dimensionKey, (Object)stem);
            stems.m_203521_();
            ServerLevel newWorld = new ServerLevel(server, executor, anvilConverter, (ServerLevelData)derivedLevelData, Registration.COMPACT_DIMENSION, Holder.m_205709_((Object)cmDimType), chunkProgressListener, stem.m_63990_(), worldGenSettings.m_64668_(), BiomeManager.m_47877_((long)worldGenSettings.m_64619_()), (List)ImmutableList.of(), false);
            overworld.m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newWorld.m_6857_()));
            map.put(Registration.COMPACT_DIMENSION, newWorld);
            server.markWorldsDirty();
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((LevelAccessor)newWorld));
        });
    }

    public static boolean doLevelFileBackup(MinecraftServer server) {
        Path levelRoot = server.m_129843_(LevelResource.f_78182_);
        Path levelFile = server.m_129843_(LevelResource.f_78178_);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("'cm4-level-'yyyyMMdd-HHmmss'.dat'");
        String timestamp = formatter.format(ZonedDateTime.now());
        try {
            Files.copy(levelFile, levelRoot.resolve(timestamp), new CopyOption[0]);
        }
        catch (IOException e) {
            CompactMachines.LOGGER.error("Failed to backup level.dat file before modification; canceling register dim attempt.");
            return false;
        }
        return true;
    }
}

