/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.util;

import com.mojang.authlib.GameProfile;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.advancement.AdvancementTriggers;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.core.Capabilities;
import dev.compactmods.machines.core.DimensionalPosition;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.CompactMachineBlockEntity;
import dev.compactmods.machines.machine.Machines;
import dev.compactmods.machines.room.RoomSize;
import dev.compactmods.machines.room.Rooms;
import dev.compactmods.machines.room.history.IRoomHistoryItem;
import dev.compactmods.machines.room.history.PlayerRoomHistoryItem;
import dev.compactmods.machines.util.LocationUtil;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public abstract class PlayerUtil {
    public static Optional<GameProfile> getProfileByUUID(LevelAccessor world, UUID uuid) {
        Player player = world.m_46003_(uuid);
        if (player == null) {
            return Optional.empty();
        }
        GameProfile profile = player.m_36316_();
        return Optional.of(profile);
    }

    public static void teleportPlayerIntoMachine(Level level, Player player, BlockPos machinePos, RoomSize size) {
        boolean grantAdvancement;
        MinecraftServer serv = level.m_142572_();
        ServerLevel compactWorld = serv.m_129880_(Registration.COMPACT_DIMENSION);
        if (compactWorld == null) {
            CompactMachines.LOGGER.warn("Compact dimension not found; player attempted to enter machine.");
            return;
        }
        CompactMachineBlockEntity tile = (CompactMachineBlockEntity)level.m_7702_(machinePos);
        if (tile == null) {
            return;
        }
        boolean bl = grantAdvancement = !tile.mapped();
        if (!tile.mapped()) {
            try {
                ChunkPos newRoomPos = Rooms.createNew(serv, size, player.m_142081_());
                Machines.createAndLink(serv, level, machinePos, tile, newRoomPos);
            }
            catch (MissingDimensionException e) {
                CompactMachines.LOGGER.error("Error occurred while generating new room and machine info for first player entry.", (Throwable)e);
                return;
            }
        }
        serv.m_18689_(() -> {
            Vec3 sr;
            DimensionalPosition spawn = tile.getSpawn().orElse(null);
            if (spawn == null) {
                CompactMachines.LOGGER.error("Machine " + tile.machineId + " could not load spawn info.");
                return;
            }
            try {
                PlayerUtil.addPlayerToMachine(player, machinePos);
            }
            catch (Exception ex) {
                CompactMachines.LOGGER.error((Object)ex);
            }
            Vec3 sp = spawn.getPosition();
            Vec3 vec3 = sr = spawn.getRotation() != Vec3.f_82478_ ? spawn.getRotation() : new Vec3((double)player.f_19860_, (double)player.f_19859_, 0.0);
            if (player instanceof ServerPlayer) {
                ServerPlayer servPlayer = (ServerPlayer)player;
                servPlayer.m_8999_(compactWorld, sp.f_82479_, sp.f_82480_, sp.f_82481_, (float)sr.f_82480_, (float)sr.f_82479_);
                if (grantAdvancement) {
                    AdvancementTriggers.getTriggerForMachineClaim(size).trigger(servPlayer);
                }
            }
        });
    }

    public static void teleportPlayerOutOfMachine(ServerLevel world, @Nonnull ServerPlayer serverPlayer) {
        MinecraftServer serv = world.m_142572_();
        LazyOptional history = serverPlayer.getCapability(Capabilities.ROOM_HISTORY);
        if (!history.isPresent()) {
            PlayerUtil.howDidYouGetThere(serverPlayer);
            return;
        }
        history.ifPresent(hist -> {
            ChunkPos currentRoomChunk = new ChunkPos(serverPlayer.m_142538_());
            if (hist.hasHistory()) {
                IRoomHistoryItem prevArea = hist.pop();
                DimensionalPosition spawnPoint = prevArea.getEntryLocation();
                ServerLevel w = spawnPoint.level(serv).orElse(serv.m_129783_());
                if (serv.m_129880_(spawnPoint.getDimension()) != null) {
                    Vec3 worldPos = spawnPoint.getPosition();
                    Vec3 entryRot = spawnPoint.getRotation();
                    serverPlayer.m_8999_(w, worldPos.m_7096_(), worldPos.m_7098_(), worldPos.m_7094_(), (float)entryRot.f_82480_, (float)entryRot.f_82479_);
                } else {
                    hist.clear();
                    PlayerUtil.teleportPlayerToRespawnOrOverworld(serv, serverPlayer);
                }
            } else {
                PlayerUtil.howDidYouGetThere(serverPlayer);
                hist.clear();
                PlayerUtil.teleportPlayerToRespawnOrOverworld(serv, serverPlayer);
            }
            LevelChunk chunk = serv.m_129880_(Registration.COMPACT_DIMENSION).m_6325_(currentRoomChunk.f_45578_, currentRoomChunk.f_45579_);
        });
    }

    public static void howDidYouGetThere(@Nonnull ServerPlayer serverPlayer) {
        AdvancementTriggers.HOW_DID_YOU_GET_HERE.trigger(serverPlayer);
        serverPlayer.m_5661_((Component)TranslationUtil.message(Messages.HOW_DID_YOU_GET_HERE), true);
    }

    public static void teleportPlayerToRespawnOrOverworld(MinecraftServer serv, @Nonnull ServerPlayer player) {
        ServerLevel level = Optional.ofNullable(serv.m_129880_(player.m_8963_())).orElse(serv.m_129783_());
        Vec3 worldPos = LocationUtil.blockPosToVector(level.m_8900_());
        if (player.m_8961_() != null) {
            worldPos = LocationUtil.blockPosToVector(player.m_8961_());
        }
        player.m_8999_(level, worldPos.m_7096_(), worldPos.m_7098_(), worldPos.m_7094_(), 0.0f, player.m_8962_());
    }

    public static void addPlayerToMachine(Player player, BlockPos machinePos) {
        MinecraftServer serv = player.m_20194_();
        if (serv == null) {
            return;
        }
        CompactMachineBlockEntity tile = (CompactMachineBlockEntity)player.m_183503_().m_7702_(machinePos);
        if (tile == null) {
            return;
        }
        tile.getInternalChunkPos().ifPresent(mChunk -> {
            LevelChunk chunk = serv.m_129880_(Registration.COMPACT_DIMENSION).m_6325_(mChunk.f_45578_, mChunk.f_45579_);
            player.getCapability(Capabilities.ROOM_HISTORY).ifPresent(hist -> {
                DimensionalPosition pos = DimensionalPosition.fromEntity((LivingEntity)player);
                hist.addHistory(new PlayerRoomHistoryItem(pos, tile.machineId));
            });
        });
    }
}

