/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mekanism.client.SpecialColors;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiRedstoneControlTab
extends GuiInsetElement<TileEntityMekanism> {
    private static final ResourceLocation DISABLED = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "redstone_control_disabled.png");
    private static final ResourceLocation HIGH = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "redstone_control_high.png");
    private static final ResourceLocation LOW = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "redstone_control_low.png");

    public GuiRedstoneControlTab(IGuiWrapper gui, TileEntityMekanism tile) {
        super(DISABLED, gui, tile, gui.getWidth(), 137, 26, 18, false);
    }

    @Override
    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        this.displayTooltips(matrix, mouseX, mouseY, ((TileEntityMekanism)this.dataSource).getControlType().getTextComponent());
    }

    public void m_5716_(double mouseX, double mouseY) {
        Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.NEXT_REDSTONE_CONTROL, (BlockEntity)this.dataSource));
    }

    @Override
    protected ResourceLocation getOverlay() {
        return switch (((TileEntityMekanism)this.dataSource).getControlType()) {
            case IRedstoneControl.RedstoneControl.HIGH -> HIGH;
            case IRedstoneControl.RedstoneControl.LOW -> LOW;
            default -> super.getOverlay();
        };
    }

    @Override
    protected void colorTab() {
        MekanismRenderer.color(SpecialColors.TAB_REDSTONE_CONTROL);
    }

    @Override
    protected void drawBackgroundOverlay(@Nonnull PoseStack matrix) {
        if (((TileEntityMekanism)this.dataSource).getControlType() == IRedstoneControl.RedstoneControl.PULSE) {
            GuiUtils.drawSprite(matrix, this.getButtonX() + 1, this.getButtonY() + 1, this.innerWidth - 2, this.innerHeight - 2, 0, MekanismRenderer.redstonePulse);
        } else {
            super.drawBackgroundOverlay(matrix);
        }
    }
}

