/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.function.ToIntFunction;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class Attributes {
    public static final Attribute ACTIVE = new AttributeStateActive(0);
    public static final Attribute ACTIVE_LIGHT = new AttributeStateActive(8);
    public static final Attribute ACTIVE_FULL_LIGHT = new AttributeStateActive(15);
    public static final Attribute COMPARATOR = new AttributeComparator();
    public static final Attribute INVENTORY = new AttributeInventory();
    public static final Attribute MULTIBLOCK = new AttributeMultiblock();
    public static final Attribute REDSTONE = new AttributeRedstone();
    public static final Attribute SECURITY = new AttributeSecurity();

    private Attributes() {
    }

    public static class AttributeComparator
    implements Attribute {
        private AttributeComparator() {
        }
    }

    public static class AttributeInventory
    implements Attribute {
        private AttributeInventory() {
        }
    }

    public static class AttributeMultiblock
    implements Attribute {
        private AttributeMultiblock() {
        }
    }

    public static class AttributeRedstone
    implements Attribute {
        private AttributeRedstone() {
        }
    }

    public static class AttributeSecurity
    implements Attribute {
        private AttributeSecurity() {
        }
    }

    public static class AttributeLight
    implements Attribute {
        private final int light;

        public AttributeLight(int light) {
            this.light = light;
        }

        @Override
        public void adjustProperties(BlockBehaviour.Properties props) {
            BlockStateHelper.applyLightLevelAdjustments(props, state -> this.light);
        }
    }

    public static class AttributeCustomResistance
    implements Attribute {
        private final float resistance;

        public AttributeCustomResistance(float resistance) {
            this.resistance = resistance;
        }

        public float getResistance() {
            return this.resistance;
        }
    }

    public static class AttributeRedstoneEmitter<TILE extends TileEntityMekanism>
    implements Attribute.TileAttribute<TILE> {
        private final ToIntFunction<TILE> redstoneFunction;

        public AttributeRedstoneEmitter(ToIntFunction<TILE> redstoneFunction) {
            this.redstoneFunction = redstoneFunction;
        }

        public int getRedstoneLevel(TILE tile) {
            return this.redstoneFunction.applyAsInt(tile);
        }
    }

    public static class AttributeMobSpawn
    implements Attribute {
        public static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> NEVER_PREDICATE = (state, reader, pos, entityType) -> false;
        public static final AttributeMobSpawn NEVER = new AttributeMobSpawn(NEVER_PREDICATE);
        public static final AttributeMobSpawn WHEN_NOT_FORMED = new AttributeMobSpawn((state, reader, pos, entityType) -> {
            LevelReader levelReader;
            TileEntityMultiblock tile = WorldUtils.getTileEntity(TileEntityMultiblock.class, reader, pos);
            if (tile != null && (reader instanceof LevelReader && (levelReader = (LevelReader)reader).m_5776_() ? tile.getMultiblock().isFormed() : tile.getMultiblock().isPositionInsideBounds(tile.getStructure(), pos.m_7494_()))) {
                return false;
            }
            return state.m_60783_(reader, pos, Direction.UP) && state.getLightEmission(reader, pos) < 14;
        });
        private final BlockBehaviour.StateArgumentPredicate<EntityType<?>> spawningPredicate;

        public AttributeMobSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> spawningPredicate) {
            this.spawningPredicate = spawningPredicate;
        }

        @Override
        public void adjustProperties(BlockBehaviour.Properties props) {
            props.m_60922_(this.spawningPredicate);
        }
    }

    public static class AttributeComputerIntegration
    implements Attribute {
        public final String name;

        public AttributeComputerIntegration(String name) {
            this.name = name;
        }
    }
}

