/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.common.capabilities.holder.IHolder;
import net.minecraft.core.Direction;

public class BasicHolder<TYPE>
implements IHolder {
    private final Map<RelativeSide, List<TYPE>> directionalSlots = new EnumMap<RelativeSide, List<TYPE>>(RelativeSide.class);
    private final List<TYPE> inventorySlots = new ArrayList<TYPE>();
    protected final Supplier<Direction> facingSupplier;

    protected BasicHolder(Supplier<Direction> facingSupplier) {
        this.facingSupplier = facingSupplier;
    }

    protected void addSlotInternal(@Nonnull TYPE slot, RelativeSide ... sides) {
        this.inventorySlots.add(slot);
        for (RelativeSide side : sides) {
            this.directionalSlots.computeIfAbsent(side, k -> new ArrayList()).add(slot);
        }
    }

    @Nonnull
    public List<TYPE> getSlots(@Nullable Direction side) {
        if (side == null || this.directionalSlots.isEmpty()) {
            return this.inventorySlots;
        }
        List<TYPE> slots = this.directionalSlots.get(RelativeSide.fromDirections(this.facingSupplier.get(), side));
        if (slots == null) {
            return Collections.emptyList();
        }
        return slots;
    }
}

