/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.sps;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumSet;
import java.util.Set;
import mekanism.common.MekanismLang;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.lib.multiblock.StructureHelper;
import mekanism.common.registries.MekanismBlockTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;

public class SPSValidator
extends CuboidStructureValidator<SPSMultiblockData> {
    private static final VoxelCuboid BOUNDS = new VoxelCuboid(7, 7, 7);
    private static final byte[][] ALLOWED_GRID = new byte[][]{{0, 0, 1, 1, 1, 0, 0}, {0, 1, 2, 2, 2, 1, 0}, {1, 2, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 2, 1}, {0, 1, 2, 2, 2, 1, 0}, {0, 0, 1, 1, 1, 0, 0}};

    @Override
    protected FormationProtocol.StructureRequirement getStructureRequirement(BlockPos pos) {
        VoxelCuboid.WallRelative relative = this.cuboid.getWallRelative(pos);
        if (relative.isWall()) {
            Structure.Axis axis = Structure.Axis.get(this.cuboid.getSide(pos));
            Structure.Axis h = axis.horizontal();
            Structure.Axis v = axis.vertical();
            pos = pos.m_141950_((Vec3i)this.cuboid.getMinPos());
            return FormationProtocol.StructureRequirement.REQUIREMENTS[ALLOWED_GRID[h.getCoord(pos)][v.getCoord(pos)]];
        }
        return super.getStructureRequirement(pos);
    }

    @Override
    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.m_60734_();
        if (BlockType.is(block, MekanismBlockTypes.SPS_CASING)) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is(block, MekanismBlockTypes.SPS_PORT)) {
            return FormationProtocol.CasingType.VALVE;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    @Override
    protected boolean validateInner(BlockState state, Long2ObjectMap<ChunkAccess> chunkMap, BlockPos pos) {
        if (super.validateInner(state, chunkMap, pos)) {
            return true;
        }
        return BlockType.is(state.m_60734_(), MekanismBlockTypes.SUPERCHARGED_COIL);
    }

    @Override
    public boolean precheck() {
        this.cuboid = StructureHelper.fetchCuboid(this.structure, BOUNDS, BOUNDS, EnumSet.allOf(VoxelCuboid.CuboidSide.class), 72);
        return this.cuboid != null;
    }

    @Override
    public FormationProtocol.FormationResult postcheck(SPSMultiblockData structure, Set<BlockPos> innerNodes, Long2ObjectMap<ChunkAccess> chunkMap) {
        ObjectOpenHashSet validCoils = new ObjectOpenHashSet();
        for (IValveHandler.ValveData valve : structure.valves) {
            BlockPos pos = valve.location.m_142300_(valve.side.m_122424_());
            if (!innerNodes.contains(pos)) continue;
            structure.addCoil(valve.location, valve.side.m_122424_());
            validCoils.add(pos);
        }
        if (innerNodes.stream().anyMatch(arg_0 -> SPSValidator.lambda$postcheck$0((Set)validCoils, arg_0))) {
            return FormationProtocol.FormationResult.fail(MekanismLang.SPS_INVALID_DISCONNECTED_COIL);
        }
        return FormationProtocol.FormationResult.SUCCESS;
    }

    private static /* synthetic */ boolean lambda$postcheck$0(Set validCoils, BlockPos coil) {
        return !validCoils.contains(coil);
    }
}

