/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.DoublePredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.oredictionificator.OredictionificatorFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.integration.computer.ComputerArgumentHandler;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.util.text.InputValidator;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.VisibleForTesting;

public class CCArgumentWrapper
extends ComputerArgumentHandler<LuaException, MethodResult> {
    private static final double MAX_FLOATING_LONG_AS_DOUBLE = Double.parseDouble(FloatingLong.MAX_VALUE.toString());
    @VisibleForTesting
    static final String TYPE_HINT_KEY = "typeHint";
    @VisibleForTesting
    static final Double TYPE_HINT_VALUE_KEY = 0.0;
    private final IArguments arguments;

    CCArgumentWrapper(IArguments arguments) {
        this.arguments = arguments;
    }

    @Override
    public int getCount() {
        return this.arguments.count();
    }

    @Override
    public LuaException error(String messageFormat, Object ... args) {
        return new LuaException(this.formatError(messageFormat, args));
    }

    @Override
    @Nullable
    public Object getArgument(int index) {
        return this.arguments.get(index);
    }

    @Override
    public Object sanitizeArgument(Class<?> expectedType, Class<?> argumentType, Object argument) {
        Tag sanitized;
        if (argumentType == Double.class) {
            double d = (Double)argument;
            if (Double.isFinite(d)) {
                Enum[] enumConstants;
                if (expectedType == Byte.TYPE || expectedType == Byte.class) {
                    if (d >= -128.0 && d <= 127.0) {
                        return (byte)d;
                    }
                } else if (expectedType == Short.TYPE || expectedType == Short.class) {
                    if (d >= -32768.0 && d <= 32767.0) {
                        return (short)d;
                    }
                } else if (expectedType == Integer.TYPE || expectedType == Integer.class) {
                    if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                        return (int)d;
                    }
                } else if (expectedType == Long.TYPE || expectedType == Long.class) {
                    if (d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                        return (long)d;
                    }
                } else if (expectedType == Float.TYPE || expectedType == Float.class) {
                    if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
                        return Float.valueOf((float)d);
                    }
                } else if (expectedType == FloatingLong.class) {
                    if (d >= 0.0 && d <= MAX_FLOATING_LONG_AS_DOUBLE) {
                        return FloatingLong.createConst(d);
                    }
                } else if (expectedType.isEnum() && d >= 0.0 && d < (double)(enumConstants = (Enum[])expectedType.getEnumConstants()).length) {
                    return enumConstants[(int)d];
                }
            }
        } else if (argumentType == String.class) {
            Item item;
            if (expectedType == char[].class) {
                return ((String)argument).toCharArray();
            }
            if (expectedType == Character.TYPE || expectedType == Character.class) {
                String string = (String)argument;
                if (string.length() == 1) {
                    return Character.valueOf(string.charAt(0));
                }
            } else if (expectedType == ResourceLocation.class) {
                ResourceLocation rl = ResourceLocation.m_135820_((String)((String)argument));
                if (rl != null) {
                    return rl;
                }
            } else if (expectedType == FloatingLong.class) {
                try {
                    return FloatingLong.parseFloatingLong((String)argument);
                }
                catch (NumberFormatException rl) {
                }
            } else if (expectedType.isEnum()) {
                Object sanitized2 = CCArgumentWrapper.sanitizeStringToEnum(expectedType, (String)argument);
                if (sanitized2 != null) {
                    return sanitized2;
                }
            } else if (Item.class.isAssignableFrom(expectedType) && expectedType.isInstance(item = CCArgumentWrapper.tryCreateItem(argument))) {
                return item;
            }
        } else if (argument instanceof Map) {
            Object sanitized3;
            Map arg = (Map)argument;
            if (IFilter.class.isAssignableFrom(expectedType) && (sanitized3 = CCArgumentWrapper.convertMapToFilter(expectedType, arg)) != null) {
                return sanitized3;
            }
        }
        if (Tag.class.isAssignableFrom(expectedType) && (sanitized = CCArgumentWrapper.sanitizeNBT(expectedType, argumentType, argument)) != null) {
            return sanitized;
        }
        return super.sanitizeArgument(expectedType, argumentType, argument);
    }

    @Override
    public MethodResult noResult() {
        return MethodResult.of();
    }

    @Override
    public MethodResult wrapResult(Object result) {
        return MethodResult.of((Object)CCArgumentWrapper.wrapReturnType(result));
    }

    private static Object wrapReturnType(Object result) {
        if (result == null || result instanceof Number || result instanceof Boolean || result instanceof String) {
            return result;
        }
        if (result instanceof ResourceLocation || result instanceof UUID) {
            return result.toString();
        }
        if (result instanceof ForgeRegistryEntry) {
            ForgeRegistryEntry registryEntry = (ForgeRegistryEntry)result;
            return CCArgumentWrapper.getName(registryEntry);
        }
        if (result instanceof ChemicalStack) {
            ChemicalStack stack = (ChemicalStack)result;
            HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
            wrapped.put("name", CCArgumentWrapper.getName(stack.getType()));
            wrapped.put("amount", stack.getAmount());
            return wrapped;
        }
        if (result instanceof FluidStack) {
            FluidStack stack = (FluidStack)result;
            return CCArgumentWrapper.wrapStack(stack.getFluid(), "amount", stack.getAmount(), stack.getTag());
        }
        if (result instanceof ItemStack) {
            ItemStack stack = (ItemStack)result;
            return CCArgumentWrapper.wrapStack(stack.m_41720_(), "count", stack.m_41613_(), stack.m_41783_());
        }
        if (result instanceof Tag) {
            Tag tag = (Tag)result;
            Object wrapped = CCArgumentWrapper.wrapNBT(tag);
            if (wrapped != null) {
                return wrapped;
            }
        } else {
            if (result instanceof Vec3i) {
                Vec3i pos = (Vec3i)result;
                HashMap<String, Integer> wrapped = new HashMap<String, Integer>(3);
                wrapped.put("x", pos.m_123341_());
                wrapped.put("y", pos.m_123342_());
                wrapped.put("z", pos.m_123343_());
                return wrapped;
            }
            if (result instanceof Coord4D) {
                Coord4D coord = (Coord4D)result;
                HashMap<String, Object> wrapped = new HashMap<String, Object>(4);
                wrapped.put("x", coord.getX());
                wrapped.put("y", coord.getY());
                wrapped.put("z", coord.getZ());
                wrapped.put("dimension", CCArgumentWrapper.wrapReturnType(coord.dimension.m_135782_()));
                return wrapped;
            }
            if (result instanceof Frequency) {
                Frequency frequency = (Frequency)result;
                Frequency.FrequencyIdentity identity = frequency.getIdentity();
                HashMap<String, Object> wrapped = new HashMap<String, Object>(2);
                wrapped.put("key", CCArgumentWrapper.wrapReturnType(identity.key()));
                wrapped.put("public", identity.isPublic());
                return wrapped;
            }
            if (result instanceof Enum) {
                Enum res = (Enum)result;
                return res.name();
            }
            if (result instanceof IFilter) {
                IFilter res = (IFilter)result;
                HashMap<String, Object> wrapped = new HashMap<String, Object>();
                wrapped.put("type", CCArgumentWrapper.wrapReturnType((Object)res.getFilterType()));
                if (result instanceof IItemStackFilter) {
                    CompoundTag tag;
                    IItemStackFilter itemFilter = (IItemStackFilter)result;
                    ItemStack stack = itemFilter.getItemStack();
                    wrapped.put("item", CCArgumentWrapper.wrapReturnType(stack.m_41720_()));
                    if (!stack.m_41619_() && (tag = stack.m_41783_()) != null && !tag.m_128456_()) {
                        wrapped.put("itemNBT", CCArgumentWrapper.wrapNBT((Tag)tag));
                    }
                } else if (result instanceof IMaterialFilter) {
                    IMaterialFilter materialFilter = (IMaterialFilter)result;
                    wrapped.put("materialItem", CCArgumentWrapper.wrapReturnType(materialFilter.getMaterialItem().m_41720_()));
                } else if (result instanceof IModIDFilter) {
                    IModIDFilter modIDFilter = (IModIDFilter)result;
                    wrapped.put("modId", modIDFilter.getModID());
                } else if (result instanceof ITagFilter) {
                    ITagFilter tagFilter = (ITagFilter)result;
                    wrapped.put("tag", tagFilter.getTagName());
                }
                if (result instanceof MinerFilter) {
                    MinerFilter minerFilter = (MinerFilter)result;
                    wrapped.put("requiresReplacement", minerFilter.requiresReplacement);
                    wrapped.put("replaceTarget", CCArgumentWrapper.wrapReturnType(minerFilter.replaceTarget));
                } else if (result instanceof SorterFilter) {
                    SorterFilter sorterFilter = (SorterFilter)result;
                    wrapped.put("allowDefault", sorterFilter.allowDefault);
                    wrapped.put("color", CCArgumentWrapper.wrapReturnType(sorterFilter.color));
                    wrapped.put("size", sorterFilter.sizeMode);
                    wrapped.put("min", sorterFilter.min);
                    wrapped.put("max", sorterFilter.max);
                    if (sorterFilter instanceof SorterItemStackFilter) {
                        filter = (SorterItemStackFilter)sorterFilter;
                        wrapped.put("fuzzy", ((SorterItemStackFilter)filter).fuzzyMode);
                    }
                } else if (result instanceof QIOFilter) {
                    QIOFilter qioFilter = (QIOFilter)result;
                    if (qioFilter instanceof QIOItemStackFilter) {
                        filter = (QIOItemStackFilter)qioFilter;
                        wrapped.put("fuzzy", filter.fuzzyMode);
                    }
                } else if (result instanceof OredictionificatorFilter) {
                    OredictionificatorFilter filter = (OredictionificatorFilter)result;
                    wrapped.put("target", filter.getFilterText());
                    wrapped.put("selected", CCArgumentWrapper.wrapReturnType(filter.getResultElement()));
                }
                return wrapped;
            }
            if (result instanceof Map) {
                Map res = (Map)result;
                return res.entrySet().stream().collect(Collectors.toMap(entry -> CCArgumentWrapper.wrapReturnType(entry.getKey()), entry -> CCArgumentWrapper.wrapReturnType(entry.getValue()), (a, b) -> b));
            }
            if (result instanceof Collection) {
                Collection res = (Collection)result;
                return res.stream().map(CCArgumentWrapper::wrapReturnType).toList();
            }
            if (result instanceof Object[]) {
                Object[] res = (Object[])result;
                return Arrays.stream(res).map(CCArgumentWrapper::wrapReturnType).toArray();
            }
        }
        return result;
    }

    private static Map<String, Object> wrapStack(ForgeRegistryEntry<?> entry, String sizeKey, int amount, @Nullable CompoundTag tag) {
        boolean hasTag = tag != null && !tag.m_128456_() && amount > 0;
        HashMap<String, Object> wrapped = new HashMap<String, Object>(hasTag ? 3 : 2);
        wrapped.put("name", CCArgumentWrapper.getName(entry));
        wrapped.put(sizeKey, amount);
        if (hasTag) {
            wrapped.put("nbt", CCArgumentWrapper.wrapNBT((Tag)tag));
        }
        return wrapped;
    }

    @Nullable
    private static Object wrapNBT(@Nullable Tag nbt) {
        if (nbt == null) {
            return null;
        }
        switch (nbt.m_7060_()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 99: {
                return ((NumericTag)nbt).m_8103_();
            }
            case 0: 
            case 8: {
                return nbt.m_7916_();
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                CollectionTag collectionNBT = (CollectionTag)nbt;
                int size = collectionNBT.size();
                HashMap<Integer, Object> wrappedCollection = new HashMap<Integer, Object>(size);
                for (int i = 0; i < size; ++i) {
                    wrappedCollection.put(i, CCArgumentWrapper.wrapNBT((Tag)collectionNBT.get(i)));
                }
                return wrappedCollection;
            }
            case 10: {
                CompoundTag compound = (CompoundTag)nbt;
                HashMap<String, Object> wrappedCompound = new HashMap<String, Object>(compound.m_128440_());
                for (String key : compound.m_128431_()) {
                    Object value = CCArgumentWrapper.wrapNBT(compound.m_128423_(key));
                    if (value == null) continue;
                    wrappedCompound.put(key, value);
                }
                return wrappedCompound;
            }
        }
        return null;
    }

    private static String getName(ForgeRegistryEntry<?> entry) {
        ResourceLocation registryName = entry.getRegistryName();
        return registryName == null ? null : registryName.toString();
    }

    @Nullable
    private static <ENUM extends Enum<?>> ENUM sanitizeStringToEnum(Class<? extends ENUM> expectedType, String argument) {
        if (!argument.isEmpty()) {
            Enum[] enumConstants;
            for (Enum enumConstant : enumConstants = (Enum[])expectedType.getEnumConstants()) {
                if (!argument.equalsIgnoreCase(enumConstant.name())) continue;
                return (ENUM)enumConstant;
            }
        }
        return null;
    }

    private static ItemStack tryCreateFilterItem(@Nullable Object rawName, @Nullable Object rawNBT) {
        Item item = CCArgumentWrapper.tryCreateItem(rawName);
        if (item == Items.f_41852_) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (rawNBT != null) {
            Tag nbt = CCArgumentWrapper.sanitizeNBT(CompoundTag.class, rawNBT.getClass(), rawNBT);
            if (!(nbt instanceof CompoundTag)) {
                return ItemStack.f_41583_;
            }
            stack.m_41751_((CompoundTag)nbt);
        }
        return stack;
    }

    private static Item tryCreateItem(@Nullable Object rawName) {
        Item item;
        String name;
        ResourceLocation itemName;
        if (rawName instanceof String && (itemName = ResourceLocation.m_135820_((String)(name = (String)rawName))) != null && (item = (Item)ForgeRegistries.ITEMS.getValue(itemName)) != null) {
            return item;
        }
        return Items.f_41852_;
    }

    @Nullable
    private static String tryGetFilterTag(@Nullable Object rawTag) {
        String tag;
        if (rawTag instanceof String && !(tag = (String)rawTag).isEmpty() && InputValidator.test(tag = tag.toLowerCase(Locale.ROOT), InputValidator.RESOURCE_LOCATION.or(InputValidator.WILDCARD_CHARS))) {
            return tag;
        }
        return null;
    }

    @Nullable
    private static String tryGetFilterModId(@Nullable Object rawModId) {
        String modId;
        if (rawModId instanceof String && !(modId = (String)rawModId).isEmpty() && InputValidator.test(modId = modId.toLowerCase(Locale.ROOT), InputValidator.RL_NAMESPACE.or(InputValidator.WILDCARD_CHARS))) {
            return modId;
        }
        return null;
    }

    private static boolean getBooleanFromRaw(@Nullable Object raw) {
        boolean bl;
        if (raw instanceof Boolean) {
            Boolean bool = (Boolean)raw;
            bl = bool;
        } else {
            bl = false;
        }
        return bl;
    }

    private static int getIntFromRaw(@Nullable Object raw) {
        int n;
        if (raw instanceof Number) {
            Number number = (Number)raw;
            n = number.intValue();
        } else {
            n = 0;
        }
        return n;
    }

    @Nullable
    private static Object convertMapToFilter(Class<?> expectedType, Map<?, ?> map) {
        IFilter<?> filter;
        String string;
        FilterType filterType;
        Object type = map.get("type");
        if (type instanceof String && (filterType = CCArgumentWrapper.sanitizeStringToEnum(FilterType.class, string = (String)type)) != null && expectedType.isInstance(filter = BaseFilter.fromType(filterType))) {
            if (filter instanceof IItemStackFilter) {
                IItemStackFilter itemFilter = (IItemStackFilter)filter;
                stack = CCArgumentWrapper.tryCreateFilterItem(map.get("item"), map.get("itemNBT"));
                if (stack.m_41619_()) {
                    return null;
                }
                itemFilter.setItemStack(stack);
            } else if (filter instanceof IMaterialFilter) {
                IMaterialFilter materialFilter = (IMaterialFilter)filter;
                stack = CCArgumentWrapper.tryCreateFilterItem(map.get("materialItem"), null);
                if (stack.m_41619_()) {
                    return null;
                }
                materialFilter.setMaterialItem(stack);
            } else if (filter instanceof IModIDFilter) {
                IModIDFilter modIDFilter = (IModIDFilter)filter;
                String modId = CCArgumentWrapper.tryGetFilterModId(map.get("modId"));
                if (modId == null) {
                    return null;
                }
                modIDFilter.setModID(modId);
            } else if (filter instanceof ITagFilter) {
                ITagFilter tagFilter = (ITagFilter)filter;
                String tag = CCArgumentWrapper.tryGetFilterTag(map.get("tag"));
                if (tag == null) {
                    return null;
                }
                tagFilter.setTagName(tag);
            }
            if (filter instanceof MinerFilter) {
                MinerFilter minerFilter = (MinerFilter)filter;
                minerFilter.requiresReplacement = CCArgumentWrapper.getBooleanFromRaw(map.get("requiresReplacement"));
                minerFilter.replaceTarget = CCArgumentWrapper.tryCreateItem(map.get("replaceTarget"));
            } else if (filter instanceof SorterFilter) {
                SorterFilter sorterFilter = (SorterFilter)filter;
                sorterFilter.allowDefault = CCArgumentWrapper.getBooleanFromRaw(map.get("allowDefault"));
                Object rawColor = map.get("color");
                if (rawColor instanceof String) {
                    sorterFilter.color = CCArgumentWrapper.sanitizeStringToEnum(EnumColor.class, (String)rawColor);
                }
                sorterFilter.sizeMode = CCArgumentWrapper.getBooleanFromRaw(map.get("size"));
                sorterFilter.min = CCArgumentWrapper.getIntFromRaw(map.get("min"));
                sorterFilter.max = CCArgumentWrapper.getIntFromRaw(map.get("max"));
                if (sorterFilter.min < 0 || sorterFilter.max < 0 || sorterFilter.min > sorterFilter.max || sorterFilter.max > 64) {
                    return null;
                }
                if (sorterFilter instanceof SorterItemStackFilter) {
                    SorterItemStackFilter sorterItemFilter = (SorterItemStackFilter)sorterFilter;
                    sorterItemFilter.fuzzyMode = CCArgumentWrapper.getBooleanFromRaw(map.get("fuzzy"));
                }
            } else if (filter instanceof QIOFilter) {
                QIOFilter qioFilter = (QIOFilter)filter;
                if (qioFilter instanceof QIOItemStackFilter) {
                    QIOItemStackFilter qioItemFilter = (QIOItemStackFilter)qioFilter;
                    qioItemFilter.fuzzyMode = CCArgumentWrapper.getBooleanFromRaw(map.get("fuzzy"));
                }
            } else if (filter instanceof OredictionificatorFilter) {
                OredictionificatorFilter oredictionificatorFilter = (OredictionificatorFilter)filter;
                Object rawTag = map.get("target");
                if (!(rawTag instanceof String)) {
                    return null;
                }
                String tag = (String)rawTag;
                if (tag.isEmpty()) {
                    return null;
                }
                ResourceLocation rl = ResourceLocation.m_135820_((String)tag);
                if (rl == null || !TileEntityOredictionificator.isValidTarget(rl)) {
                    return null;
                }
                oredictionificatorFilter.setFilter(rl);
                if (oredictionificatorFilter instanceof OredictionificatorItemFilter) {
                    OredictionificatorItemFilter itemFilter = (OredictionificatorItemFilter)oredictionificatorFilter;
                    Item item = CCArgumentWrapper.tryCreateItem(map.get("selected"));
                    if (item != Items.f_41852_) {
                        itemFilter.setSelectedOutput(item);
                    }
                }
            }
            return filter;
        }
        return null;
    }

    @Nullable
    private static Tag sanitizeNBT(Class<?> expectedType, Class<?> argumentType, Object argument) {
        if (argumentType == Boolean.class) {
            if (expectedType == ByteTag.class || expectedType == NumericTag.class || expectedType == Tag.class) {
                return ByteTag.m_128273_((boolean)((Boolean)argument));
            }
        } else if (argumentType == Double.class) {
            double d = (Double)argument;
            if (Double.isFinite(d)) {
                if (expectedType == ByteTag.class) {
                    if (d >= -128.0 && d <= 127.0) {
                        return ByteTag.m_128266_((byte)((byte)d));
                    }
                } else if (expectedType == ShortTag.class) {
                    if (d >= -32768.0 && d <= 32767.0) {
                        return ShortTag.m_129258_((short)((short)d));
                    }
                } else if (expectedType == IntTag.class) {
                    if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                        return IntTag.m_128679_((int)((int)d));
                    }
                } else if (expectedType == LongTag.class) {
                    if (d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                        return LongTag.m_128882_((long)((long)d));
                    }
                } else if (expectedType == FloatTag.class) {
                    if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
                        return FloatTag.m_128566_((float)((float)d));
                    }
                } else {
                    if (expectedType == DoubleTag.class) {
                        return DoubleTag.m_128500_((double)d);
                    }
                    if (expectedType == NumericTag.class || expectedType == Tag.class) {
                        if (d == Math.floor(d) && d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
                            if (d >= -128.0 && d <= 127.0) {
                                return ByteTag.m_128266_((byte)((byte)d));
                            }
                            if (d >= -32768.0 && d <= 32767.0) {
                                return ShortTag.m_129258_((short)((short)d));
                            }
                            if (d >= -2.147483648E9 && d <= 2.147483647E9) {
                                return IntTag.m_128679_((int)((int)d));
                            }
                            return LongTag.m_128882_((long)((long)d));
                        }
                        if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
                            return FloatTag.m_128566_((float)((float)d));
                        }
                        return DoubleTag.m_128500_((double)d);
                    }
                }
            }
        } else if (argumentType == String.class) {
            if (expectedType == StringTag.class || expectedType == Tag.class) {
                return StringTag.m_129297_((String)((String)argument));
            }
            if (expectedType == EndTag.class && argument.equals("END")) {
                return EndTag.f_128534_;
            }
        } else if (argument instanceof Map) {
            Map map = (Map)argument;
            if (map.size() == 2) {
                double hint;
                Object value2 = map.get(TYPE_HINT_VALUE_KEY);
                Object typeHintRaw = map.get(TYPE_HINT_KEY);
                if (value2 != null && typeHintRaw instanceof Double && Double.isFinite(hint = ((Double)typeHintRaw).doubleValue()) && (hint == 99.0 || hint >= 0.0 && hint <= 12.0)) {
                    Class<? extends Tag> hinted = CCArgumentWrapper.getTypeFromHint((int)hint);
                    if (expectedType == hinted || expectedType == Tag.class) {
                        return CCArgumentWrapper.sanitizeNBT(hinted, value2.getClass(), value2);
                    }
                    if (expectedType == NumericTag.class ? hinted == ByteTag.class || hinted == ShortTag.class || hinted == IntTag.class || hinted == LongTag.class || hinted == FloatTag.class || hinted == DoubleTag.class : expectedType == CollectionTag.class && (hinted == ByteArrayTag.class || hinted == IntArrayTag.class || hinted == LongArrayTag.class || hinted == ListTag.class)) {
                        return CCArgumentWrapper.sanitizeNBT(hinted, value2.getClass(), value2);
                    }
                    return null;
                }
            }
            Set entries = map.entrySet();
            if (expectedType == ByteArrayTag.class) {
                byte[] bytes = new byte[entries.size()];
                if (CCArgumentWrapper.sanitizeNBTCollection(entries, new ArrayElementValidator(value -> value >= -128.0 && value <= 127.0, (key, value) -> {
                    bytes[key.intValue()] = value.byteValue();
                }, 1))) {
                    return new ByteArrayTag(bytes);
                }
            } else if (expectedType == IntArrayTag.class) {
                int[] ints = new int[entries.size()];
                if (CCArgumentWrapper.sanitizeNBTCollection(entries, new ArrayElementValidator(value -> value >= -2.147483648E9 && value <= 2.147483647E9, (key, value) -> {
                    ints[key.intValue()] = value.intValue();
                }, 3))) {
                    return new IntArrayTag(ints);
                }
            } else if (expectedType == LongArrayTag.class) {
                long[] longs = new long[entries.size()];
                if (CCArgumentWrapper.sanitizeNBTCollection(entries, new ArrayElementValidator(value -> value >= -9.223372036854776E18 && value <= 9.223372036854776E18, (key, value) -> {
                    longs[key.intValue()] = value.longValue();
                }, 4))) {
                    return new LongArrayTag(longs);
                }
            } else {
                if (expectedType == ListTag.class) {
                    return CCArgumentWrapper.sanitizeNBTList(entries);
                }
                if (expectedType == CollectionTag.class) {
                    return CCArgumentWrapper.sanitizeNBTCollection(entries);
                }
                if (expectedType == CompoundTag.class) {
                    return CCArgumentWrapper.sanitizeNBTCompound(entries);
                }
                if (expectedType == Tag.class) {
                    Optional element = entries.stream().findAny();
                    if (element.isPresent() && ((Map.Entry)element.get()).getKey() instanceof Double) {
                        return CCArgumentWrapper.sanitizeNBTCollection(entries);
                    }
                    return CCArgumentWrapper.sanitizeNBTCompound(entries);
                }
            }
        }
        return null;
    }

    private static Class<? extends Tag> getTypeFromHint(int hint) {
        return switch (hint) {
            case 1 -> ByteTag.class;
            case 2 -> ShortTag.class;
            case 3 -> IntTag.class;
            case 4 -> LongTag.class;
            case 5 -> FloatTag.class;
            case 6 -> DoubleTag.class;
            case 99 -> NumericTag.class;
            case 8 -> StringTag.class;
            case 7 -> ByteArrayTag.class;
            case 11 -> IntArrayTag.class;
            case 12 -> LongArrayTag.class;
            case 9 -> ListTag.class;
            case 10 -> CompoundTag.class;
            case 0 -> EndTag.class;
            default -> Tag.class;
        };
    }

    @Nullable
    private static CompoundTag sanitizeNBTCompound(Set<? extends Map.Entry<?, ?>> entries) {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<?, ?> entry : entries) {
            Object key = entry.getKey();
            if (!(key instanceof String)) {
                return null;
            }
            String string = (String)key;
            Object value = entry.getValue();
            Tag nbtValue = CCArgumentWrapper.sanitizeNBT(Tag.class, value.getClass(), value);
            if (nbtValue != null && nbt.m_128365_(string, nbtValue) == null) continue;
            return null;
        }
        return nbt;
    }

    @Nullable
    private static CollectionTag<?> sanitizeNBTCollection(Set<? extends Map.Entry<?, ?>> entries) {
        ListTag nbtList = CCArgumentWrapper.sanitizeNBTList(entries);
        if (nbtList != null) {
            if (nbtList.m_7264_() == 1) {
                return new ByteArrayTag(nbtList.stream().map(e -> ((ByteTag)e).m_7063_()).toList());
            }
            if (nbtList.m_7264_() == 3) {
                return new IntArrayTag(nbtList.stream().mapToInt(e -> ((IntTag)e).m_7047_()).toArray());
            }
            if (nbtList.m_7264_() == 4) {
                return new LongArrayTag(nbtList.stream().mapToLong(e -> ((LongTag)e).m_7046_()).toArray());
            }
            return nbtList;
        }
        return null;
    }

    @Nullable
    private static ListTag sanitizeNBTList(Set<? extends Map.Entry<?, ?>> entries) {
        ValidateAndConsumeListElement val = new ValidateAndConsumeListElement(entries.size());
        return CCArgumentWrapper.sanitizeNBTCollection(entries, val) ? val.toList() : null;
    }

    private static boolean sanitizeNBTCollection(Set<? extends Map.Entry<?, ?>> entries, BiFunction<Integer, Object, Boolean> validateAndConsumeValue) {
        boolean[] valuesSet = new boolean[entries.size()];
        for (Map.Entry<?, ?> entry : entries) {
            Object key = entry.getKey();
            if (!(key instanceof Double)) {
                return false;
            }
            double k = (Double)key;
            if (!Double.isFinite(k) || k < 0.0 || k >= (double)valuesSet.length) {
                return false;
            }
            int intKey = (int)k;
            if (valuesSet[intKey] || !validateAndConsumeValue.apply(intKey, entry.getValue()).booleanValue()) {
                return false;
            }
            valuesSet[intKey] = true;
        }
        return true;
    }

    private record ArrayElementValidator(DoublePredicate rangeValidator, BiConsumer<Integer, Double> consumeValue, int expectedType) implements BiFunction<Integer, Object, Boolean>
    {
        @Override
        public Boolean apply(Integer key, Object value) {
            Map map;
            if (value instanceof Double) {
                double v = (Double)value;
                if (Double.isFinite(v) && this.rangeValidator.test(v)) {
                    this.consumeValue.accept(key, v);
                    return true;
                }
            } else if (value instanceof Map && (map = (Map)value).size() == 2) {
                Object hintValue = map.get(TYPE_HINT_VALUE_KEY);
                Object typeHintRaw = map.get(CCArgumentWrapper.TYPE_HINT_KEY);
                if (hintValue != null && typeHintRaw instanceof Double && (Double)typeHintRaw == (double)this.expectedType) {
                    return this.apply(key, hintValue);
                }
            }
            return false;
        }
    }

    private static class ValidateAndConsumeListElement
    implements BiFunction<Integer, Object, Boolean> {
        private final Tag[] elements;
        private Class<? extends Tag> desiredClass = Tag.class;
        private Class<? extends Tag> searchClass = Tag.class;

        public ValidateAndConsumeListElement(int size) {
            this.elements = new Tag[size];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Boolean apply(Integer key, Object value) {
            Tag element = CCArgumentWrapper.sanitizeNBT(this.searchClass, value.getClass(), value);
            if (element == null) {
                return false;
            }
            Class<?> elementClass = element.getClass();
            if (elementClass == EndTag.class) {
                return false;
            }
            if (this.desiredClass == Tag.class) {
                CompoundTag tag;
                this.desiredClass = elementClass;
                if (element instanceof NumericTag) {
                    this.searchClass = NumericTag.class;
                } else if (elementClass == ListTag.class) {
                    this.searchClass = ((ListTag)element).m_7264_() == 2 ? CollectionTag.class : elementClass;
                } else if (element instanceof CollectionTag) {
                    this.searchClass = CollectionTag.class;
                } else if (!(element instanceof CompoundTag) || !(tag = (CompoundTag)element).m_128456_()) {
                    this.searchClass = elementClass;
                }
            } else if (this.desiredClass != elementClass) {
                if (element instanceof NumericTag) {
                    if (ValidateAndConsumeListElement.validUpcast(this.desiredClass, elementClass)) {
                        this.desiredClass = elementClass;
                    } else if (!ValidateAndConsumeListElement.validUpcast(elementClass, this.desiredClass)) {
                        return false;
                    }
                } else if (elementClass == ByteArrayTag.class) {
                    if (this.desiredClass != IntArrayTag.class && this.desiredClass != LongArrayTag.class && (this.desiredClass != ListTag.class || this.searchClass != CollectionTag.class)) {
                        if (this.desiredClass != CompoundTag.class || this.searchClass != Tag.class) return false;
                        this.desiredClass = ByteArrayTag.class;
                        this.searchClass = CollectionTag.class;
                    }
                } else if (elementClass == IntArrayTag.class) {
                    if (this.desiredClass == ByteArrayTag.class || this.desiredClass == ListTag.class && this.searchClass == CollectionTag.class) {
                        this.desiredClass = IntArrayTag.class;
                    } else if (this.desiredClass != LongArrayTag.class) {
                        if (this.desiredClass != CompoundTag.class || this.searchClass != Tag.class) return false;
                        this.desiredClass = IntArrayTag.class;
                        this.searchClass = CollectionTag.class;
                    }
                } else if (elementClass == LongArrayTag.class) {
                    if (this.desiredClass == ByteArrayTag.class || this.desiredClass == IntArrayTag.class || this.desiredClass == ListTag.class && this.searchClass == CollectionTag.class) {
                        this.desiredClass = LongArrayTag.class;
                    } else {
                        if (this.desiredClass != CompoundTag.class || this.searchClass != Tag.class) return false;
                        this.desiredClass = LongArrayTag.class;
                        this.searchClass = CollectionTag.class;
                    }
                } else {
                    if (elementClass != ListTag.class) return false;
                    byte listType = ((ListTag)element).m_7264_();
                    if (this.desiredClass == ByteArrayTag.class) {
                        if (listType != 0) {
                            this.desiredClass = ListTag.class;
                            if (listType != 2) {
                                this.searchClass = ListTag.class;
                            }
                        }
                    } else if (this.desiredClass == IntArrayTag.class || this.desiredClass == LongArrayTag.class) {
                        if (listType != 0 && listType != 2) {
                            this.desiredClass = ListTag.class;
                            this.searchClass = ListTag.class;
                        }
                    } else {
                        if (this.desiredClass != CompoundTag.class || this.searchClass != Tag.class) return false;
                        this.desiredClass = ListTag.class;
                        this.searchClass = listType == 2 ? CollectionTag.class : ListTag.class;
                    }
                }
            } else if (elementClass == ListTag.class) {
                byte listType;
                if (this.searchClass == CollectionTag.class && (listType = ((ListTag)element).m_7264_()) != 0 && listType != 2) {
                    this.searchClass = ListTag.class;
                }
            } else if (elementClass == CompoundTag.class && !((CompoundTag)element).m_128456_() && this.searchClass == Tag.class) {
                this.searchClass = elementClass;
            }
            this.elements[key.intValue()] = element;
            return true;
        }

        public ListTag toList() {
            ListTag listNBT = new ListTag();
            if (this.desiredClass == ShortTag.class) {
                Arrays.stream(this.elements).map(element -> element instanceof ShortTag ? element : ShortTag.m_129258_((short)((NumericTag)element).m_7053_())).collect(Collectors.toCollection(() -> listNBT));
            } else if (this.desiredClass == IntTag.class) {
                Arrays.stream(this.elements).map(element -> element instanceof IntTag ? element : IntTag.m_128679_((int)((NumericTag)element).m_7047_())).collect(Collectors.toCollection(() -> listNBT));
            } else if (this.desiredClass == LongTag.class) {
                Arrays.stream(this.elements).map(element -> element instanceof LongTag ? element : LongTag.m_128882_((long)((NumericTag)element).m_7046_())).collect(Collectors.toCollection(() -> listNBT));
            } else if (this.desiredClass == FloatTag.class) {
                Arrays.stream(this.elements).map(element -> element instanceof FloatTag ? element : FloatTag.m_128566_((float)((NumericTag)element).m_7057_())).collect(Collectors.toCollection(() -> listNBT));
            } else if (this.desiredClass == DoubleTag.class) {
                Arrays.stream(this.elements).map(element -> element instanceof DoubleTag ? element : DoubleTag.m_128500_((double)((NumericTag)element).m_7061_())).collect(Collectors.toCollection(() -> listNBT));
            } else if (this.desiredClass == ByteArrayTag.class) {
                for (Tag element2 : this.elements) {
                    if (element2 instanceof ByteArrayTag) {
                        listNBT.add((Object)element2);
                        continue;
                    }
                    if (!(element2 instanceof CompoundTag) && !(element2 instanceof ListTag)) continue;
                    listNBT.add((Object)new ByteArrayTag(new byte[0]));
                }
            } else if (this.desiredClass == IntArrayTag.class) {
                for (Tag element3 : this.elements) {
                    if (element3 instanceof IntArrayTag) {
                        listNBT.add((Object)element3);
                        continue;
                    }
                    if (element3 instanceof ByteArrayTag) {
                        ByteArrayTag tag = (ByteArrayTag)element3;
                        byte[] values = tag.m_128227_();
                        listNBT.add((Object)new IntArrayTag(IntStream.range(0, values.length).map(i -> values[i]).toArray()));
                        continue;
                    }
                    if (element3 instanceof CompoundTag) {
                        listNBT.add((Object)new IntArrayTag(new int[0]));
                        continue;
                    }
                    if (!(element3 instanceof ListTag)) continue;
                    ListTag tag = (ListTag)element3;
                    listNBT.add((Object)new IntArrayTag(tag.stream().mapToInt(nbt -> ((ShortTag)nbt).m_7047_()).toArray()));
                }
            } else if (this.desiredClass == LongArrayTag.class) {
                for (Tag element4 : this.elements) {
                    if (element4 instanceof LongArrayTag) {
                        listNBT.add((Object)element4);
                        continue;
                    }
                    if (element4 instanceof IntArrayTag) {
                        IntArrayTag tag = (IntArrayTag)element4;
                        listNBT.add((Object)new LongArrayTag(Arrays.stream(tag.m_128648_()).asLongStream().toArray()));
                        continue;
                    }
                    if (element4 instanceof ByteArrayTag) {
                        ByteArrayTag tag = (ByteArrayTag)element4;
                        byte[] values = tag.m_128227_();
                        listNBT.add((Object)new LongArrayTag(IntStream.range(0, values.length).map(i -> values[i]).asLongStream().toArray()));
                        continue;
                    }
                    if (element4 instanceof CompoundTag) {
                        listNBT.add((Object)new LongArrayTag(new long[0]));
                        continue;
                    }
                    if (!(element4 instanceof ListTag)) continue;
                    ListTag tag = (ListTag)element4;
                    listNBT.add((Object)new LongArrayTag(tag.stream().mapToLong(nbt -> ((ShortTag)nbt).m_7046_()).toArray()));
                }
            } else if (this.desiredClass == ListTag.class) {
                for (Tag element5 : this.elements) {
                    if (element5 instanceof ListTag) {
                        listNBT.add((Object)element5);
                        continue;
                    }
                    if (element5 instanceof CompoundTag) {
                        listNBT.add((Object)new ListTag());
                        continue;
                    }
                    if (!(element5 instanceof CollectionTag)) continue;
                    CollectionTag tag = (CollectionTag)element5;
                    ListTag byteList = new ListTag();
                    byteList.addAll((Collection)tag);
                    listNBT.add((Object)byteList);
                }
            } else {
                Collections.addAll(listNBT, this.elements);
            }
            return listNBT;
        }

        private static boolean validUpcast(Class<? extends Tag> argument, Class<? extends Tag> target) {
            if (argument == ByteTag.class) {
                return target == ShortTag.class || target == IntTag.class || target == LongTag.class || target == FloatTag.class || target == DoubleTag.class;
            }
            if (argument == ShortTag.class) {
                return target == IntTag.class || target == LongTag.class || target == FloatTag.class || target == DoubleTag.class;
            }
            if (argument == IntTag.class) {
                return target == LongTag.class || target == FloatTag.class || target == DoubleTag.class;
            }
            if (argument == LongTag.class) {
                return target == FloatTag.class || target == DoubleTag.class;
            }
            if (argument == FloatTag.class) {
                return target == DoubleTag.class;
            }
            return false;
        }
    }
}

