/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IConfigurable;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IRadialModeItem;
import mekanism.common.item.interfaces.IRadialSelectorEnum;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemConfigurator
extends ItemEnergized
implements IRadialModeItem<ConfiguratorMode>,
IItemHUDProvider {
    public ItemConfigurator(Item.Properties properties) {
        super(MekanismConfig.gear.configuratorChargeRate, MekanismConfig.gear.configuratorMaxEnergy, properties.m_41497_(Rarity.UNCOMMON));
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add((Component)MekanismLang.STATE.translateColored(EnumColor.PINK, this.getMode(stack)));
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        return TextComponentUtil.build(EnumColor.AQUA, super.m_7626_(stack));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        if (world.f_46443_ || player == null) return InteractionResult.PASS;
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        ItemStack stack = context.m_43722_();
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
        ConfiguratorMode mode = this.getMode(stack);
        if (mode.isConfigurating()) {
            ISideConfiguration config;
            TransmissionType transmissionType = Objects.requireNonNull(mode.getTransmission(), "Configurating state requires transmission type");
            if (tile instanceof ISideConfiguration && (config = (ISideConfiguration)tile).getConfig().supports(transmissionType)) {
                ConfigInfo info = config.getConfig().getConfig(transmissionType);
                if (info == null) return InteractionResult.SUCCESS;
                RelativeSide relativeSide = RelativeSide.fromDirections(config.getDirection(), side);
                DataType dataType = info.getDataType(relativeSide);
                if (!player.m_6144_()) {
                    player.m_6352_(MekanismUtils.logFormat(MekanismLang.CONFIGURATOR_VIEW_MODE.translate(transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName())), Util.f_137441_);
                    return InteractionResult.SUCCESS;
                } else if (SecurityUtils.canAccess(player, tile)) {
                    if (!player.m_7500_()) {
                        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                        FloatingLong energyPerConfigure = (FloatingLong)MekanismConfig.gear.configuratorEnergyPerConfigure.get();
                        if (energyContainer == null || energyContainer.extract(energyPerConfigure, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerConfigure)) {
                            return InteractionResult.FAIL;
                        }
                        energyContainer.extract(energyPerConfigure, Action.EXECUTE, AutomationType.MANUAL);
                    }
                    DataType old = dataType;
                    dataType = info.incrementDataType(relativeSide);
                    if (dataType == old) return InteractionResult.SUCCESS;
                    player.m_6352_(MekanismUtils.logFormat(MekanismLang.CONFIGURATOR_TOGGLE_MODE.translate(transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName())), Util.f_137441_);
                    config.getConfig().sideChanged(transmissionType, relativeSide);
                    return InteractionResult.SUCCESS;
                } else {
                    SecurityUtils.displayNoAccess(player);
                    return InteractionResult.FAIL;
                }
            }
            if (SecurityUtils.canAccess(player, tile)) {
                Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.CONFIGURABLE_CAPABILITY, side).resolve();
                if (!capability.isPresent()) return InteractionResult.PASS;
                IConfigurable config2 = (IConfigurable)capability.get();
                if (!player.m_6144_()) return config2.onRightClick(player);
                return config2.onSneakRightClick(player);
            }
            SecurityUtils.displayNoAccess(player);
            return InteractionResult.FAIL;
        }
        if (mode == ConfiguratorMode.EMPTY) {
            IMekanismInventory inv;
            if (!(tile instanceof IMekanismInventory) || !(inv = (IMekanismInventory)tile).hasInventory()) return InteractionResult.PASS;
            if (SecurityUtils.canAccess(player, tile)) {
                IEnergyContainer energyContainer;
                boolean creative = player.m_7500_();
                IEnergyContainer iEnergyContainer = energyContainer = creative ? null : StorageUtils.getEnergyContainer(stack, 0);
                if (!creative && energyContainer == null) {
                    return InteractionResult.FAIL;
                }
                FloatingLong energyPerItemDump = (FloatingLong)MekanismConfig.gear.configuratorEnergyPerItem.get();
                for (IInventorySlot inventorySlot : inv.getInventorySlots(null)) {
                    if (inventorySlot.isEmpty()) continue;
                    if (!creative) {
                        if (energyContainer.extract(energyPerItemDump, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerItemDump)) return InteractionResult.SUCCESS;
                        energyContainer.extract(energyPerItemDump, Action.EXECUTE, AutomationType.MANUAL);
                    }
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)inventorySlot.getStack().m_41777_());
                    inventorySlot.setEmpty();
                }
                return InteractionResult.SUCCESS;
            }
            SecurityUtils.displayNoAccess(player);
            return InteractionResult.FAIL;
        }
        if (mode == ConfiguratorMode.ROTATE) {
            if (!(tile instanceof TileEntityMekanism)) return InteractionResult.SUCCESS;
            TileEntityMekanism tileMekanism = (TileEntityMekanism)tile;
            if (SecurityUtils.canAccess(player, tile)) {
                if (!Attribute.get(tileMekanism.getBlockType(), AttributeStateFacing.class).canRotate()) return InteractionResult.SUCCESS;
                if (!player.m_6144_()) {
                    tileMekanism.setFacing(side);
                    return InteractionResult.SUCCESS;
                } else {
                    if (!player.m_6144_()) return InteractionResult.SUCCESS;
                    tileMekanism.setFacing(side.m_122424_());
                }
                return InteractionResult.SUCCESS;
            } else {
                SecurityUtils.displayNoAccess(player);
                return InteractionResult.FAIL;
            }
        }
        if (mode != ConfiguratorMode.WRENCH) return InteractionResult.PASS;
        return InteractionResult.PASS;
    }

    public EnumColor getColor(ConfiguratorMode mode) {
        return mode.getColor();
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return this.getMode(stack) == ConfiguratorMode.WRENCH;
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        list.add((Component)MekanismLang.MODE.translateColored(EnumColor.PINK, this.getMode(stack)));
    }

    @Override
    public void changeMode(@Nonnull Player player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        ConfiguratorMode newMode;
        ConfiguratorMode mode = this.getMode(stack);
        if (mode != (newMode = (ConfiguratorMode)mode.adjust(shift))) {
            this.setMode(stack, player, newMode);
            if (displayChangeMessage) {
                player.m_6352_(MekanismUtils.logFormat(MekanismLang.CONFIGURE_STATE.translate(newMode)), Util.f_137441_);
            }
        }
    }

    @Override
    @Nonnull
    public Component getScrollTextComponent(@Nonnull ItemStack stack) {
        return this.getMode(stack).getTextComponent();
    }

    @Override
    public void setMode(ItemStack stack, Player player, ConfiguratorMode mode) {
        ItemDataUtils.setInt(stack, "state", mode.ordinal());
    }

    @Override
    public ConfiguratorMode getMode(ItemStack stack) {
        return ConfiguratorMode.byIndexStatic(ItemDataUtils.getInt(stack, "state"));
    }

    @Override
    public Class<ConfiguratorMode> getModeClass() {
        return ConfiguratorMode.class;
    }

    @Override
    public ConfiguratorMode getModeByIndex(int ordinal) {
        return ConfiguratorMode.byIndexStatic(ordinal);
    }

    @FieldsAreNonnullByDefault
    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    public static enum ConfiguratorMode implements IRadialSelectorEnum<ConfiguratorMode>,
    IHasTextComponent
    {
        CONFIGURATE_ITEMS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ITEM, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_FLUIDS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.FLUID, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_GASES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.GAS, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_INFUSE_TYPES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.INFUSION, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_PIGMENTS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.PIGMENT, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_SLURRIES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.SLURRY, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_ENERGY(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ENERGY, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_HEAT(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.HEAT, EnumColor.BRIGHT_GREEN, true, null),
        EMPTY(MekanismLang.CONFIGURATOR_EMPTY, null, EnumColor.DARK_RED, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "empty.png")),
        ROTATE(MekanismLang.CONFIGURATOR_ROTATE, null, EnumColor.YELLOW, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "rotate.png")),
        WRENCH(MekanismLang.CONFIGURATOR_WRENCH, null, EnumColor.PINK, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "wrench.png"));

        public static final ConfiguratorMode[] MODES;
        private final ILangEntry langEntry;
        @Nullable
        private final TransmissionType transmissionType;
        private final EnumColor color;
        private final boolean configurating;
        private final ResourceLocation icon;

        private ConfiguratorMode(ILangEntry langEntry, TransmissionType transmissionType, @Nullable EnumColor color, boolean configurating, ResourceLocation icon) {
            this.langEntry = langEntry;
            this.transmissionType = transmissionType;
            this.color = color;
            this.configurating = configurating;
            this.icon = transmissionType != null ? MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, transmissionType.getTransmission() + ".png") : icon;
        }

        @Override
        public Component getTextComponent() {
            if (this.transmissionType != null) {
                return this.langEntry.translateColored(this.color, this.transmissionType);
            }
            return this.langEntry.translateColored(this.color, new Object[0]);
        }

        @Override
        public EnumColor getColor() {
            return this.color;
        }

        public boolean isConfigurating() {
            return this.configurating;
        }

        @Nullable
        public TransmissionType getTransmission() {
            return switch (this) {
                case CONFIGURATE_ITEMS -> TransmissionType.ITEM;
                case CONFIGURATE_FLUIDS -> TransmissionType.FLUID;
                case CONFIGURATE_GASES -> TransmissionType.GAS;
                case CONFIGURATE_INFUSE_TYPES -> TransmissionType.INFUSION;
                case CONFIGURATE_PIGMENTS -> TransmissionType.PIGMENT;
                case CONFIGURATE_SLURRIES -> TransmissionType.SLURRY;
                case CONFIGURATE_ENERGY -> TransmissionType.ENERGY;
                case CONFIGURATE_HEAT -> TransmissionType.HEAT;
                default -> null;
            };
        }

        @Override
        @Nonnull
        public ConfiguratorMode byIndex(int index) {
            return ConfiguratorMode.byIndexStatic(index);
        }

        public static ConfiguratorMode byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        public Component getShortText() {
            return this.configurating && this.transmissionType != null ? this.transmissionType.getLangEntry().translateColored(this.color, new Object[0]) : this.getTextComponent();
        }

        @Override
        public ResourceLocation getIcon() {
            return this.icon;
        }

        static {
            MODES = ConfiguratorMode.values();
        }
    }
}

