/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.providers.IRobitSkinProvider;
import mekanism.api.robit.RobitSkin;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.entity.EntityRobit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.network.to_client.PacketSecurityUpdate;
import mekanism.common.registries.MekanismRobitSkins;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemRobit
extends ItemEnergized
implements IItemSustainedInventory,
ISecurityItem {
    public ItemRobit(Item.Properties properties) {
        super(() -> EntityRobit.MAX_ENERGY.multiply(0.005), () -> EntityRobit.MAX_ENERGY, properties.m_41497_(Rarity.RARE));
    }

    public void onDestroyed(@Nonnull ItemEntity item, @Nonnull DamageSource damageSource) {
        InventoryUtils.dropItemContents(item, damageSource);
    }

    @Override
    public void m_7373_(@Nonnull ItemStack stack, Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add((Component)MekanismLang.ROBIT_NAME.translateColored(EnumColor.INDIGO, EnumColor.GRAY, this.getRobitName(stack)));
        tooltip.add((Component)MekanismLang.ROBIT_SKIN.translateColored(EnumColor.INDIGO, EnumColor.GRAY, this.getRobitSkin(stack)));
        SecurityUtils.addSecurityTooltip(stack, tooltip);
        tooltip.add((Component)MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        TileEntityMekanism chargepad = WorldUtils.getTileEntity(TileEntityChargepad.class, (BlockGetter)world, pos = context.m_8083_());
        if (chargepad != null && !chargepad.getActive()) {
            if (!world.f_46443_) {
                UUID ownerUUID;
                ItemStack stack = context.m_43722_();
                EntityRobit robit = EntityRobit.create(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
                if (robit == null) {
                    return InteractionResult.FAIL;
                }
                robit.setHome(chargepad.getTileCoord());
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                if (energyContainer != null) {
                    robit.getEnergyContainer().setEnergy(energyContainer.getEnergy());
                }
                if ((ownerUUID = this.getOwnerUUID(stack)) == null) {
                    robit.setOwnerUUID(player.m_142081_());
                    Mekanism.packetHandler().sendToAll(new PacketSecurityUpdate(player.m_142081_(), null));
                } else {
                    robit.setOwnerUUID(ownerUUID);
                }
                robit.setInventory(this.getInventory(new Object[]{stack}), new Object[0]);
                robit.m_6593_(this.getRobitName(stack));
                robit.setSecurityMode(this.getSecurity(stack));
                robit.setSkin(this.getRobitSkin(stack), player);
                world.m_7967_((Entity)robit);
                world.m_151545_((Entity)player, GameEvent.f_157810_, (Entity)robit);
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void setName(ItemStack stack, Component name) {
        ItemDataUtils.setString(stack, "name", Component.Serializer.m_130703_((Component)name));
    }

    private Component getRobitName(ItemStack stack) {
        String name = ItemDataUtils.getString(stack, "name");
        return name.isEmpty() ? MekanismLang.ROBIT.translate(new Object[0]) : Component.Serializer.m_130701_((String)name);
    }

    public void setSkin(ItemStack stack, RobitSkin skin) {
        ItemDataUtils.setString(stack, "skin", skin.getRegistryName().toString());
    }

    public IRobitSkinProvider getRobitSkin(ItemStack stack) {
        RobitSkin robitSkin;
        ResourceLocation rl;
        String skin = ItemDataUtils.getString(stack, "skin");
        if (!skin.isEmpty() && (rl = ResourceLocation.m_135820_((String)skin)) != null && (robitSkin = (RobitSkin)MekanismAPI.robitSkinRegistry().getValue(rl)) != null) {
            return robitSkin;
        }
        return MekanismRobitSkins.BASE;
    }
}

