/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.item.RateLimitFluidHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ItemCanteen
extends Item {
    public ItemCanteen(Item.Properties properties) {
        super(properties.m_41497_(Rarity.UNCOMMON).m_41487_(1).setNoRepair());
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        StorageUtils.addStoredFluid(stack, tooltip, true, MekanismLang.EMPTY);
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return StorageUtils.getBarWidth(stack);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return FluidUtils.getRGBDurabilityForDisplay(stack).orElse(0);
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (this.m_41389_(group)) {
            items.add((Object)FluidUtils.getFilledVariant(new ItemStack((ItemLike)this), MekanismConfig.gear.canteenMaxStorage.get(), MekanismFluids.NUTRITIONAL_PASTE));
        }
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull LivingEntity entityLiving) {
        Player player;
        int needed;
        if (!world.f_46443_ && entityLiving instanceof Player && (needed = Math.min(20 - (player = (Player)entityLiving).m_36324_().m_38702_(), this.getFluid(stack).getAmount() / MekanismConfig.general.nutritionalPasteMBPerFood.get())) > 0) {
            player.m_36324_().m_38707_(needed, (float)needed * MekanismConfig.general.nutritionalPasteSaturation.get());
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(handler -> handler.drain(needed * MekanismConfig.general.nutritionalPasteMBPerFood.get(), IFluidHandler.FluidAction.EXECUTE));
            world.m_142346_((Entity)entityLiving, GameEvent.f_157805_, entityLiving.m_146901_());
        }
        return stack;
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 32;
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemCapabilityWrapper(stack, RateLimitFluidHandler.create(MekanismConfig.gear.canteenTransferRate, MekanismConfig.gear.canteenMaxStorage, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrueBi, fluid -> fluid.getFluid() == MekanismFluids.NUTRITIONAL_PASTE.getFluid()));
    }

    private FluidStack getFluid(ItemStack stack) {
        Optional capability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (capability.isPresent()) {
            IMekanismFluidHandler fluidHandler;
            IExtendedFluidTank fluidTank;
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)capability.get();
            if (fluidHandlerItem instanceof IMekanismFluidHandler && (fluidTank = (fluidHandler = (IMekanismFluidHandler)fluidHandlerItem).getFluidTank(0, null)) != null) {
                return fluidTank.getFluid();
            }
            return fluidHandlerItem.getFluidInTank(0);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        if (!playerIn.m_7500_() && playerIn.m_36391_(false) && this.getFluid(playerIn.m_21120_(handIn)).getAmount() >= 50) {
            playerIn.m_6672_(handIn);
        }
        return InteractionResultHolder.m_19090_((Object)playerIn.m_21120_(handIn));
    }
}

