/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import javax.annotation.Nullable;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class PacketWindowSelect
implements IMekanismPacket {
    @Nullable
    private final SelectedWindowData selectedWindow;

    public PacketWindowSelect(@Nullable SelectedWindowData selectedWindow) {
        this.selectedWindow = selectedWindow;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        AbstractContainerMenu abstractContainerMenu;
        ServerPlayer player = context.getSender();
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof MekanismContainer) {
            MekanismContainer container = (MekanismContainer)abstractContainerMenu;
            container.setSelectedWindow(player.m_142081_(), this.selectedWindow);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        if (this.selectedWindow == null) {
            buffer.writeByte(-1);
        } else {
            buffer.writeByte((int)this.selectedWindow.extraData);
            buffer.m_130068_((Enum)this.selectedWindow.type);
        }
    }

    public static PacketWindowSelect decode(FriendlyByteBuf buffer) {
        byte extraData = buffer.readByte();
        if (extraData == -1) {
            return new PacketWindowSelect(null);
        }
        SelectedWindowData.WindowType windowType = (SelectedWindowData.WindowType)buffer.m_130066_(SelectedWindowData.WindowType.class);
        return new PacketWindowSelect(windowType == SelectedWindowData.WindowType.UNSPECIFIED ? SelectedWindowData.UNSPECIFIED : new SelectedWindowData(windowType, extraData));
    }
}

