/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.api.IConfigurable;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructuralMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileEntityStructuralMultiblock
extends TileEntityMekanism
implements IStructuralMultiblock,
IConfigurable {
    private final Map<MultiblockManager<?>, Structure> structures = new HashMap();
    private final Structure invalidStructure = Structure.INVALID;
    private final MultiblockData defaultMultiblock = new MultiblockData(this);
    private String clientActiveMultiblock = null;

    public TileEntityStructuralMultiblock(IBlockProvider provider, BlockPos pos, BlockState state) {
        super(provider, pos, state);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    @Override
    public MultiblockData getDefaultData() {
        return this.defaultMultiblock;
    }

    @Override
    public void setStructure(MultiblockManager<?> manager, Structure structure) {
        this.structures.put(manager, structure);
    }

    @Override
    public Structure getStructure(MultiblockManager<?> manager) {
        return this.structures.getOrDefault(manager, this.invalidStructure);
    }

    @Override
    public boolean hasStructure(Structure structure) {
        return this.structures.get(structure.getManager()) == structure;
    }

    @Override
    public boolean hasFormedMultiblock() {
        return this.clientActiveMultiblock != null;
    }

    @Override
    public boolean structuralGuiAccessAllowed() {
        return this.hasFormedMultiblock() && this.structuralGuiAccessAllowed(this.clientActiveMultiblock);
    }

    protected boolean structuralGuiAccessAllowed(@Nonnull String multiblock) {
        return !multiblock.contains("fusion") && !multiblock.contains("evaporation");
    }

    @Override
    public Map<MultiblockManager<?>, Structure> getStructureMap() {
        return this.structures;
    }

    private MultiblockData getMultiblockData(Structure structure) {
        MultiblockData data = structure.getMultiblockData();
        if (data != null && data.isFormed()) {
            return data;
        }
        return this.getDefaultData();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.ticker % 10 == 0) {
            Structure structure;
            String activeMultiblock = null;
            if (!this.structures.isEmpty()) {
                Iterator<Map.Entry<MultiblockManager<?>, Structure>> iterator = this.structures.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<MultiblockManager<?>, Structure> entry = iterator.next();
                    structure = entry.getValue();
                    if (structure.isValid()) {
                        if (activeMultiblock != null || structure.getController() == null || !this.getMultiblockData(structure).isFormed()) continue;
                        activeMultiblock = entry.getKey().getNameLower();
                        continue;
                    }
                    iterator.remove();
                }
            }
            if (this.ticker >= 3 && this.structures.isEmpty()) {
                this.invalidStructure.tick(this, true);
                for (Map.Entry<MultiblockManager<?>, Structure> entry : this.structures.entrySet()) {
                    structure = entry.getValue();
                    if (structure.getController() == null || !this.getMultiblockData(structure).isFormed()) continue;
                    activeMultiblock = entry.getKey().getNameLower();
                    break;
                }
            }
            if (!Objects.equals(activeMultiblock, this.clientActiveMultiblock)) {
                this.clientActiveMultiblock = activeMultiblock;
                this.sendUpdatePacket();
            }
        }
    }

    @Override
    public InteractionResult onActivate(Player player, InteractionHand hand, ItemStack stack) {
        for (Map.Entry<MultiblockManager<?>, Structure> entry : this.structures.entrySet()) {
            MultiblockData data;
            Structure structure = entry.getValue();
            IMultiblock<?> master = structure.getController();
            if (master == null || !(data = this.getMultiblockData(structure)).isFormed() || !this.structuralGuiAccessAllowed(entry.getKey().getNameLower()) || !data.getBounds().getRelativeLocation(this.m_58899_()).isWall()) continue;
            return master.onActivate(player, hand, stack);
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onNeighborChange(Block block, BlockPos neighborPos) {
        super.onNeighborChange(block, neighborPos);
        if (!this.isRemote()) {
            for (Structure s : this.structures.values()) {
                MultiblockData multiblockData;
                if (s.getController() == null || !(multiblockData = this.getMultiblockData(s)).isPositionInsideBounds(s, neighborPos) || multiblockData.innerNodes.contains(neighborPos) && !this.f_58857_.m_46859_(neighborPos)) continue;
                s.markForUpdate(this.f_58857_, true);
            }
        }
    }

    @Override
    public InteractionResult onRightClick(Player player) {
        if (!this.isRemote()) {
            for (Structure s : this.structures.values()) {
                FormationProtocol.FormationResult result;
                if (s.getController() == null || this.getMultiblockData(s).isFormed() || (result = s.runUpdate(this)).isFormed() || result.getResultText() == null) continue;
                player.m_6352_(result.getResultText(), Util.f_137441_);
                return InteractionResult.m_19078_((boolean)this.isRemote());
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @Override
    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        if (this.clientActiveMultiblock != null) {
            updateTag.m_128359_("activeState", this.clientActiveMultiblock);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.clientActiveMultiblock = tag.m_128425_("activeState", 8) ? tag.m_128461_("activeState") : null;
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (!this.isRemote()) {
            this.structures.values().forEach(s -> s.invalidate(this.f_58857_));
        }
    }

    @Override
    public boolean shouldDumpRadiation() {
        return false;
    }
}

