/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;

public final class MultipartUtils {
    private MultipartUtils() {
    }

    public static RayTraceVectors getRayTraceVectors(Entity entity) {
        float pitch = entity.m_146909_();
        float yaw = entity.m_146908_();
        Vec3 start = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
        float f1 = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float lookY = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        float lookX = f2 * f3;
        float lookZ = f1 * f3;
        double reach = 5.0;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            reach = player.m_21133_((Attribute)ForgeMod.REACH_DISTANCE.get());
        }
        Vec3 end = start.m_82520_((double)lookX * reach, (double)lookY * reach, (double)lookZ * reach);
        return new RayTraceVectors(start, end);
    }

    public static AdvancedRayTraceResult collisionRayTrace(Entity entity, BlockPos pos, Collection<VoxelShape> boxes) {
        RayTraceVectors vecs = MultipartUtils.getRayTraceVectors(entity);
        return MultipartUtils.collisionRayTrace(pos, vecs.start(), vecs.end(), boxes);
    }

    public static AdvancedRayTraceResult collisionRayTrace(BlockPos pos, Vec3 start, Vec3 end, Collection<VoxelShape> boxes) {
        double minDistance = Double.POSITIVE_INFINITY;
        AdvancedRayTraceResult hit = null;
        int i = -1;
        for (VoxelShape shape : boxes) {
            AdvancedRayTraceResult advancedResult;
            double d;
            BlockHitResult result;
            if (shape != null && (result = shape.m_83220_(start, end, pos)) != null && (d = (advancedResult = new AdvancedRayTraceResult((HitResult)result, shape, i)).squareDistanceTo(start)) < minDistance) {
                minDistance = d;
                hit = advancedResult;
            }
            ++i;
        }
        return hit;
    }

    public record RayTraceVectors(Vec3 start, Vec3 end) {
    }

    public static class AdvancedRayTraceResult {
        public final VoxelShape bounds;
        public final HitResult hit;
        public final int subHit;

        public AdvancedRayTraceResult(HitResult mop, VoxelShape shape, int subHit) {
            this.hit = mop;
            this.bounds = shape;
            this.subHit = subHit;
        }

        public boolean valid() {
            return this.hit != null && this.bounds != null;
        }

        public double squareDistanceTo(Vec3 vec) {
            return this.hit.m_82450_().m_82557_(vec);
        }
    }
}

