/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.packet.PacketToggleChunk;
import com.supermartijn642.chunkloaders.screen.ChunkImage;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.AbstractButtonWidget;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;

public class ChunkButton
extends AbstractButtonWidget
implements IHoverTextWidget {
    private static final ResourceLocation BUTTON_OFF = new ResourceLocation("chunkloaders", "textures/gui/button_off.png");
    private static final ResourceLocation BUTTON_ON = new ResourceLocation("chunkloaders", "textures/gui/button_on.png");
    public final int xOffset;
    public final int zOffset;
    private final Supplier<ChunkLoaderTile> tileSupplier;
    private final ChunkImage image;

    public ChunkButton(int x, int y, int xOffset, int zOffset, Supplier<ChunkLoaderTile> tileSupplier, ChunkPos chunk) {
        super(x, y, 15, 15, () -> ChunkLoaders.CHANNEL.sendToServer((Object)new PacketToggleChunk(((ChunkLoaderTile)((Object)((Object)tileSupplier.get()))).m_58899_(), xOffset, zOffset)));
        this.xOffset = xOffset;
        this.zOffset = zOffset;
        this.tileSupplier = tileSupplier;
        this.image = new ChunkImage(ClientUtils.getWorld(), chunk);
        this.image.createTexture();
    }

    protected Component getNarrationMessage() {
        return TextComponents.translation((String)(this.isLoaded() ? "chunkloaders.gui.narrate_loaded" : "chunkloaders.gui.narrate_unloaded")).get();
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ScreenUtils.bindTexture((ResourceLocation)(this.isLoaded() ? BUTTON_ON : BUTTON_OFF));
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)this.x, (float)this.y, (float)15.0f, (float)15.0f);
        this.image.updateTexture();
        RenderSystem.m_157453_((int)0, (int)this.image.textureId);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(this.x + 2), (float)(this.y + 2), (float)11.0f, (float)11.0f);
        if (!this.isLoaded()) {
            ScreenUtils.fillRect((PoseStack)matrixStack, (float)(this.x + 2), (float)(this.y + 2), (float)11.0f, (float)11.0f, (int)-1442840576);
        }
    }

    public boolean isLoaded() {
        ChunkLoaderTile tile = this.tileSupplier.get();
        return tile != null && tile.isLoaded(this.xOffset, this.zOffset);
    }

    public Component getHoverText() {
        return TextComponents.translation((String)(this.isLoaded() ? "chunkloaders.gui.loaded" : "chunkloaders.gui.unloaded")).get();
    }
}

