/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.util;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.network.PacketHandler;
import com.mrcrayfish.configured.network.message.MessageSyncServerConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHelper {
    private static final Method MOD_CONFIG_SET_CONFIG_DATA = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});
    private static final Method MOD_CONFIG_FIRE_EVENT = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"fireEvent", (Class[])new Class[]{IConfigEvent.class});

    public static boolean isModified(ModConfig config) {
        return ConfigHelper.gatherAllConfigValues(config).stream().anyMatch(pair -> !((ForgeConfigSpec.ConfigValue)pair.getLeft()).get().equals(((ForgeConfigSpec.ValueSpec)pair.getRight()).getDefault()));
    }

    public static List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllConfigValues(ModConfig config) {
        return ConfigHelper.gatherAllConfigValues(((ForgeConfigSpec)config.getSpec()).getValues(), (ForgeConfigSpec)config.getSpec());
    }

    public static List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllConfigValues(UnmodifiableConfig config, ForgeConfigSpec spec) {
        ArrayList values = new ArrayList();
        ConfigHelper.gatherValuesFromConfig(config, spec, values);
        return ImmutableList.copyOf(values);
    }

    private static void gatherValuesFromConfig(UnmodifiableConfig config, ForgeConfigSpec spec, List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                ConfigHelper.gatherValuesFromConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    public static void setConfigData(ModConfig config, @Nullable CommentedConfig configData) {
        try {
            MOD_CONFIG_SET_CONFIG_DATA.invoke((Object)config, configData);
            if (configData instanceof FileConfig) {
                config.save();
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static ModConfig getModConfig(String fileName) {
        ConcurrentHashMap configMap = (ConcurrentHashMap)ObfuscationReflectionHelper.getPrivateValue(ConfigTracker.class, (Object)ConfigTracker.INSTANCE, (String)"fileMap");
        return configMap != null ? (ModConfig)configMap.get(fileName) : null;
    }

    public static void fireEvent(ModConfig config, ModConfigEvent event) {
        try {
            MOD_CONFIG_FIRE_EVENT.invoke((Object)config, event);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isConfiguredInstalledOnServer() {
        ClientPacketListener listener = Minecraft.m_91087_().m_91403_();
        if (listener == null) {
            return false;
        }
        Connection connection = listener.m_6198_();
        return PacketHandler.getPlayChannel().isRemotePresent(connection);
    }

    public static void sendConfigDataToServer(ModConfig config) {
        if (!ConfigHelper.isConfiguredInstalledOnServer()) {
            return;
        }
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            if (config.getType() == ModConfig.Type.SERVER && minecraft.f_91074_ != null && minecraft.f_91074_.m_20310_(2)) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                TomlFormat.instance().createWriter().write((UnmodifiableConfig)config.getConfigData(), (OutputStream)stream);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageSyncServerConfig(config.getFileName(), stream.toByteArray()));
                stream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void resetCache(ModConfig config) {
        ConfigHelper.gatherAllConfigValues(config).forEach(pair -> ((ForgeConfigSpec.ConfigValue)pair.getLeft()).clearCache());
    }
}

