/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IInventoryResponder;
import com.hollingsworth.arsnouveau.api.spell.IPickupResponder;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.LootUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.eventbus.api.Event;

public abstract class AbstractEffect
extends AbstractSpellPart {
    public ForgeConfigSpec.DoubleValue DAMAGE;
    public ForgeConfigSpec.DoubleValue AMP_VALUE;
    public ForgeConfigSpec.IntValue POTION_TIME;
    public ForgeConfigSpec.IntValue EXTEND_TIME;
    public ForgeConfigSpec.IntValue GENERIC_INT;
    public ForgeConfigSpec.DoubleValue GENERIC_DOUBLE;

    public AbstractEffect(String tag, String description) {
        super(tag, description);
    }

    public void onResolve(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (rayTraceResult instanceof BlockHitResult) {
            this.onResolveBlock((BlockHitResult)rayTraceResult, world, shooter, spellStats, spellContext);
        } else if (rayTraceResult instanceof EntityHitResult) {
            this.onResolveEntity((EntityHitResult)rayTraceResult, world, shooter, spellStats, spellContext);
        }
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
    }

    public void applyConfigPotion(LivingEntity entity, MobEffect potionEffect, SpellStats spellStats) {
        this.applyConfigPotion(entity, potionEffect, spellStats, true);
    }

    public void applyConfigPotion(LivingEntity entity, MobEffect potionEffect, SpellStats spellStats, boolean showParticles) {
        this.applyPotion(entity, potionEffect, spellStats, this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get(), this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get(), showParticles);
    }

    public void applyPotionWithCap(LivingEntity entity, MobEffect potionEffect, SpellStats stats, int baseDuration, int durationBuffBase, int cap) {
        if (entity == null) {
            return;
        }
        int duration = (int)((double)baseDuration + (double)durationBuffBase * stats.getDurationMultiplier());
        int amp = Math.min(cap, (int)stats.getAmpMultiplier());
        entity.m_7292_(new MobEffectInstance(potionEffect, duration * 20, amp));
    }

    public void applyPotion(LivingEntity entity, MobEffect potionEffect, SpellStats stats, int baseDurationSeconds, int durationBuffSeconds, boolean showParticles) {
        if (entity == null) {
            return;
        }
        int ticks = baseDurationSeconds * 20 + durationBuffSeconds * stats.getDurationInTicks();
        int amp = (int)stats.getAmpMultiplier();
        entity.m_7292_(new MobEffectInstance(potionEffect, ticks, amp, false, showParticles, true));
    }

    public boolean canSummon(LivingEntity playerEntity) {
        return this.isRealPlayer(playerEntity) && playerEntity.m_21124_((MobEffect)ModPotions.SUMMONING_SICKNESS) == null;
    }

    public void applySummoningSickness(LivingEntity playerEntity, int time) {
        playerEntity.m_7292_(new MobEffectInstance((MobEffect)ModPotions.SUMMONING_SICKNESS, time));
    }

    public void summonLivingEntity(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats augments, SpellContext spellContext, ISummon summon) {
        if (shooter != null) {
            summon.setOwnerID(shooter.m_142081_());
        }
        if (summon.getLivingEntity() != null) {
            world.m_7967_((Entity)summon.getLivingEntity());
        }
        MinecraftForge.EVENT_BUS.post((Event)new SummonEvent(rayTraceResult, world, shooter, augments, spellContext, summon));
    }

    public Player getPlayer(LivingEntity entity, ServerLevel world) {
        return entity instanceof Player ? (Player)entity : FakePlayerFactory.getMinecraft((ServerLevel)world);
    }

    public int getBaseHarvestLevel(SpellStats stats) {
        return (int)(3.0 + stats.getAmpMultiplier());
    }

    public boolean canBlockBeHarvested(SpellStats stats, Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60800_((BlockGetter)world, pos) >= 0.0f && SpellUtil.isCorrectHarvestLevel(this.getBaseHarvestLevel(stats), world.m_8055_(pos));
    }

    public void dealDamage(Level world, LivingEntity shooter, float baseDamage, SpellStats stats, Entity entity, DamageSource source) {
        Object playerContext;
        shooter = shooter == null ? FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world)) : shooter;
        float totalDamage = (float)((double)baseDamage + stats.getDamageModifier());
        if (entity instanceof LivingEntity && ((LivingEntity)entity).m_21223_() <= 0.0f || totalDamage <= 0.0f) {
            return;
        }
        entity.m_6469_(source, totalDamage);
        Object object = playerContext = shooter instanceof Player ? (Player)shooter : ANFakePlayer.getPlayer((ServerLevel)world);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = (LivingEntity)entity;
        if (mob.m_21223_() <= 0.0f && !mob.m_146910_() && stats.hasBuff(AugmentFortune.INSTANCE)) {
            int looting = stats.getBuffCount(AugmentFortune.INSTANCE);
            LootContext.Builder lootContext = LootUtil.getLootingContext((ServerLevel)world, shooter, mob, looting, DamageSource.m_19344_((Player)playerContext));
            ResourceLocation lootTable = mob.m_5743_();
            LootTable loottable = world.m_142572_().m_129898_().m_79217_(lootTable);
            List items = loottable.m_79129_(lootContext.m_78975_(LootContextParamSets.f_81415_));
            items.forEach(arg_0 -> ((LivingEntity)mob).m_19983_(arg_0));
        }
    }

    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        shooter = !(shooter instanceof Player) ? FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world)) : shooter;
        return DamageSource.m_19344_((Player)((Player)shooter));
    }

    public Vec3 safelyGetHitPos(HitResult result) {
        return result instanceof EntityHitResult ? ((EntityHitResult)result).m_82443_().m_20182_() : result.m_82450_();
    }

    public boolean isRealPlayer(LivingEntity entity) {
        return entity instanceof Player && this.isNotFakePlayer(entity);
    }

    public boolean isNotFakePlayer(LivingEntity entity) {
        return !(entity instanceof FakePlayer);
    }

    public boolean wouldSucceed(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        return true;
    }

    public boolean nonAirBlockSuccess(HitResult rayTraceResult, Level world) {
        return rayTraceResult instanceof BlockHitResult && world.m_8055_(((BlockHitResult)rayTraceResult).m_82425_()).m_60767_() != Material.f_76296_;
    }

    public boolean livingEntityHitSuccess(HitResult rayTraceResult) {
        return rayTraceResult instanceof EntityHitResult && ((EntityHitResult)rayTraceResult).m_82443_() instanceof LivingEntity;
    }

    public boolean nonAirAnythingSuccess(HitResult result, Level world) {
        return this.nonAirBlockSuccess(result, world) || this.livingEntityHitSuccess(result);
    }

    public void applyEnchantments(SpellStats stats, ItemStack stack) {
        if (stats.hasBuff(AugmentExtract.INSTANCE)) {
            stack.m_41663_(Enchantments.f_44985_, 1);
        }
        if (stats.hasBuff(AugmentFortune.INSTANCE)) {
            stack.m_41663_(Enchantments.f_44987_, stats.getBuffCount(AugmentFortune.INSTANCE));
        }
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder) {
        super.buildConfig(builder);
        super.buildAugmentLimitsConfig(builder, this.getDefaultAugmentLimits());
    }

    public void addDamageConfig(ForgeConfigSpec.Builder builder, double defaultValue) {
        this.DAMAGE = builder.defineInRange("damage", defaultValue, 0.0, 2.147483647E9);
    }

    public void addAmpConfig(ForgeConfigSpec.Builder builder, double defaultValue) {
        this.AMP_VALUE = builder.defineInRange("amplify", defaultValue, 0.0, 2.147483647E9);
    }

    public void addPotionConfig(ForgeConfigSpec.Builder builder, int defaultTime) {
        this.POTION_TIME = builder.comment("Potion duration, in seconds").defineInRange("potion_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addExtendTimeConfig(ForgeConfigSpec.Builder builder, int defaultTime) {
        this.EXTEND_TIME = builder.comment("Extend time duration, in seconds").defineInRange("extend_time", defaultTime, 0, Integer.MAX_VALUE);
    }

    public void addGenericInt(ForgeConfigSpec.Builder builder, int val, String comment, String path) {
        this.GENERIC_INT = builder.comment(comment).defineInRange(path, val, 0, Integer.MAX_VALUE);
    }

    public void addGenericDouble(ForgeConfigSpec.Builder builder, double val, String comment, String path) {
        this.GENERIC_DOUBLE = builder.comment(comment).defineInRange(path, val, 0.0, Double.MAX_VALUE);
    }

    public void addDefaultPotionConfig(ForgeConfigSpec.Builder builder) {
        this.addPotionConfig(builder, 30);
        this.addExtendTimeConfig(builder, 8);
    }

    public ItemStack getItemFromCaster(@Nullable LivingEntity shooter, SpellContext spellContext, Predicate<ItemStack> predicate) {
        if (spellContext.castingTile instanceof IInventoryResponder) {
            return ((IInventoryResponder)spellContext.castingTile).getItem(predicate);
        }
        if (shooter instanceof IInventoryResponder) {
            return ((IInventoryResponder)shooter).getItem(predicate);
        }
        if (shooter instanceof Player) {
            Player playerEntity = (Player)shooter;
            NonNullList list = playerEntity.f_36093_.f_35974_;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = (ItemStack)list.get(i);
                if (!predicate.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getItemFromCaster(@Nullable LivingEntity shooter, SpellContext spellContext, Item item) {
        return this.getItemFromCaster(shooter, spellContext, (ItemStack i) -> i.m_41656_(new ItemStack((ItemLike)item)));
    }

    public ItemStack extractStackFromCaster(@Nullable LivingEntity shooter, SpellContext spellContext, Predicate<ItemStack> predicate, int maxExtract) {
        IInventoryResponder responder = null;
        if (spellContext.castingTile instanceof IInventoryResponder) {
            responder = (IInventoryResponder)spellContext.castingTile;
        } else if (shooter instanceof IInventoryResponder) {
            responder = (IInventoryResponder)shooter;
        }
        if (responder != null) {
            return responder.extractItem(predicate, maxExtract);
        }
        if (shooter instanceof Player) {
            Player playerEntity = (Player)shooter;
            NonNullList list = playerEntity.f_36093_.f_35974_;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = (ItemStack)list.get(i);
                if (!predicate.test(stack)) continue;
                return stack.m_41620_(maxExtract);
            }
        }
        return ItemStack.f_41583_;
    }

    public ItemStack insertStackToCaster(@Nullable LivingEntity shooter, SpellContext spellContext, ItemStack stack) {
        IPickupResponder responder = null;
        if (spellContext.castingTile instanceof IPickupResponder) {
            responder = (IPickupResponder)spellContext.castingTile;
        } else if (shooter instanceof IInventoryResponder) {
            responder = (IPickupResponder)shooter;
        }
        if (responder != null) {
            return responder.onPickup(stack);
        }
        if (this.isRealPlayer(shooter)) {
            Player player = (Player)shooter;
            VoidJar.tryVoiding(player, stack);
            if (!player.m_36356_(stack)) {
                ItemEntity i = new ItemEntity(shooter.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                shooter.f_19853_.m_7967_((Entity)i);
            }
        }
        return stack;
    }

    protected Set<AbstractAugment> getPotionAugments() {
        return this.setOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAmplify.INSTANCE);
    }

    protected Set<AbstractAugment> getSummonAugments() {
        return this.setOf(AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE);
    }
}

