/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class GlyphButton
extends Button {
    private final int id;
    public boolean isCraftingSlot;
    public AbstractSpellPart abstractSpellPart;
    public String tooltip = "tooltip";
    public List<SpellValidationError> validationErrors;
    GuiSpellBook parent;

    public GlyphButton(GuiSpellBook parent, int x, int y, boolean isCraftingSlot, AbstractSpellPart abstractSpellPart) {
        super(x, y, 16, 16, Component.m_130674_((String)""), parent::onGlyphClick);
        this.parent = parent;
        this.f_93620_ = x;
        this.f_93621_ = y;
        this.f_93618_ = 16;
        this.f_93619_ = 16;
        this.isCraftingSlot = isCraftingSlot;
        this.abstractSpellPart = abstractSpellPart;
        this.id = 0;
        this.validationErrors = new LinkedList<SpellValidationError>();
    }

    public int getId() {
        return this.id;
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            if (this.abstractSpellPart.isRenderAsIcon()) {
                if (this.abstractSpellPart.getIcon() != null && !this.abstractSpellPart.getIcon().equals("")) {
                    GL11.glEnable((int)3042);
                    if (this.validationErrors.isEmpty()) {
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    } else {
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                    }
                    GuiSpellBook.drawFromTexture(new ResourceLocation("ars_nouveau", "textures/items/" + this.abstractSpellPart.getIcon()), this.f_93620_, this.f_93621_, 0, 0, 16, 16, 16, 16, ms);
                    GL11.glDisable((int)3042);
                }
            } else {
                Item glyphItem = ArsNouveauAPI.getInstance().getGlyphItemMap().get(this.abstractSpellPart.getId()).get();
                RenderUtils.drawItemAsIcon(glyphItem, ms, this.f_93620_, this.f_93621_, 16, !this.validationErrors.isEmpty());
            }
            if (this.parent.isMouseInRelativeRange(mouseX, mouseY, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_) && this.parent.api.getSpellpartMap().containsKey(this.abstractSpellPart.getId())) {
                ArrayList<Object> tip = new ArrayList<Object>();
                AbstractSpellPart spellPart = this.parent.api.getSpellpartMap().get(this.abstractSpellPart.getId());
                tip.add(new TranslatableComponent(spellPart.getLocalizationKey()));
                for (SpellValidationError ve : this.validationErrors) {
                    tip.add(ve.makeTextComponentAdding().m_130940_(ChatFormatting.RED));
                }
                if (Screen.m_96638_()) {
                    tip.add(spellPart.getBookDescLang());
                } else {
                    tip.add(new TranslatableComponent("tooltip.ars_nouveau.hold_shift"));
                }
                this.parent.tooltip = tip;
            }
        }
    }
}

