/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarStarbuncle;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class FamiliarCarbyRenderer
extends GeoEntityRenderer<FamiliarStarbuncle> {
    private static final ResourceLocation ORANGE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_orange.png");
    private static final ResourceLocation PURPLE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_purple.png");
    private static final ResourceLocation GREEN = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_green.png");
    private static final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_wild_orange.png");

    public FamiliarCarbyRenderer(EntityRendererProvider.Context manager) {
        super(manager, (AnimatedGeoModel)new FamiliarCarbyModel());
    }

    protected void applyRotations(FamiliarStarbuncle entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.applyRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    public void render(FamiliarStarbuncle entity, float entityYaw, float p_225623_3_, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int p_225623_6_) {
        super.render((LivingEntity)entity, entityYaw, p_225623_3_, matrixStack, iRenderTypeBuffer, p_225623_6_);
    }

    public ResourceLocation getColor(FamiliarStarbuncle e) {
        String color = e.getColor().toLowerCase();
        if (color.isEmpty()) {
            return ORANGE;
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_" + color + ".png");
    }

    public ResourceLocation getTextureLocation(FamiliarStarbuncle entity) {
        return this.getColor(entity);
    }

    public RenderType getRenderType(FamiliarStarbuncle animatable, float partialTicks, PoseStack stack, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110458_((ResourceLocation)textureLocation);
    }

    public static class FamiliarCarbyModel
    extends AnimatedGeoModel<FamiliarStarbuncle> {
        private final ResourceLocation WILD_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_wild_orange.png");
        private final ResourceLocation TAMED_TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/carbuncle_orange.png");

        public void setLivingAnimations(FamiliarStarbuncle entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
            super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
            IBone head = this.getAnimationProcessor().getBone("head");
            EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
            head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }

        public ResourceLocation getModelLocation(FamiliarStarbuncle carbuncle) {
            return new ResourceLocation("ars_nouveau", "geo/carbuncle.geo.json");
        }

        public ResourceLocation getTextureLocation(FamiliarStarbuncle carbuncle) {
            return this.WILD_TEXTURE;
        }

        public ResourceLocation getAnimationFileLocation(FamiliarStarbuncle carbuncle) {
            return new ResourceLocation("ars_nouveau", "animations/carbuncle_animations.json");
        }
    }
}

