/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.api.client.IVariantTextureProvider;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleSparkleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.renderer.entity.SylphModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class SylphRenderer
extends GeoEntityRenderer {
    public SylphRenderer(EntityRendererProvider.Context manager) {
        super(manager, (AnimatedGeoModel)new SylphModel());
    }

    public void render(LivingEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        Level world = entityIn.m_20193_();
        Random rand = ParticleUtil.r;
        Vec3 particlePos = entityIn.m_20182_();
        IBone sylph = ((SylphModel)this.getGeoModelProvider()).getBone("sylph");
        IBone propellers = ((SylphModel)this.getGeoModelProvider()).getBone("propellers");
        float offsetY = sylph.getPositionY() / 9.0f;
        float roteAngle = propellers.getRotationY() / 4.0f;
        if (rand.nextInt(5) == 0) {
            for (int i = 0; i < 5; ++i) {
                world.m_7106_(ParticleSparkleData.createData(new ParticleColor(52, 255, 36), 0.05f, 60), particlePos.m_7096_() + Math.cos(roteAngle) / 2.0, particlePos.m_7098_() + 0.5 + (double)offsetY, particlePos.m_7094_() + Math.sin(roteAngle) / 2.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public ResourceLocation getTextureLocation(LivingEntity entity) {
        if (entity instanceof IVariantTextureProvider) {
            IVariantTextureProvider iVariantTextureProvider = (IVariantTextureProvider)entity;
            return iVariantTextureProvider.getTexture(entity);
        }
        return new ResourceLocation("ars_nouveau", "textures/entity/sylph_summer.png");
    }

    public RenderType getRenderType(Object animatable, float partialTicks, PoseStack stack, @Nullable MultiBufferSource renderTypeBuffer, @Nullable VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110458_((ResourceLocation)textureLocation);
    }
}

