/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;

public class GrowClusterGoal
extends Goal {
    public AmethystGolem golem;
    public Supplier<Boolean> canUse;
    BlockPos pathPos;
    int usingTicks;
    boolean isDone;

    public GrowClusterGoal(AmethystGolem golem, Supplier<Boolean> canUse) {
        this.golem = golem;
        this.canUse = canUse;
    }

    public void m_8037_() {
        super.m_8037_();
        --this.usingTicks;
        if (this.pathPos != null) {
            Path path = this.golem.m_21573_().m_7864_(this.pathPos, 1);
            if (path != null) {
                this.golem.m_21573_().m_26536_(path, (double)1.3f);
            }
            if (BlockUtil.distanceFrom(this.golem.m_142538_(), this.pathPos) <= 2.0) {
                this.golem.setImbueing(true);
                this.golem.setImbuePos(this.pathPos);
            }
        }
        if (this.usingTicks <= 0) {
            this.growCluster();
        }
    }

    public void m_8056_() {
        this.usingTicks = 120;
        this.isDone = false;
        for (BlockPos p : this.golem.buddingBlocks) {
            Path path = this.golem.m_21573_().m_7864_(p, 2);
            if (path == null || !path.m_77403_()) continue;
            this.pathPos = p;
            break;
        }
    }

    public void growCluster() {
        int numGrown = 0;
        for (BlockPos p : this.golem.buddingBlocks) {
            if (numGrown > 3) break;
            if (this.golem.f_19853_.m_8055_(p).m_60734_() != Blocks.f_152491_) continue;
            this.golem.f_19853_.m_8055_(p).m_60735_((ServerLevel)this.golem.f_19853_, p, this.golem.m_21187_());
            ++numGrown;
        }
        this.isDone = true;
        this.golem.growCooldown = 300;
        this.golem.setImbueing(false);
    }

    public void m_8041_() {
        this.golem.setImbueing(false);
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_8045_() {
        return !this.isDone;
    }

    public boolean m_8036_() {
        return this.canUse.get() != false && this.golem.growCooldown <= 0 && !this.golem.buddingBlocks.isEmpty();
    }
}

