/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StoreItemGoal
extends ExtendedRangeGoal {
    private final Starbuncle starbuncle;
    BlockPos storePos;
    boolean unreachable;

    public StoreItemGoal(Starbuncle starbuncle) {
        super(25);
        this.starbuncle = starbuncle;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.storePos = null;
        this.unreachable = false;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.storePos = this.starbuncle.getValidStorePos(this.starbuncle.getHeldStack());
        if (this.storePos != null && !this.starbuncle.getHeldStack().m_41619_()) {
            this.starbuncle.getNavigation().tryMoveToBlockPos(this.storePos, 1.3);
            this.startDistance = BlockUtil.distanceFrom(this.starbuncle.f_19825_, this.storePos);
        }
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (!this.starbuncle.getHeldStack().m_41619_() && this.storePos != null && BlockUtil.distanceFrom(this.starbuncle.m_20182_(), this.storePos) <= 2.0 + this.extendedRange) {
            this.starbuncle.getNavigation().m_26573_();
            Level world = this.starbuncle.f_19853_;
            BlockEntity tileEntity = world.m_7702_(this.storePos);
            if (tileEntity == null) {
                return;
            }
            IItemHandler iItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            if (iItemHandler != null) {
                ItemStack oldStack = new ItemStack((ItemLike)this.starbuncle.getHeldStack().m_41720_(), this.starbuncle.getHeldStack().m_41613_());
                ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)this.starbuncle.getHeldStack(), (boolean)false);
                if (left.equals(oldStack)) {
                    return;
                }
                if (world instanceof ServerLevel) {
                    try {
                        OpenChestEvent event = new OpenChestEvent(FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world)), this.storePos, 20);
                        event.open();
                        EventQueue.getServerInstance().addEvent(event);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.starbuncle.setHeldStack(left);
                this.starbuncle.setBackOff(5 + this.starbuncle.f_19853_.f_46441_.nextInt(20));
                return;
            }
        }
        if (this.storePos != null && !this.starbuncle.getHeldStack().m_41619_()) {
            this.setPath(this.storePos.m_123341_(), this.storePos.m_123342_(), this.storePos.m_123343_(), 1.3);
        }
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.starbuncle.getNavigation().tryMoveToBlockPos(new BlockPos(x, y, z), 1.3);
        if (this.starbuncle.getNavigation().m_26570_() != null && !this.starbuncle.getNavigation().m_26570_().m_77403_()) {
            this.unreachable = true;
        }
    }

    public boolean m_8045_() {
        return !this.unreachable && this.starbuncle.isTamed() && this.starbuncle.getHeldStack() != null && !this.starbuncle.getHeldStack().m_41619_() && this.starbuncle.getBackOff() == 0 && this.storePos != null;
    }

    @Override
    public boolean m_8036_() {
        return this.starbuncle.isTamed() && this.starbuncle.getHeldStack() != null && !this.starbuncle.getHeldStack().m_41619_() && this.starbuncle.getBackOff() == 0;
    }
}

