/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.Config;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Glyph
extends ModItem {
    public AbstractSpellPart spellPart;

    public Glyph(String registryName, AbstractSpellPart part) {
        super(registryName);
        this.spellPart = part;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.f_46443_) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        if (!Config.isSpellEnabled(this.spellPart.getId())) {
            playerIn.m_6352_((Component)new TranslatableComponent("ars_nouveau.spell.disabled"), Util.f_137441_);
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        IPlayerCap playerDataCap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)playerIn).orElse(null);
        if (playerDataCap != null) {
            if (playerDataCap.knowsGlyph(this.spellPart) || ArsNouveauAPI.getInstance().getDefaultStartingSpells().contains(this.spellPart)) {
                playerIn.m_6352_((Component)new TextComponent("You already know this spell!"), Util.f_137441_);
                return super.m_7203_(worldIn, playerIn, handIn);
            }
            if (playerDataCap.unlockGlyph(this.spellPart)) {
                CapabilityRegistry.EventHandler.syncPlayerCap(playerIn);
                playerIn.m_21120_(handIn).m_41774_(1);
                playerIn.m_6352_((Component)new TextComponent("Unlocked " + this.spellPart.getName()), Util.f_137441_);
            }
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        if (this.spellPart == null) {
            return;
        }
        if (!Config.isSpellEnabled(this.spellPart.getId())) {
            tooltip2.add((Component)new TranslatableComponent("tooltip.ars_nouveau.glyph_disabled"));
        } else if (this.spellPart != null) {
            tooltip2.add((Component)new TranslatableComponent("tooltip.ars_nouveau.glyph_level", new Object[]{this.spellPart.getTier().value}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)));
            tooltip2.add((Component)new TranslatableComponent("ars_nouveau.schools"));
            for (SpellSchool s : this.spellPart.spellSchools) {
                tooltip2.add((Component)s.getTextComponent());
            }
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        IPlayerCap playerDataCap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)Minecraft.m_91087_().f_91074_).orElse(null);
        if (playerDataCap != null) {
            if (playerDataCap.knowsGlyph(this.spellPart) || ArsNouveauAPI.getInstance().getDefaultStartingSpells().contains(this.spellPart)) {
                tooltip2.add((Component)new TranslatableComponent("tooltip.ars_nouveau.glyph_known").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)));
            } else {
                tooltip2.add((Component)new TranslatableComponent("tooltip.ars_nouveau.glyph_unknown").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED)));
            }
        }
        tooltip2.add((Component)new TranslatableComponent(" "));
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84873_())) {
            tooltip2.add((Component)this.spellPart.getBookDescLang());
        } else {
            tooltip2.add((Component)new TranslatableComponent("tooltip.ars_nouveau.hold_shift"));
        }
    }
}

