/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.client.gui.RadialMenu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.RadialMenu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.RadialMenu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.keybindings.ModKeyBindings;
import com.hollingsworth.arsnouveau.client.renderer.item.SpellBookRenderer;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.capability.IPlayerCap;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketSetBookMode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class SpellBook
extends Item
implements IAnimatable,
ICasterTool {
    public SpellTier tier;
    AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public SpellBook(SpellTier tier) {
        super(new Item.Properties().m_41487_(1).m_41491_(ArsNouveau.itemGroup));
        this.tier = tier;
    }

    public SpellBook(Item.Properties properties, SpellTier tier) {
        super(properties);
        this.tier = tier;
    }

    public boolean m_41465_() {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        CapabilityRegistry.getMana((LivingEntity)playerIn).ifPresent(iMana -> {
            if (iMana.getBookTier() < this.tier.value) {
                iMana.setBookTier(this.tier.value);
            }
            IPlayerCap cap = (IPlayerCap)CapabilityRegistry.getPlayerDataCap((LivingEntity)playerIn).orElse((Object)new ANPlayerDataCap());
            if (iMana.getGlyphBonus() < cap.getKnownGlyphs().size()) {
                iMana.setGlyphBonus(cap.getKnownGlyphs().size());
            }
        });
        ISpellCaster caster = this.getSpellCaster(stack);
        return caster.castSpell(worldIn, playerIn, handIn, new TranslatableComponent("ars_nouveau.invalid_spell"));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add((Component)new TranslatableComponent("ars_nouveau.spell_book.select", new Object[]{KeyMapping.m_90842_((String)ModKeyBindings.OPEN_RADIAL_HUD.m_90860_()).get()}));
        tooltip.add((Component)new TranslatableComponent("ars_nouveau.spell_book.craft", new Object[]{KeyMapping.m_90842_((String)ModKeyBindings.OPEN_BOOK.m_90860_()).get()}));
        tooltip.add((Component)new TranslatableComponent("tooltip.ars_nouveau.caster_level", new Object[]{this.getTier().value}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)));
    }

    public SpellTier getTier() {
        return this.tier;
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    @NotNull
    public ISpellCaster getSpellCaster(ItemStack stack) {
        return new BookCaster(stack);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IItemRenderProperties(){
            private final BlockEntityWithoutLevelRenderer renderer = new SpellBookRenderer();

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return this.renderer;
            }
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onOpenBookMenuKeyPressed(ItemStack stack, Player player) {
        GuiSpellBook.open(stack, ((SpellBook)stack.m_41720_()).getTier().value);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRadialKeyPressed(ItemStack stack, Player player) {
        Minecraft.m_91087_().m_91152_(new GuiRadialMenu<ResourceLocation>(this.getRadialMenuProvider(stack)));
    }

    public RadialMenu<ResourceLocation> getRadialMenuProvider(ItemStack itemStack) {
        return new RadialMenu<ResourceLocation>(slot -> {
            BookCaster caster = new BookCaster(itemStack);
            caster.setCurrentSlot(slot);
            Networking.INSTANCE.sendToServer((Object)new PacketSetBookMode(itemStack.m_41783_()));
        }, this.getRadialMenuSlots(itemStack), RenderUtils::drawTextureFromResourceLocation, 3);
    }

    public List<RadialMenuSlot<ResourceLocation>> getRadialMenuSlots(ItemStack itemStack) {
        BookCaster spellCaster = new BookCaster(itemStack);
        ArrayList<RadialMenuSlot<ResourceLocation>> radialMenuSlots = new ArrayList<RadialMenuSlot<ResourceLocation>>();
        for (int i = 1; i <= spellCaster.getMaxSlots(); ++i) {
            Spell spell = spellCaster.getSpell(i);
            ResourceLocation primaryIcon = null;
            ArrayList<ResourceLocation> secondaryIcons = new ArrayList<ResourceLocation>();
            for (AbstractSpellPart p : spell.recipe) {
                if (p instanceof AbstractCastMethod) {
                    secondaryIcons.add(new ResourceLocation("ars_nouveau", "textures/items/" + p.getIcon()));
                }
                if (!(p instanceof AbstractEffect)) continue;
                primaryIcon = new ResourceLocation("ars_nouveau", "textures/items/" + p.getIcon());
                break;
            }
            radialMenuSlots.add(new RadialMenuSlot<Object>(spellCaster.getSpellName(i), primaryIcon, (List<Object>)secondaryIcons));
        }
        return radialMenuSlots;
    }

    public static class BookCaster
    extends SpellCaster {
        public BookCaster(ItemStack stack) {
            super(stack);
        }

        public BookCaster(CompoundTag tag) {
            super(tag);
        }

        @Override
        public int getMaxSlots() {
            return 10;
        }
    }
}

