/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.light;

import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.light.LambDynamicLight;
import com.hollingsworth.arsnouveau.setup.Config;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightManager {
    private static final Set<LambDynamicLight> dynamicLightSources = new HashSet<LambDynamicLight>();
    private static final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();
    public static long lastUpdate = System.currentTimeMillis();
    public static int lastUpdateCount = 0;
    private static Map<EntityType<? extends Entity>, List<Function<Entity, Integer>>> LIGHT_REGISTRY = new HashMap<EntityType<? extends Entity>, List<Function<Entity, Integer>>>();
    private static final double MAX_RADIUS = 7.75;
    private static final double MAX_RADIUS_SQUARED = 60.0625;

    public static void init() {
        LightManager.register((EntityType<? extends Entity>)EntityType.f_20532_, p -> {
            if (p instanceof Player) {
                Player player = (Player)p;
                NonNullList list = player.f_36093_.f_35974_;
                for (int i = 0; i < 9; ++i) {
                    ItemStack jar = (ItemStack)list.get(i);
                    if (jar.m_41720_() != ItemsRegistry.JAR_OF_LIGHT) continue;
                    return 15;
                }
            }
            return 0;
        });
        LightManager.register(ModEntities.ENTITY_FLYING_ITEM, p -> 10);
        LightManager.register(ModEntities.ENTITY_FOLLOW_PROJ, p -> 10);
        LightManager.register(ModEntities.SPELL_PROJ, p -> 15);
        LightManager.register(ModEntities.ORBIT_SPELL, p -> 15);
        LightManager.register(ModEntities.LINGER_SPELL, p -> 15);
        LightManager.register(ModEntities.STARBUNCLE_TYPE, p -> {
            if (p.f_19853_.m_45517_(LightLayer.BLOCK, p.m_142538_()) < 6) {
                return 10;
            }
            return 0;
        });
        LightManager.register(ModEntities.ENTITY_FAMILIAR_STARBUNCLE, p -> {
            if (p.f_19853_.m_45517_(LightLayer.BLOCK, p.m_142538_()) < 6) {
                return 10;
            }
            return 0;
        });
    }

    public static void register(EntityType<? extends Entity> type, Function<Entity, Integer> luminanceFunction) {
        if (!LIGHT_REGISTRY.containsKey(type)) {
            LIGHT_REGISTRY.put(type, new ArrayList());
        }
        LIGHT_REGISTRY.get(type).add(luminanceFunction);
    }

    public static Map<EntityType<? extends Entity>, List<Function<Entity, Integer>>> getLightRegistry() {
        return LIGHT_REGISTRY;
    }

    public static void addLightSource(LambDynamicLight lightSource) {
        if (!lightSource.getDynamicLightWorld().m_5776_()) {
            return;
        }
        if (!LightManager.shouldUpdateDynamicLight()) {
            return;
        }
        if (LightManager.containsLightSource(lightSource)) {
            return;
        }
        lightSourcesLock.writeLock().lock();
        dynamicLightSources.add(lightSource);
        lightSourcesLock.writeLock().unlock();
    }

    public static boolean containsLightSource(@NotNull LambDynamicLight lightSource) {
        if (!lightSource.getDynamicLightWorld().m_5776_()) {
            return false;
        }
        lightSourcesLock.readLock().lock();
        boolean result = dynamicLightSources.contains(lightSource);
        lightSourcesLock.readLock().unlock();
        return result;
    }

    public int getLightSourcesCount() {
        lightSourcesLock.readLock().lock();
        int result = dynamicLightSources.size();
        lightSourcesLock.readLock().unlock();
        return result;
    }

    public static void removeLightSource(LambDynamicLight lightSource) {
        lightSourcesLock.writeLock().lock();
        Iterator<LambDynamicLight> sourceIterator = dynamicLightSources.iterator();
        while (sourceIterator.hasNext()) {
            LambDynamicLight it = sourceIterator.next();
            if (!it.equals(lightSource)) continue;
            sourceIterator.remove();
            if (Minecraft.m_91087_().f_91073_ == null) break;
            lightSource.lambdynlights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
            break;
        }
        lightSourcesLock.writeLock().unlock();
    }

    public static void clearLightSources() {
        lightSourcesLock.writeLock().lock();
        Iterator<LambDynamicLight> sourceIterator = dynamicLightSources.iterator();
        while (sourceIterator.hasNext()) {
            LambDynamicLight it = sourceIterator.next();
            sourceIterator.remove();
            if (Minecraft.m_91087_().f_91060_ == null) continue;
            if (it.getLuminance() > 0) {
                it.resetDynamicLight();
            }
            it.lambdynlights$scheduleTrackedChunksRebuild(Minecraft.m_91087_().f_91060_);
        }
        lightSourcesLock.writeLock().unlock();
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, @NotNull BlockPos chunkPos) {
        LightManager.scheduleChunkRebuild(renderer, chunkPos.m_123341_(), chunkPos.m_123342_(), chunkPos.m_123343_());
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, long chunkPos) {
        LightManager.scheduleChunkRebuild(renderer, BlockPos.m_121983_((long)chunkPos), BlockPos.m_122008_((long)chunkPos), BlockPos.m_122015_((long)chunkPos));
    }

    public static void scheduleChunkRebuild(@NotNull LevelRenderer renderer, int x, int y, int z) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            renderer.m_109770_(x, y, z);
        }
    }

    public static void updateAll(LevelRenderer renderer) {
        long now;
        lastUpdate = now = System.currentTimeMillis();
        lastUpdateCount = 0;
        lightSourcesLock.readLock().lock();
        for (LambDynamicLight lightSource : dynamicLightSources) {
            if (!lightSource.lambdynlights$updateDynamicLight(renderer)) continue;
            ++lastUpdateCount;
        }
        lightSourcesLock.readLock().unlock();
    }

    public static void updateTrackedChunks(@NotNull BlockPos chunkPos, @Nullable LongOpenHashSet old, @Nullable LongOpenHashSet newPos) {
        if (old != null || newPos != null) {
            long pos = chunkPos.m_121878_();
            if (old != null) {
                old.remove(pos);
            }
            if (newPos != null) {
                newPos.add(pos);
            }
        }
    }

    public static int getLightmapWithDynamicLight(@NotNull BlockPos pos, int lightmap) {
        return LightManager.getLightmapWithDynamicLight(LightManager.getDynamicLightLevel(pos), lightmap);
    }

    public static int getLightmapWithDynamicLight(double dynamicLightLevel, int lightmap) {
        int blockLevel;
        if (dynamicLightLevel > 0.0 && dynamicLightLevel > (double)(blockLevel = LightManager.getBlockLightNoPatch(lightmap))) {
            int luminance = (int)(dynamicLightLevel * 16.0);
            lightmap &= 0xFFF00000;
            lightmap |= luminance & 0xFFFFF;
        }
        return lightmap;
    }

    public static int getBlockLightNoPatch(int light) {
        return light >> 4 & 0xFFFF;
    }

    public static double getDynamicLightLevel(@NotNull BlockPos pos) {
        double result = 0.0;
        lightSourcesLock.readLock().lock();
        for (LambDynamicLight lightSource : dynamicLightSources) {
            result = LightManager.maxDynamicLightLevel(pos, lightSource, result);
        }
        lightSourcesLock.readLock().unlock();
        return Mth.m_14008_((double)result, (double)0.0, (double)15.0);
    }

    public static double maxDynamicLightLevel(@NotNull BlockPos pos, @NotNull LambDynamicLight lightSource, double currentLightLevel) {
        double multiplier;
        double lightLevel;
        double dz;
        double dy;
        double dx;
        double distanceSquared;
        int luminance = lightSource.getLuminance();
        if (luminance > 0 && (distanceSquared = (dx = (double)pos.m_123341_() - lightSource.getDynamicLightX() + 0.5) * dx + (dy = (double)pos.m_123342_() - lightSource.getDynamicLightY() + 0.5) * dy + (dz = (double)pos.m_123343_() - lightSource.getDynamicLightZ() + 0.5) * dz) <= 60.0625 && (lightLevel = (multiplier = 1.0 - Math.sqrt(distanceSquared) / 7.75) * (double)luminance) > currentLightLevel) {
            return lightLevel;
        }
        return currentLightLevel;
    }

    public static void updateTracking(@NotNull LambDynamicLight lightSource) {
        boolean enabled = lightSource.isDynamicLightEnabled();
        int luminance = lightSource.getLuminance();
        if (!enabled && luminance > 0) {
            lightSource.setDynamicLightEnabled(true);
        } else if (enabled && luminance < 1) {
            lightSource.setDynamicLightEnabled(false);
        }
    }

    public static boolean shouldUpdateDynamicLight() {
        return Config.DYNAMIC_LIGHTS_ENABLED != null && (Boolean)Config.DYNAMIC_LIGHTS_ENABLED.get() != false;
    }

    public static void toggleLightsAndConfig(boolean enabled) {
        Config.DYNAMIC_LIGHTS_ENABLED.set((Object)enabled);
        Config.DYNAMIC_LIGHTS_ENABLED.save();
        if (!enabled) {
            LightManager.clearLightSources();
        }
    }
}

