/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class MagicTrunkPlacer
extends TrunkPlacer {
    public MagicTrunkPlacer(int baseHeight, int height_rand_a, int height_rand_b) {
        super(baseHeight, height_rand_a, height_rand_b);
    }

    protected TrunkPlacerType<?> m_7362_() {
        return TrunkPlacerType.f_70319_;
    }

    public List<FoliagePlacer.FoliageAttachment> m_142625_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> consumer, Random rand, int foliageHeight, BlockPos pos, TreeConfiguration baseTreeFeatureConfig) {
        ArrayList list = Lists.newArrayList();
        BlockPos blockpos = pos.m_7495_();
        MagicTrunkPlacer.m_161880_((LevelSimulatedReader)world, consumer, (Random)rand, (BlockPos)blockpos, (TreeConfiguration)baseTreeFeatureConfig);
        MagicTrunkPlacer.m_161880_((LevelSimulatedReader)world, consumer, (Random)rand, (BlockPos)blockpos.m_142126_(), (TreeConfiguration)baseTreeFeatureConfig);
        MagicTrunkPlacer.m_161880_((LevelSimulatedReader)world, consumer, (Random)rand, (BlockPos)blockpos.m_142128_(), (TreeConfiguration)baseTreeFeatureConfig);
        MagicTrunkPlacer.m_161880_((LevelSimulatedReader)world, consumer, (Random)rand, (BlockPos)blockpos.m_142128_().m_142126_(), (TreeConfiguration)baseTreeFeatureConfig);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        int yOffset = y + foliageHeight - 1;
        int numBranches = 0;
        int lastBranch = 0;
        boolean northB = (double)rand.nextFloat() >= 0.5;
        boolean southB = (double)rand.nextFloat() >= 0.5;
        boolean eastB = (double)rand.nextFloat() >= 0.5;
        boolean westB = (double)rand.nextFloat() >= 0.5;
        for (int i = 0; i < foliageHeight; ++i) {
            int j2 = y + i;
            BlockPos blockpos1 = new BlockPos(x, j2, z);
            if (TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)blockpos1)) {
                MagicTrunkPlacer.m_161893_((LevelSimulatedReader)world, consumer, (Random)rand, (BlockPos)blockpos1, (TreeConfiguration)baseTreeFeatureConfig);
                MagicTrunkPlacer.m_161893_((LevelSimulatedReader)world, consumer, (Random)rand, (BlockPos)blockpos1.m_142126_(), (TreeConfiguration)baseTreeFeatureConfig);
                MagicTrunkPlacer.m_161893_((LevelSimulatedReader)world, consumer, (Random)rand, (BlockPos)blockpos1.m_142128_(), (TreeConfiguration)baseTreeFeatureConfig);
                MagicTrunkPlacer.m_161893_((LevelSimulatedReader)world, consumer, (Random)rand, (BlockPos)blockpos1.m_142126_().m_142128_(), (TreeConfiguration)baseTreeFeatureConfig);
            }
            if (i < 1) {
                this.addRoots(world, rand, pos.m_142125_().m_6630_(i), consumer, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.m_142128_().m_142128_().m_6630_(i), consumer, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.m_142128_().m_142125_().m_6630_(i), consumer, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.m_142128_().m_142128_().m_142126_().m_6630_(i), consumer, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.m_142126_().m_142126_().m_6630_(i), consumer, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.m_142126_().m_142126_().m_142128_().m_6630_(i), consumer, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.m_142126_().m_142127_().m_6630_(i), consumer, baseTreeFeatureConfig);
                this.addRoots(world, rand, pos.m_142127_().m_6630_(i), consumer, baseTreeFeatureConfig);
            }
            if (i > 1 && i > lastBranch) {
                if (northB) {
                    this.addBranch(world, pos, i, Direction.NORTH, rand, baseTreeFeatureConfig, consumer);
                    lastBranch = i;
                    ++numBranches;
                    northB = false;
                } else if (southB) {
                    this.addBranch(world, pos.m_142300_(Direction.SOUTH), i, Direction.SOUTH, rand, baseTreeFeatureConfig, consumer);
                    lastBranch = i;
                    ++numBranches;
                    southB = false;
                } else if (eastB) {
                    this.addBranch(world, pos.m_142300_(Direction.EAST).m_142128_(), i, Direction.EAST, rand, baseTreeFeatureConfig, consumer);
                    lastBranch = i;
                    ++numBranches;
                    eastB = false;
                } else if (westB) {
                    this.addBranch(world, pos, i, Direction.WEST, rand, baseTreeFeatureConfig, consumer);
                    lastBranch = i;
                    ++numBranches;
                    westB = false;
                } else if (numBranches == 0) {
                    this.addBranch(world, pos, i, Direction.NORTH, rand, baseTreeFeatureConfig, consumer);
                    lastBranch = i;
                    ++numBranches;
                    this.addBranch(world, pos, i, Direction.SOUTH, rand, baseTreeFeatureConfig, consumer);
                    ++numBranches;
                }
            }
            if (i != foliageHeight - 2) continue;
            float leafChance = 0.1f;
            this.addLineLeaves(world, pos.m_142390_(4).m_6630_(i), Direction.NORTH, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142390_(4).m_6630_(i + 1), Direction.NORTH, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142390_(3).m_6630_(i - 1), Direction.NORTH, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142390_(3).m_6630_(i), Direction.NORTH, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142390_(3).m_6630_(i + 1), Direction.NORTH, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142390_(2).m_6630_(i + 1), Direction.NORTH, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142390_(1).m_6630_(i + 1), Direction.NORTH, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142390_(2).m_6630_(i + 2), Direction.NORTH, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(5).m_6630_(i), Direction.EAST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142385_(5).m_6630_(i + 1), Direction.EAST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142385_(4).m_6630_(i - 1), Direction.EAST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142385_(4).m_6630_(i), Direction.EAST, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(4).m_6630_(i + 1), Direction.EAST, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(3).m_6630_(i + 1), Direction.EAST, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(2).m_6630_(i + 1), Direction.EAST, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(3).m_6630_(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(2).m_6630_(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(1).m_6630_(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(0).m_6630_(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(-1).m_6630_(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(-2).m_6630_(i + 2), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142386_(4).m_142128_().m_6630_(i), Direction.WEST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142386_(4).m_142128_().m_6630_(i + 1), Direction.WEST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142386_(3).m_142128_().m_6630_(i - 1), Direction.WEST, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142386_(3).m_142128_().m_6630_(i), Direction.WEST, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142386_(3).m_142128_().m_6630_(i + 1), Direction.WEST, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142386_(2).m_142128_().m_6630_(i + 1), Direction.WEST, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142386_(1).m_142128_().m_6630_(i + 1), Direction.WEST, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142386_(2).m_142128_().m_6630_(i + 2), Direction.WEST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142383_(4).m_142126_().m_6630_(i), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142383_(4).m_142126_().m_6630_(i + 1), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142383_(5).m_142126_().m_6630_(i), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142383_(5).m_142126_().m_6630_(i + 1), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142383_(3).m_142126_().m_6630_(i + 1), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142383_(2).m_142126_().m_6630_(i + 1), Direction.SOUTH, 6, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142383_(3).m_142126_().m_6630_(i + 2), Direction.SOUTH, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(2).m_6630_(i + 3), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(1).m_6630_(i + 3), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(0).m_6630_(i + 3), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(-1).m_6630_(i + 3), Direction.EAST, 4, rand, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_142385_(2).m_6630_(i + 4), Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142385_(1).m_6630_(i + 4), Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142385_(0).m_6630_(i + 4), Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance, consumer);
            this.addLineLeaves(world, pos.m_142385_(-1).m_6630_(i + 4), Direction.EAST, 4, rand, baseTreeFeatureConfig, leafChance, consumer);
        }
        list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(x, yOffset, z), 0, true));
        return list;
    }

    public void addBranch(LevelSimulatedReader world, BlockPos pos, int height, Direction d, Random random, TreeConfiguration baseTreeFeatureConfig, BiConsumer<BlockPos, BlockState> consumer) {
        pos = pos.m_6630_(height);
        this.addLog(world, pos.m_142300_(d), random, baseTreeFeatureConfig, consumer);
        this.addLog(world, pos.m_142300_(d).m_6630_(1), random, baseTreeFeatureConfig, consumer);
        this.addLog(world, pos.m_142300_(d).m_6630_(2), random, baseTreeFeatureConfig, consumer);
        this.addLog(world, pos.m_5484_(d, 2).m_6630_(2), random, baseTreeFeatureConfig, consumer);
        this.addLog(world, pos.m_5484_(d, 3).m_6630_(2), random, baseTreeFeatureConfig, consumer);
        this.addLog(world, pos.m_5484_(d, 3).m_6630_(1), random, baseTreeFeatureConfig, consumer);
        this.addLineLeaves(world, pos.m_142300_(d).m_6630_(1), d, 3, random, baseTreeFeatureConfig, consumer);
        this.addLineLeaves(world, pos.m_142300_(d).m_6630_(2), d, 3, random, baseTreeFeatureConfig, consumer);
        this.addLineLeaves(world, pos.m_142300_(d).m_6630_(3), d, 3, random, baseTreeFeatureConfig, consumer);
        for (int j = 1; j < 4; ++j) {
            this.addLineLeaves(world, pos.m_5484_(d, j).m_6630_(3), d, 3, random, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_5484_(d, j).m_6630_(2), d, 3, random, baseTreeFeatureConfig, consumer);
            this.addLineLeaves(world, pos.m_5484_(d, j).m_6630_(4), d, 3, random, baseTreeFeatureConfig, 0.1f, consumer);
        }
        for (int i = 0; i < 2; ++i) {
            this.addHollowLine(world, pos.m_5484_(d, 2 + i).m_6630_(1), d, 2, random, baseTreeFeatureConfig, consumer);
            this.addHollowLine(world, pos.m_5484_(d, 2 + i).m_6630_(2), d, 2, random, baseTreeFeatureConfig, consumer);
            this.addHollowLine(world, pos.m_5484_(d, 2 + i).m_6630_(1), d, 3, random, baseTreeFeatureConfig, 0.1f, consumer);
            this.addHollowLine(world, pos.m_5484_(d, 2 + i).m_6630_(2), d, 3, random, baseTreeFeatureConfig, 0.1f, consumer);
        }
        this.addLineLeaves(world, pos.m_5484_(d, 4).m_6630_(1), d, 3, random, baseTreeFeatureConfig, consumer);
        this.addLineLeaves(world, pos.m_5484_(d, 4).m_6630_(2), d, 3, random, baseTreeFeatureConfig, consumer);
        this.addLineLeaves(world, pos.m_5484_(d, 5).m_6630_(1), d, 3, random, baseTreeFeatureConfig, 0.1f, consumer);
        this.addLineLeaves(world, pos.m_5484_(d, 5).m_6630_(2), d, 3, random, baseTreeFeatureConfig, 0.1f, consumer);
    }

    public boolean addLog(LevelSimulatedReader world, BlockPos pos, Random random, TreeConfiguration baseTreeFeatureConfig, BiConsumer<BlockPos, BlockState> consumer) {
        return this.addBlock(world, pos, baseTreeFeatureConfig.f_68185_.m_7112_(random, pos), consumer);
    }

    public boolean addBlock(LevelSimulatedReader world, BlockPos pos, BlockState state, BiConsumer<BlockPos, BlockState> consumer) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos)) {
            this.setBlock(world, pos, state, consumer);
            return true;
        }
        return false;
    }

    public void addHollowLine(LevelSimulatedReader world, BlockPos pos, Direction d, int length, Random rand, TreeConfiguration baseTreeFeatureConfig, BiConsumer<BlockPos, BlockState> consumer) {
        this.addHollowLine(world, pos, d, length, rand, baseTreeFeatureConfig, 1.0f, consumer);
    }

    public void addHollowLine(LevelSimulatedReader world, BlockPos pos, Direction d, int length, Random rand, TreeConfiguration baseTreeFeatureConfig, float chance, BiConsumer<BlockPos, BlockState> consumer) {
        Direction left = d.m_122427_();
        Direction right = left.m_122424_();
        if (rand.nextFloat() <= chance && TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos.m_5484_(left, length))) {
            this.setBlock(world, pos.m_5484_(left, length), baseTreeFeatureConfig.f_161213_.m_7112_(rand, pos.m_5484_(left, length)), consumer);
        }
        if (rand.nextFloat() <= chance && TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos.m_5484_(right, length))) {
            this.setBlock(world, pos.m_5484_(right, length), baseTreeFeatureConfig.f_161213_.m_7112_(rand, pos.m_5484_(right, length)), consumer);
        }
    }

    public void addLineLeaves(LevelSimulatedReader world, BlockPos pos, Direction d, int length, Random rand, TreeConfiguration baseTreeFeatureConfig, BiConsumer<BlockPos, BlockState> consumer) {
        if (length % 2 == 0) {
            this.addLineLeavesEven(world, pos, d, length, rand, baseTreeFeatureConfig, 1.0f, consumer);
        } else {
            this.addLineLeavesOdd(world, pos, d, length, rand, baseTreeFeatureConfig, 1.0f, consumer);
        }
    }

    public void addLineLeaves(LevelSimulatedReader world, BlockPos pos, Direction d, int length, Random rand, TreeConfiguration baseTreeFeatureConfig, float chance, BiConsumer<BlockPos, BlockState> consumer) {
        if (length % 2 == 0) {
            this.addLineLeavesEven(world, pos, d, length, rand, baseTreeFeatureConfig, chance, consumer);
        } else {
            this.addLineLeavesOdd(world, pos, d, length, rand, baseTreeFeatureConfig, chance, consumer);
        }
    }

    public void addLineLeavesEven(LevelSimulatedReader world, BlockPos pos, Direction d, int length, Random rand, TreeConfiguration baseTreeFeatureConfig, float chance, BiConsumer<BlockPos, BlockState> consumer) {
        Direction left = d.m_122427_();
        Direction right = left.m_122424_();
        for (int i = 0; i < length; ++i) {
            if (!(rand.nextFloat() <= chance) || !TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos.m_5484_(left, i - length / 3))) continue;
            this.setBlock(world, pos.m_5484_(left, i - length / 3), baseTreeFeatureConfig.f_161213_.m_7112_(rand, pos.m_5484_(left, i - length / 3)), consumer);
        }
    }

    public void addLineLeavesOdd(LevelSimulatedReader world, BlockPos pos, Direction d, int length, Random rand, TreeConfiguration baseTreeFeatureConfig, float chance, BiConsumer<BlockPos, BlockState> consumer) {
        Direction left = d.m_122427_();
        Direction right = left.m_122424_();
        length += 2;
        for (int i = 0; i < (length - 1) / 2; ++i) {
            if (rand.nextFloat() <= chance && TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos.m_5484_(left, i))) {
                this.setBlock(world, pos.m_5484_(left, i), baseTreeFeatureConfig.f_161213_.m_7112_(rand, pos.m_5484_(left, i)), consumer);
            }
            if (!(rand.nextFloat() <= chance) || !TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos.m_5484_(right, i))) continue;
            this.setBlock(world, pos.m_5484_(right, i), baseTreeFeatureConfig.f_161213_.m_7112_(rand, pos.m_5484_(right, i)), consumer);
        }
    }

    public boolean addRoots(LevelSimulatedReader world, Random rand, BlockPos pos, BiConsumer<BlockPos, BlockState> consumer, TreeConfiguration baseTreeFeatureConfig) {
        BlockState state = baseTreeFeatureConfig.f_68185_.m_7112_(rand, pos);
        if (rand.nextDouble() < 0.75 && TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos)) {
            this.setBlock(world, pos.m_7949_(), state, consumer);
            return true;
        }
        return false;
    }

    public void setBlock(LevelSimulatedReader world, BlockPos pos, BlockState state, BiConsumer<BlockPos, BlockState> consumer) {
        consumer.accept(pos, state);
    }
}

