/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.setup;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.BakedModelOverrideRegistry;
import com.refinedmods.refinedstorage.render.model.FullbrightBakedModel;
import edivad.extrastorage.blocks.CrafterTier;
import edivad.extrastorage.client.screen.AdvancedCrafterScreen;
import edivad.extrastorage.client.screen.AdvancedExporterScreen;
import edivad.extrastorage.client.screen.AdvancedFluidStorageBlockScreen;
import edivad.extrastorage.client.screen.AdvancedImporterScreen;
import edivad.extrastorage.client.screen.AdvancedStorageBlockScreen;
import edivad.extrastorage.container.AdvancedCrafterContainerMenu;
import edivad.extrastorage.items.storage.fluid.FluidStorageType;
import edivad.extrastorage.items.storage.item.ItemStorageType;
import edivad.extrastorage.setup.EventHandler;
import edivad.extrastorage.setup.Registration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientSetup {
    private static final BakedModelOverrideRegistry bakedModelOverrideRegistry = new BakedModelOverrideRegistry();

    public ClientSetup() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake);
    }

    public void init(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        for (CrafterTier crafterTier : CrafterTier.values()) {
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.CRAFTER_CONTAINER.get((Object)crafterTier).get()), AdvancedCrafterScreen::new);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registration.CRAFTER_BLOCK.get((Object)crafterTier).get()), (RenderType)RenderType.m_110463_());
            String name = crafterTier.name().toLowerCase();
            String parent = "blocks/crafter/" + name + "/cutouts/";
            bakedModelOverrideRegistry.add(Registration.CRAFTER_BLOCK.get((Object)crafterTier).getId(), (base, registry) -> new FullbrightBakedModel(base, true, new ResourceLocation[]{new ResourceLocation("extrastorage", parent + "side_connected"), new ResourceLocation("extrastorage", parent + "top_connected")}));
        }
        MenuScreens.m_96206_((MenuType)((MenuType)Registration.ADVANCED_EXPORTER_CONTAINER.get()), AdvancedExporterScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)Registration.ADVANCED_IMPORTER_CONTAINER.get()), AdvancedImporterScreen::new);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registration.ADVANCED_EXPORTER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)Registration.ADVANCED_IMPORTER.get()), (RenderType)RenderType.m_110463_());
        for (Enum enum_ : ItemStorageType.values()) {
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.ITEM_STORAGE_CONTAINER.get(enum_).get()), AdvancedStorageBlockScreen::new);
        }
        for (Enum enum_ : FluidStorageType.values()) {
            MenuScreens.m_96206_((MenuType)((MenuType)Registration.FLUID_STORAGE_CONTAINER.get(enum_).get()), AdvancedFluidStorageBlockScreen::new);
        }
        API.instance().addPatternRenderHandler(pattern -> {
            AbstractContainerMenu container = Minecraft.m_91087_().f_91074_.f_36096_;
            if (container instanceof AdvancedCrafterContainerMenu) {
                AdvancedCrafterContainerMenu actualContainer = (AdvancedCrafterContainerMenu)container;
                int slots = actualContainer.getBlockEntity().getTier().getSlots();
                for (int i = 0; i < slots; ++i) {
                    if (container.m_38853_(i).m_7993_() != pattern) continue;
                    return true;
                }
            }
            return false;
        });
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        FullbrightBakedModel.invalidateCache();
        for (ResourceLocation id : e.getModelRegistry().keySet()) {
            BakedModelOverrideRegistry.BakedModelOverrideFactory factory = bakedModelOverrideRegistry.get(new ResourceLocation(id.m_135827_(), id.m_135815_()));
            if (factory == null) continue;
            e.getModelRegistry().put(id, factory.create((BakedModel)e.getModelRegistry().get(id), e.getModelRegistry()));
        }
    }
}

