/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen;

import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.RedstoneState;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractTile;
import com.supermartijn642.tesseract.packets.PacketScreenCycleRedstoneState;
import com.supermartijn642.tesseract.screen.CycleButton;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class RedstoneButton
extends CycleButton
implements IHoverTextWidget {
    public RedstoneState state;
    private BlockPos pos;

    public RedstoneButton(int x, int y) {
        super(x, y, 60);
    }

    public void update(TesseractTile tile) {
        this.state = tile.getRedstoneState();
        this.pos = tile.m_58899_();
    }

    @Override
    protected int getCycleIndex() {
        return this.state == RedstoneState.DISABLED ? 0 : (this.state == RedstoneState.HIGH ? 1 : 2);
    }

    public void onPress() {
        super.onPress();
        if (this.pos != null) {
            Tesseract.CHANNEL.sendToServer((BasePacket)new PacketScreenCycleRedstoneState(this.pos));
        }
    }

    protected Component getNarrationMessage() {
        return this.getHoverText();
    }

    public Component getHoverText() {
        return new TranslatableComponent("gui.tesseract.redstone.speech", new Object[]{this.state.translate()});
    }
}

