/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.screen.info;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseScreen;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.tesseract.ClientProxy;
import com.supermartijn642.tesseract.screen.InfoButton;
import com.supermartijn642.tesseract.screen.info.InfoArrowWidget;
import com.supermartijn642.tesseract.screen.info.InfoPageButton;
import com.supermartijn642.tesseract.screen.info.InfoTab;
import com.supermartijn642.tesseract.screen.info.Page;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class InfoScreen
extends BaseScreen {
    private static final ResourceLocation TESSERACT_HOVER_TAB = new ResourceLocation("tesseract", "textures/gui/info/hovering_tab.png");
    public static final int WIDTH = 172;
    public static final int HEIGHT = 80;
    private final BlockPos pos;
    private static InfoTab tab = InfoTab.GUI;
    private InfoButton closeInfoButton;
    private InfoArrowWidget backButton;
    private InfoArrowWidget nextButton;
    private List<InfoPageButton> pageButtons = new LinkedList<InfoPageButton>();

    public InfoScreen(BlockPos pos) {
        super((Component)new TranslatableComponent("gui.tesseract.info.title"));
        this.pos = pos;
    }

    protected float sizeX() {
        return Math.max(172, tab.getCurrentPage().getWidth());
    }

    protected float sizeY() {
        return 80 + tab.getCurrentPage().getHeight();
    }

    protected void addWidgets() {
        this.closeInfoButton = (InfoButton)this.addWidget((Widget)new InfoButton(0, 0, () -> ClientProxy.openScreen(this.pos)));
        this.backButton = (InfoArrowWidget)this.addWidget((Widget)new InfoArrowWidget(0, 0, 7, 7, true, () -> InfoScreen.tab.currentPageIndex, tab::getNumberOfPages, this::setPage));
        this.nextButton = (InfoArrowWidget)this.addWidget((Widget)new InfoArrowWidget(0, 0, 7, 7, false, () -> InfoScreen.tab.currentPageIndex, tab::getNumberOfPages, this::setPage));
        this.updateNavigationWidgets();
    }

    private void updateNavigationWidgets() {
        int x = ((int)this.sizeX() - 172) / 2;
        this.closeInfoButton.x = x + 5;
        this.closeInfoButton.y = 5;
    }

    private void setPage(int index) {
        if (index < 0 || index >= tab.getNumberOfPages()) {
            return;
        }
        InfoScreen.tab.currentPageIndex = index;
        this.updateNavigationWidgets();
    }

    protected void render(PoseStack matrixStack, int mouseX, int mouseY) {
        int x = ((int)this.sizeX() - 172) / 2;
        InfoScreen.drawHoveringTab(matrixStack, x, 0, 30, 30);
        InfoScreen.drawHoveringTab(matrixStack, x + 40, 0, 102, 30);
        this.renderInfoTab(matrixStack, x + 43, 3, 24, 24, mouseX, mouseY, InfoTab.GUI);
        this.renderInfoTab(matrixStack, x + 67, 3, 24, 24, mouseX, mouseY, InfoTab.ITEMS);
        this.renderInfoTab(matrixStack, x + 91, 3, 24, 24, mouseX, mouseY, InfoTab.FLUID);
        this.renderInfoTab(matrixStack, x + 115, 3, 24, 24, mouseX, mouseY, InfoTab.ENERGY);
        matrixStack.m_85836_();
        Page page = tab.getCurrentPage();
        matrixStack.m_85837_((double)((float)((int)this.sizeX() - page.getWidth()) / 2.0f), 40.0, 0.0);
        page.render(matrixStack);
        matrixStack.m_85849_();
    }

    private void renderInfoTab(PoseStack matrixStack, int x, int y, int width, int height, int mouseX, int mouseY, InfoTab tab) {
        if (tab == InfoScreen.tab) {
            ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)y, (float)width, (float)height, (int)1761636432);
        } else if (mouseX > x && mouseX < x + width && mouseY > y && mouseY < y + height) {
            ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)y, (float)width, (float)1.0f, (int)-1);
            ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)(y + height - 1), (float)width, (float)1.0f, (int)-1);
            ScreenUtils.fillRect((PoseStack)matrixStack, (float)x, (float)y, (float)1.0f, (float)height, (int)-1);
            ScreenUtils.fillRect((PoseStack)matrixStack, (float)(x + width - 1), (float)y, (float)1.0f, (float)height, (int)-1);
        }
        ClientUtils.getItemRenderer().m_115123_(tab.getIconItem(), (int)this.left() + x + width / 2 - 8, (int)this.top() + y + height / 2 - 8);
    }

    protected void renderTooltips(PoseStack matrixStack, int mouseX, int mouseY) {
    }

    public static void drawHoveringTab(PoseStack matrixStack, int x, int y, int width, int height) {
        ScreenUtils.bindTexture((ResourceLocation)TESSERACT_HOVER_TAB);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)x, (float)y, (float)(width - 3), (float)(height - 3), (float)0.0f, (float)0.0f, (float)((float)(width - 3) / 200.0f), (float)((float)(height - 3) / 200.0f));
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(x + width - 3), (float)y, (float)3.0f, (float)(height - 3), (float)0.985f, (float)0.0f, (float)0.015f, (float)((float)(height - 3) / 200.0f));
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)x, (float)(y + height - 3), (float)(width - 3), (float)3.0f, (float)0.0f, (float)0.985f, (float)((float)(width - 3) / 200.0f), (float)0.015f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(x + width - 3), (float)(y + height - 3), (float)3.0f, (float)3.0f, (float)0.985f, (float)0.985f, (float)0.015f, (float)0.015f);
    }
}

