/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraftforge.common.util.Size2i;
import org.jetbrains.annotations.Nullable;

public class CraftingCategoryExtension<T extends CraftingRecipe>
implements ICraftingCategoryExtension {
    protected final T recipe;

    public CraftingCategoryExtension(T recipe) {
        this.recipe = recipe;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        List inputs = this.recipe.m_7527_().stream().map(ingredient -> List.of(ingredient.m_43908_())).toList();
        ItemStack resultItem = this.recipe.m_8043_();
        int width = this.getWidth();
        int height = this.getHeight();
        craftingGridHelper.setOutputs(builder, VanillaTypes.ITEM_STACK, List.of(resultItem));
        craftingGridHelper.setInputs(builder, VanillaTypes.ITEM_STACK, inputs, width, height);
    }

    @Override
    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipe.m_6423_();
    }

    @Override
    @Nullable
    public Size2i getSize() {
        int width = this.getWidth();
        if (width == 0) {
            return null;
        }
        int height = this.getHeight();
        if (height == 0) {
            return null;
        }
        return new Size2i(width, height);
    }

    @Override
    public int getWidth() {
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        return recipeHelper.getWidth(this.recipe);
    }

    @Override
    public int getHeight() {
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        return recipeHelper.getHeight(this.recipe);
    }
}

