/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.render;

import java.awt.image.BufferedImage;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.Strata;
import journeymap.client.cartography.Stratum;
import journeymap.client.cartography.color.RGB;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionImageCache;
import journeymap.client.model.RegionImageSet;
import journeymap.client.render.ComparableBufferedImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.dimension.DimensionType;

public class CaveRenderer
extends BaseRenderer
implements IChunkRenderer {
    protected SurfaceRenderer surfaceRenderer;
    protected StatTimer renderCaveTimer = StatTimer.get("CaveRenderer.render");
    protected Strata strata = new Strata("Cave", 40, 8, true);
    protected float defaultDim = 0.2f;
    protected boolean mapSurfaceAboveCaves;

    public CaveRenderer(SurfaceRenderer surfaceRenderer) {
        this.surfaceRenderer = surfaceRenderer;
        this.updateOptions(null, null);
        this.shadingSlopeMin = 0.2f;
        this.shadingSlopeMax = 1.1f;
        this.shadingPrimaryDownslopeMultiplier = 0.7f;
        this.shadingPrimaryUpslopeMultiplier = 1.05f;
        this.shadingSecondaryDownslopeMultiplier = 0.99f;
        this.shadingSecondaryUpslopeMultiplier = 1.01f;
    }

    @Override
    protected boolean updateOptions(ChunkMD chunkMd, MapType mapType) {
        if (super.updateOptions(chunkMd, mapType)) {
            this.mapSurfaceAboveCaves = JourneymapClient.getInstance().getCoreProperties().mapSurfaceAboveCaves.get();
            return true;
        }
        return false;
    }

    @Override
    public int getBlockHeight(ChunkMD chunkMd, BlockPos blockPos) {
        Integer vSlice = blockPos.m_123342_() >> 4;
        int[] sliceBounds = this.getVSliceBounds(chunkMd, vSlice);
        int sliceMinY = sliceBounds[0];
        int sliceMaxY = sliceBounds[1];
        Integer y = this.getBlockHeight(chunkMd, blockPos.m_123341_() & 0xF, vSlice, blockPos.m_123343_() & 0xF, sliceMinY, sliceMaxY);
        return y == null ? blockPos.m_123342_() : y.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean render(ComparableBufferedImage chunkImage, RegionData regionData, ChunkMD chunkMd, Integer vSlice) {
        if (vSlice == null) {
            Journeymap.getLogger().warn("ChunkOverworldCaveRenderer is for caves. vSlice can't be null");
            return false;
        }
        this.updateOptions(chunkMd, MapType.underground(vSlice, chunkMd.getDimension()));
        this.renderCaveTimer.start();
        try {
            MapType mapType;
            RegionImageSet ris;
            if (!this.hasSlopes(chunkMd, vSlice)) {
                this.populateSlopes(chunkMd, vSlice, this.getSlopes(chunkMd, vSlice));
            }
            ComparableBufferedImage chunkSurfaceImage = null;
            if (this.mapSurfaceAboveCaves && (ris = RegionImageCache.INSTANCE.getRegionImageSet(chunkMd, mapType = MapType.day(chunkMd.getDimension()))) != null && ris.getHolder(mapType).hasTexture()) {
                chunkSurfaceImage = ris.getChunkImage(chunkMd, mapType);
            }
            boolean bl = this.renderUnderground(chunkSurfaceImage, chunkImage, regionData, chunkMd, vSlice);
            return bl;
        }
        finally {
            this.renderCaveTimer.stop();
        }
    }

    protected void mask(BufferedImage chunkSurfaceImage, BufferedImage chunkImage, RegionData regionData, CompoundTag blockNbt, ChunkMD chunkMd, int x, int y, int z) {
        if (chunkSurfaceImage == null || !this.mapSurfaceAboveCaves) {
            int color = this.paintBlackBlock(chunkImage, x, z);
            regionData.setBlockColor(blockNbt, color, MapType.Name.underground);
        } else {
            int surfaceY = Math.max(chunkMd.getMinY(), chunkMd.getHeight(new BlockPos(x, y, z)));
            int distance = Math.max(0, surfaceY - y);
            if (distance > 16) {
                int minY = this.getBlockHeight(chunkMd, new BlockPos(x, y, z));
                BlockMD blockMD = chunkMd.getBlockMD(new BlockPos(x, y, z));
                boolean isAir = blockMD.getBlockState().m_60795_();
                if (y > chunkMd.getMinY() && minY > chunkMd.getMinY() || !isAir && y == chunkMd.getMinY() && minY == chunkMd.getMinY()) {
                    int color = this.paintBlackBlock(chunkImage, x, z);
                    regionData.setBlockColor(blockNbt, color, MapType.Name.underground);
                } else {
                    int color = this.paintVoidBlock(chunkImage, x, z);
                    regionData.setBlockColor(blockNbt, color, MapType.Name.underground);
                }
            } else {
                int color = this.paintDimOverlay(chunkSurfaceImage, chunkImage, x, z, this.defaultDim);
                regionData.setBlockColor(blockNbt, color, MapType.Name.underground);
            }
        }
    }

    protected boolean renderUnderground(BufferedImage chunkSurfaceImage, BufferedImage chunkSliceImage, RegionData regionData, ChunkMD chunkMd, int vSlice) {
        int[] sliceBounds = this.getVSliceBounds(chunkMd, vSlice);
        int sliceMinY = sliceBounds[0];
        int sliceMaxY = sliceBounds[1];
        boolean chunkOk = false;
        CompoundTag chunkNbt = regionData.getChunkNbt(chunkMd.getCoord());
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                this.strata.reset();
                CompoundTag blockNbt = regionData.getBlockDataFromBlockPos(chunkMd.getCoord(), chunkNbt, x, z);
                try {
                    int ceiling = this.getBlockHeight(chunkMd, x, vSlice, z, sliceMinY, sliceMaxY);
                    if (ceiling < chunkMd.getMinY()) {
                        int voidColor = this.paintVoidBlock(chunkSliceImage, x, z);
                        regionData.setBlockColor(blockNbt, voidColor, MapType.Name.underground);
                        chunkOk = true;
                        continue;
                    }
                    int y = Math.min(ceiling, sliceMaxY);
                    this.buildStrata(this.strata, regionData, blockNbt, sliceMinY - 1, chunkMd, x, y, z);
                    if (this.strata.isEmpty()) {
                        this.mask(chunkSurfaceImage, chunkSliceImage, regionData, blockNbt, chunkMd, x, y, z);
                        chunkOk = true;
                        continue;
                    }
                    chunkOk = this.paintStrata(this.strata, chunkSliceImage, regionData, blockNbt, chunkMd, vSlice, x, ceiling, z) || chunkOk;
                    continue;
                }
                catch (Throwable t) {
                    this.paintBadBlock(chunkSliceImage, x, vSlice, z);
                    String error = "CaveRenderer error at x,vSlice,z = " + x + "," + vSlice + "," + z + " : " + LogFormatter.toString(t);
                    Journeymap.getLogger().error(error);
                }
            }
        }
        regionData.writeChunk(chunkMd.getCoord(), chunkNbt);
        this.strata.reset();
        return chunkOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildStrata(Strata strata, RegionData regionData, CompoundTag blockNbt, int minY, ChunkMD chunkMd, int x, int topY, int z) {
        BlockMD blockMD = null;
        BlockMD lavaBlockMD = null;
        try {
            int y;
            for (y = this.getBlockHeight(chunkMd, x, topY >> 4, z, minY, topY).intValue(); y >= chunkMd.getMinY(); --y) {
                blockMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y, z);
                if (blockMD.isIgnore() || blockMD.hasFlag(BlockFlag.OpenToSky)) continue;
                strata.setBlocksFound(true);
                BlockMD blockAboveMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y + 1, z);
                if (blockMD.isLava() && blockAboveMD.isLava()) {
                    lavaBlockMD = blockMD;
                }
                if (blockAboveMD.isIgnore() || blockAboveMD.hasFlag(BlockFlag.OpenToSky)) {
                    if (!chunkMd.hasNoSky().booleanValue() && chunkMd.canBlockSeeTheSky(x, y + 1, z)) continue;
                    int lightLevel = this.getSliceLightLevel(chunkMd, x, y, z, true);
                    if (lightLevel > 0) {
                        BlockPos pos = chunkMd.getBlockPos(x, y, z);
                        regionData.setBlockState(blockNbt, chunkMd, pos);
                        regionData.setY(blockNbt, y);
                        strata.push(chunkMd, blockMD, x, y, z, lightLevel);
                        if (blockMD.hasTransparency() && this.mapTransparency) continue;
                        break;
                    }
                    if (y >= minY) continue;
                    break;
                }
                if (strata.isEmpty() && y < minY) break;
            }
            regionData.setBiome(blockNbt, chunkMd.getBiome(chunkMd.getBlockPos(z, y, z)));
        }
        finally {
            if (strata.isEmpty() && lavaBlockMD != null && chunkMd.getWorld().m_46472_().m_135782_().equals((Object)DimensionType.f_63842_)) {
                strata.push(chunkMd, lavaBlockMD, x, topY, z, 14);
            }
        }
    }

    protected boolean paintStrata(Strata strata, BufferedImage chunkSliceImage, RegionData regionData, CompoundTag blockNbt, ChunkMD chunkMd, Integer vSlice, int x, int y, int z) {
        if (strata.isEmpty()) {
            this.paintBadBlock(chunkSliceImage, x, y, z);
            return false;
        }
        try {
            float slope;
            Stratum stratum = null;
            BlockMD blockMD = null;
            while (!strata.isEmpty()) {
                stratum = strata.nextUp(this, true);
                if (strata.getRenderCaveColor() == null) {
                    strata.setRenderCaveColor(stratum.getCaveColor());
                } else {
                    strata.setRenderCaveColor(RGB.blendWith(strata.getRenderCaveColor(), stratum.getCaveColor(), stratum.getBlockMD().getAlpha()));
                }
                blockMD = stratum.getBlockMD();
                strata.release(stratum);
            }
            if (strata.getRenderCaveColor() == null) {
                this.paintBadBlock(chunkSliceImage, x, y, z);
                return false;
            }
            if (!blockMD.hasNoShadow() && (slope = this.getSlope(chunkMd, x, vSlice, z)) != 1.0f) {
                strata.setRenderCaveColor(RGB.bevelSlope(strata.getRenderCaveColor(), slope));
            }
            int color = this.paintBlock(chunkSliceImage, x, z, strata.getRenderCaveColor());
            regionData.setBlockColor(blockNbt, color, MapType.Name.underground);
        }
        catch (RuntimeException e) {
            this.paintBadBlock(chunkSliceImage, x, y, z);
            throw e;
        }
        return true;
    }

    @Override
    protected Integer getBlockHeight(ChunkMD chunkMd, int x, Integer vSlice, int z, Integer sliceMinY, Integer sliceMaxY) {
        Integer[][] blockSliceHeights = this.getHeights(chunkMd, vSlice);
        if (blockSliceHeights == null) {
            return null;
        }
        Integer y = blockSliceHeights[x][z];
        if (y != null) {
            return y;
        }
        try {
            BlockMD blockMDAbove;
            y = Math.min(chunkMd.getHeight(new BlockPos(x, chunkMd.getMinY().intValue(), z)), sliceMaxY) - 1;
            if (y <= sliceMinY) {
                return y;
            }
            if (y + 1 < sliceMaxY) {
                while (y > chunkMd.getMinY() && y > sliceMinY && ((blockMDAbove = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y + 1, z)).isIgnore() || blockMDAbove.hasFlag(BlockFlag.OpenToSky))) {
                    Integer n = y;
                    y = y - 1;
                }
            }
            blockMDAbove = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y + 1, z);
            BlockMD blockMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y, z);
            boolean inAirPocket = false;
            while (y > 0 && y > sliceMinY) {
                Integer n;
                if (this.mapBathymetry && blockMD.isWater()) {
                    n = y;
                    y = y - 1;
                }
                inAirPocket = blockMD.isIgnore();
                if (!blockMDAbove.isIgnore() && !blockMDAbove.hasTransparency() && !blockMDAbove.hasFlag(BlockFlag.OpenToSky) || blockMD.isIgnore() && blockMD.hasTransparency() && blockMD.hasFlag(BlockFlag.OpenToSky)) {
                    n = y;
                    y = y - 1;
                    blockMD = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y, z);
                    blockMDAbove = BlockMD.getBlockMDFromChunkLocal(chunkMd, x, y + 1, z);
                    if (y >= sliceMinY || inAirPocket) continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't get safe slice block height at " + x + "," + z + ": " + e);
            y = sliceMaxY;
        }
        blockSliceHeights[x][z] = y = Integer.valueOf(Math.max(chunkMd.getMinY(), y));
        return y;
    }

    protected int getSliceLightLevel(ChunkMD chunkMd, int x, int y, int z, boolean adjusted) {
        return this.mapCaveLighting ? chunkMd.getSavedLightValue(x, y + 1, z) : 15;
    }
}

