/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import java.util.Collections;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.ui.UIManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class MiniMapOverlayHandler
implements EventHandlerManager.EventHandler {
    private static final String DEBUG_PREFIX = ChatFormatting.AQUA + "[JM] " + ChatFormatting.RESET;
    private static final String DEBUG_SUFFIX = "";
    private static RenderGameOverlayEvent.ElementType EVENT_TYPE = RenderGameOverlayEvent.ElementType.ALL;
    private static boolean EVENT_PRE = true;
    private final Minecraft mc = Minecraft.m_91087_();
    private JourneymapClient jm;
    private long statTimerCheck;
    private List<String> statTimerReport = Collections.EMPTY_LIST;

    public static void checkEventConfig() {
        EVENT_TYPE = (RenderGameOverlayEvent.ElementType)JourneymapClient.getInstance().getCoreProperties().renderOverlayEventTypeName.get();
        EVENT_PRE = JourneymapClient.getInstance().getCoreProperties().renderOverlayPreEvent.get();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlayDebug(RenderGameOverlayEvent.Text event) {
        try {
            if (this.mc.f_91066_.f_92063_ && !"off".equalsIgnoreCase(JourneymapClient.getInstance().getCoreProperties().logLevel.get())) {
                event.getLeft().add(null);
                if (JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                    for (String line : MapPlayerTask.getDebugStats()) {
                        event.getLeft().add(DEBUG_PREFIX + line);
                    }
                } else {
                    event.getLeft().add(Constants.getString("jm.common.enable_mapping_false_text"));
                }
                if (this.mc.f_91066_.f_92064_) {
                    if (System.currentTimeMillis() - this.statTimerCheck > 3000L) {
                        this.statTimerReport = StatTimer.getReportByTotalTime(DEBUG_PREFIX, DEBUG_SUFFIX);
                        this.statTimerCheck = System.currentTimeMillis();
                    }
                    event.getLeft().add(null);
                    for (String line : this.statTimerReport) {
                        event.getLeft().add(line);
                    }
                }
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Unexpected error during onRenderOverlayEarly: " + t, t);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        try {
            if (ModList.get().isLoaded("labymod") && event.isCancelable() == EVENT_PRE) {
                UIManager.INSTANCE.drawMiniMap(event.getMatrixStack());
                return;
            }
            if (event.getType() == EVENT_TYPE && event.isCancelable() == EVENT_PRE) {
                UIManager.INSTANCE.drawMiniMap(event.getMatrixStack());
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Unexpected error during onRenderOverlayEarly: " + t, t);
        }
    }
}

