/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColoredSprite;
import journeymap.client.cartography.color.RGB;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.properties.CoreProperties;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.Logger;

public class VanillaBlockColorProxy
implements IBlockColorProxy {
    static Logger logger = Journeymap.getLogger();
    private final BlockColors blockColors = Minecraft.m_91087_().m_91298_();
    private final CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();

    @Override
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        BlockState blockState = blockMD.getBlockState();
        try {
            if (blockState.m_60734_() instanceof LiquidBlock) {
                return VanillaBlockColorProxy.getSpriteColor(blockMD, 0xBCBCBC, chunkMD, blockPos);
            }
            Integer color = VanillaBlockColorProxy.getSpriteColor(blockMD, null, chunkMD, blockPos);
            if (color == null) {
                color = VanillaBlockColorProxy.setBlockColorToMaterial(blockMD);
            }
            return color;
        }
        catch (Throwable e) {
            logger.error("Error deriving color for " + blockMD + ": " + LogFormatter.toPartialString(e));
            blockMD.addFlags(BlockFlag.Error);
            return VanillaBlockColorProxy.setBlockColorToMaterial(blockMD);
        }
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        boolean showBiomeWaterColor = this.coreProperties.mapWaterBiomeColors.get();
        boolean mapBiome = this.coreProperties.mapBiome.get();
        int result = blockMD.getTextureColor(chunkMD, blockPos);
        if (blockMD.isFoliage()) {
            result = RGB.adjustBrightness(result, 0.8f);
        } else if (!(!blockMD.isFluid() || blockMD.isWater() && showBiomeWaterColor)) {
            return RGB.multiply(result, ((LiquidBlock)blockMD.getBlock()).getFluid().getAttributes().getColor());
        }
        return RGB.multiply(result, this.getColorMultiplier(chunkMD, blockMD, blockPos, blockMD.getBlock().m_7514_(blockMD.getBlockState()).ordinal()));
    }

    public int getColorMultiplier(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos, int tintIndex) {
        boolean blendFoliage = this.coreProperties.mapBlendFoliage.get();
        boolean blendGrass = this.coreProperties.mapBlendGrass.get();
        boolean blendWater = this.coreProperties.mapBlendWater.get();
        if (!blendGrass && blockMD.isGrass()) {
            return chunkMD.getBiome(blockPos).m_47464_((double)blockPos.m_123341_(), (double)blockPos.m_123343_());
        }
        if (!blendFoliage && blockMD.isFoliage()) {
            return chunkMD.getBiome(blockPos).m_47542_();
        }
        if (!blendWater && blockMD.isWater()) {
            return chunkMD.getBiome(blockPos).m_47560_();
        }
        return this.blockColors.m_92577_(blockMD.getBlockState(), (BlockAndTintGetter)JmBlockAccess.INSTANCE, blockPos, tintIndex);
    }

    public static Integer getSpriteColor(@Nonnull BlockMD blockMD, @Nullable Integer defaultColor, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        Collection<ColoredSprite> sprites = blockMD.getBlockSpritesProxy().getSprites(blockMD, chunkMD, blockPos);
        float[] rgba = ColorManager.INSTANCE.getAverageColor(sprites);
        if (rgba != null) {
            return RGB.toInteger(rgba);
        }
        return defaultColor;
    }

    public static int setBlockColorToError(BlockMD blockMD) {
        blockMD.setAlpha(0.0f);
        blockMD.addFlags(BlockFlag.Ignore, BlockFlag.Error);
        blockMD.setColor(-1);
        return -1;
    }

    public static int setBlockColorToMaterial(BlockMD blockMD) {
        try {
            blockMD.setAlpha(1.0f);
            blockMD.addFlags(BlockFlag.Ignore);
            return blockMD.setColor(blockMD.getBlockState().m_60767_().m_76339_().f_76396_);
        }
        catch (Exception e) {
            logger.warn(String.format("Failed to use MaterialMapColor, marking as error: %s", blockMD));
            return VanillaBlockColorProxy.setBlockColorToError(blockMD);
        }
    }
}

