/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service.webmap.kotlin.routes;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.Pair;
import info.journeymap.shaded.kotlin.kotlin.TuplesKt;
import info.journeymap.shaded.kotlin.kotlin.collections.CollectionsKt;
import info.journeymap.shaded.kotlin.kotlin.collections.MapsKt;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.kotlin.spark.kotlin.RouteHandler;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.data.AllData;
import journeymap.client.data.DataCache;
import journeymap.client.data.ImagesData;
import journeymap.client.model.EntityDTO;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import org.apache.logging.log4j.Logger;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0016\u0010\r\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e*\u0004\u0018\u00010\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"GSON", "Lcom/google/gson/Gson;", "dataTypesRequiringSince", "", "", "getDataTypesRequiringSince", "()Ljava/util/List;", "logger", "Lorg/apache/logging/log4j/Logger;", "dataGet", "", "handler", "Linfo/journeymap/shaded/kotlin/spark/kotlin/RouteHandler;", "modulesAreTerrible", "", "journeymap"})
public final class DataKt {
    @NotNull
    private static final Gson GSON;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final List<String> dataTypesRequiringSince;

    @NotNull
    public static final List<String> getDataTypesRequiringSince() {
        return dataTypesRequiringSince;
    }

    private static final Map<?, ?> modulesAreTerrible(Object $this$modulesAreTerrible) {
        Object object;
        Pair[] entry;
        Pair[] pairArray = (Pair[])$this$modulesAreTerrible;
        pairArray = entry = pairArray == null ? null : MapsKt.toMutableMap(pairArray);
        boolean bl = false;
        boolean bl2 = false;
        if (pairArray == null || pairArray.isEmpty()) {
            pairArray = new Pair[]{TuplesKt.to("//", null)};
            object = MapsKt.mutableMapOf(pairArray);
        } else {
            object = entry;
        }
        return object;
    }

    @NotNull
    public static final Object dataGet(@NotNull RouteHandler handler) {
        ImagesData data;
        Intrinsics.checkNotNullParameter(handler, "handler");
        Long since = handler.queryMap("images.since").longValue();
        String type = handler.params("type");
        if (dataTypesRequiringSince.contains(type) && since == null) {
            logger.warn("Data type '" + type + "' requested without 'images.since' parameter");
            handler.status(400);
            return "Data type '" + type + "' requires 'images.since' parameter.";
        }
        switch (type) {
            case "all": {
                Map<AllData.Key, Map<?, ?>> map;
                Long l = since;
                Intrinsics.checkNotNull(l);
                Map map2 = DataCache.INSTANCE.getAll(l);
                boolean bl = false;
                boolean bl2 = false;
                Map it = map2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                Map<AllData.Key, Map<?, ?>> map3 = map = MapsKt.toMutableMap(it);
                AllData.Key key = AllData.Key.animals;
                Map<?, ?> map4 = DataKt.modulesAreTerrible(map.get((Object)AllData.Key.animals));
                boolean bl4 = false;
                map3.put(key, map4);
                map3 = map;
                key = AllData.Key.mobs;
                map4 = DataKt.modulesAreTerrible(map.get((Object)AllData.Key.mobs));
                bl4 = false;
                map3.put(key, map4);
                map3 = map;
                key = AllData.Key.players;
                map4 = DataKt.modulesAreTerrible(map.get((Object)AllData.Key.players));
                bl4 = false;
                map3.put(key, map4);
                map3 = map;
                key = AllData.Key.villagers;
                map4 = DataKt.modulesAreTerrible(map.get((Object)AllData.Key.villagers));
                bl4 = false;
                map3.put(key, map4);
                map3 = map;
                key = AllData.Key.waypoints;
                map4 = DataKt.modulesAreTerrible(map.get((Object)AllData.Key.waypoints));
                bl4 = false;
                map3.put(key, map4);
                Object object = map;
                break;
            }
            case "animals": {
                Object object = DataKt.modulesAreTerrible(DataCache.INSTANCE.getAnimals(false));
                break;
            }
            case "mobs": {
                Object object = DataKt.modulesAreTerrible(DataCache.INSTANCE.getMobs(false));
                break;
            }
            case "images": {
                Long l = since;
                Intrinsics.checkNotNull(l);
                Object object = new ImagesData(l);
                break;
            }
            case "messages": {
                Object object = DataCache.INSTANCE.getMessages(false);
                break;
            }
            case "player": {
                Object object = DataCache.INSTANCE.getPlayer(false);
                break;
            }
            case "players": {
                Object object = DataKt.modulesAreTerrible(DataCache.INSTANCE.getPlayers(false));
                break;
            }
            case "world": {
                Object object = DataCache.INSTANCE.getWorld(false);
                break;
            }
            case "villagers": {
                Object object = DataKt.modulesAreTerrible(DataCache.INSTANCE.getVillagers(false));
                break;
            }
            case "waypoints": {
                Collection<Waypoint> collection = DataCache.INSTANCE.getWaypoints(false);
                Intrinsics.checkNotNullExpressionValue(collection, "INSTANCE.getWaypoints(false)");
                Collection<Waypoint> waypoints = collection;
                boolean bl = false;
                Map wpMap = new LinkedHashMap();
                for (Waypoint waypoint : waypoints) {
                    Map map = wpMap;
                    String string = waypoint.getId();
                    Intrinsics.checkNotNullExpressionValue(string, "waypoint.id");
                    boolean bl5 = false;
                    map.put(string, waypoint);
                }
                Object object = DataKt.modulesAreTerrible(MapsKt.toMap(wpMap));
                break;
            }
            default: {
                Object object = data = null;
            }
        }
        if (data == null) {
            logger.warn("Unknown data type '" + type + '\'');
            handler.status(400);
            return "Unknown data type '" + type + '\'';
        }
        handler.getResponse().raw().setContentType("application/json");
        String string = GSON.toJson((Object)data);
        Intrinsics.checkNotNullExpressionValue(string, "GSON.toJson(data)");
        return string;
    }

    static {
        ExclusionStrategy[] exclusionStrategyArray = new ExclusionStrategy[]{new EntityDTO.EntityDTOExclusionStrategy()};
        String[] stringArray = new GsonBuilder().setPrettyPrinting().setExclusionStrategies(exclusionStrategyArray).create();
        Intrinsics.checkNotNullExpressionValue(stringArray, "GsonBuilder().setPrettyPrinting().setExclusionStrategies(EntityDTO.EntityDTOExclusionStrategy()).create()");
        GSON = stringArray;
        stringArray = Journeymap.getLogger("webmap/routes/data");
        Intrinsics.checkNotNullExpressionValue(stringArray, "getLogger(\"webmap/routes/data\")");
        logger = stringArray;
        stringArray = new String[]{"all", "images"};
        dataTypesRequiringSince = CollectionsKt.listOf(stringArray);
    }
}

