/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.ChunkRenderController;
import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.RegionCoord;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.layer.BlockInfoLayer;
import journeymap.client.ui.fullscreen.layer.KeybindingInfoLayer;
import journeymap.client.ui.fullscreen.layer.Layer;
import journeymap.client.ui.fullscreen.layer.ModOverlayLayer;
import journeymap.client.ui.fullscreen.layer.WaypointLayer;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;

public class LayerDelegate {
    long lastClick = 0L;
    BlockPos lastBlockPos = null;
    private final List<DrawStep> drawSteps = new ArrayList<DrawStep>();
    private final List<Layer> layers = new ArrayList<Layer>();

    public LayerDelegate(Fullscreen fullscreen) {
        this.layers.add(new WaypointLayer(fullscreen));
        this.layers.add(new ModOverlayLayer(fullscreen));
        this.layers.add(new BlockInfoLayer(fullscreen));
        this.layers.add(new KeybindingInfoLayer(fullscreen));
    }

    public void onMouseMove(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, float fontScale, boolean isScrolling) {
        if (this.lastBlockPos == null || !isScrolling) {
            this.lastBlockPos = this.getBlockPos(mc, gridRenderer, mousePosition);
        }
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            try {
                this.drawSteps.addAll(layer.onMouseMove(mc, gridRenderer, mousePosition, this.lastBlockPos, fontScale, isScrolling));
            }
            catch (Exception e) {
                Journeymap.getLogger().error(LogFormatter.toString(e));
            }
        }
    }

    public void onMouseClicked(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, int button, float fontScale) {
        this.lastBlockPos = gridRenderer.fullscreen.getBlockAtMouse();
        long sysTime = Util.m_137550_();
        boolean doubleClick = sysTime - this.lastClick < 200L;
        this.lastClick = sysTime;
        this.drawSteps.clear();
        for (Layer layer : this.layers) {
            try {
                this.drawSteps.addAll(layer.onMouseClick(mc, gridRenderer, mousePosition, this.lastBlockPos, button, doubleClick, fontScale));
                if (layer.propagateClick()) continue;
                break;
            }
            catch (Exception e) {
                Journeymap.getLogger().error(LogFormatter.toString(e));
            }
        }
    }

    public BlockPos getBlockPos(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition) {
        ChunkRenderController crc;
        BlockPos seaLevel = gridRenderer.getBlockAtPixel(mousePosition);
        ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(seaLevel);
        int y = seaLevel.m_123342_();
        RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(seaLevel, gridRenderer.getMapType());
        if (regionData != null) {
            y = regionData.getTopY(seaLevel);
        }
        if (chunkMD != null && (crc = JourneymapClient.getInstance().getChunkRenderController()) != null) {
            ChunkPos chunkCoord = chunkMD.getCoord();
            RegionCoord rCoord = RegionCoord.fromChunkPos(FileHandler.getJMWorldDir(mc), gridRenderer.getMapType(), chunkCoord.f_45578_, chunkCoord.f_45579_);
            BaseRenderer chunkRenderer = crc.getRenderer(rCoord, gridRenderer.getMapType(), chunkMD);
            int blockY = chunkRenderer.getBlockHeight(chunkMD, seaLevel);
            return new BlockPos(seaLevel.m_123341_(), y, seaLevel.m_123343_());
        }
        return new BlockPos(seaLevel.m_123341_(), y + 1, seaLevel.m_123343_());
    }

    public List<DrawStep> getDrawSteps() {
        return this.drawSteps;
    }
}

