/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.UUID;
import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.common.network.data.model.PlayerLocation;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ServerPlayerLocationPacket
implements PlayerLocation {
    private int entityId;
    private UUID uniqueId;
    private double x;
    private double y;
    private double z;
    private byte yaw;
    private byte pitch;
    private boolean visible;

    public ServerPlayerLocationPacket() {
    }

    public ServerPlayerLocationPacket(Player player, boolean visible) {
        this.uniqueId = player.m_36316_().getId();
        this.visible = visible;
        if (visible) {
            this.entityId = player.m_142049_();
            this.x = player.m_20185_();
            this.y = player.m_20186_();
            this.z = player.m_20189_();
            this.yaw = (byte)(player.m_146908_() * 256.0f / 360.0f);
            this.pitch = (byte)(player.m_146909_() * 256.0f / 360.0f);
        }
    }

    public ServerPlayerLocationPacket(FriendlyByteBuf buf) {
        this.visible = buf.readBoolean();
        this.uniqueId = buf.m_130259_();
        if (this.visible) {
            this.entityId = buf.m_130242_();
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.yaw = buf.readByte();
            this.pitch = buf.readByte();
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.visible);
        buf.m_130077_(this.uniqueId);
        if (this.visible) {
            buf.m_130130_(this.entityId);
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeByte((int)this.yaw);
            buf.writeByte((int)this.pitch);
        }
    }

    public static void handle(ServerPlayerLocationPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                JourneymapClient.getInstance().getPacketHandler().onPlayerLocationPacket(packet);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public byte getYaw() {
        return this.yaw;
    }

    @Override
    public byte getPitch() {
        return this.pitch;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

