/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.input;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.anti_ad.a.a.a.o;
import org.anti_ad.a.a.a.s;
import org.anti_ad.mc.common.IInputHandler;
import org.anti_ad.mc.common.gui.debug.DebugInfos;
import org.anti_ad.mc.common.input.IKeybind;
import org.anti_ad.mc.common.input.KeybindSettings;
import org.anti_ad.mc.common.vanilla.glue.IVanillaUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public final class GlobalInputHandler {
    @NotNull
    public static final GlobalInputHandler INSTANCE = new GlobalInputHandler();
    @NotNull
    private static final Set pressedKeys = new LinkedHashSet();
    @NotNull
    private static Set previousPressedKeys = o.j(pressedKeys);
    private static int lastKey = -1;
    private static int lastAction = -1;
    @Nullable
    private static IKeybind currentAssigningKeybind;
    private static boolean pressedFirstKey;
    private static boolean ignoreLeftClick;
    @NotNull
    private static final Set registered;
    @NotNull
    private static final Set registeredCancellable;

    private GlobalInputHandler() {
    }

    @NotNull
    public final Set getPressedKeys() {
        return pressedKeys;
    }

    @NotNull
    public final Set getPreviousPressedKeys() {
        return previousPressedKeys;
    }

    public final int getLastKey() {
        return lastKey;
    }

    public final int getLastAction() {
        return lastAction;
    }

    public final boolean isWaitingForRelease(int n2) {
        return pressedKeys.contains(n2);
    }

    public final boolean isActivated(@NotNull List list2, @NotNull KeybindSettings keybindSettings) {
        if (list2.isEmpty()) {
            return false;
        }
        if (!keybindSettings.getActivateOn().isValid(lastAction)) {
            return false;
        }
        if (!IVanillaUtilKt.getVanillaUtil().isValidScreen(keybindSettings.getContext())) {
            return false;
        }
        Set set = lastAction == 1 ? pressedKeys : previousPressedKeys;
        return KeybindSettings.validates$default(keybindSettings, set, list2, false, 4, null);
    }

    public final boolean isPressing(@NotNull List list2, @NotNull KeybindSettings keybindSettings) {
        if (list2.isEmpty()) {
            return false;
        }
        if (!IVanillaUtilKt.getVanillaUtil().isValidScreen(keybindSettings.getContext())) {
            return false;
        }
        return keybindSettings.validates(pressedKeys, list2, false);
    }

    private final boolean onKey(int n2, int n3) {
        boolean bl = n3 == 1;
        if (bl && pressedKeys.contains(n2)) {
            return false;
        }
        previousPressedKeys = o.j(pressedKeys);
        if (bl) {
            pressedKeys.add(n2);
        } else {
            pressedKeys.remove(n2);
        }
        lastKey = n2;
        lastAction = n3;
        return this.onInput();
    }

    private final boolean onInput() {
        boolean bl;
        if (currentAssigningKeybind != null) {
            this.handleAssignKeybind();
            return true;
        }
        Object object = registeredCancellable;
        if (!(object instanceof Collection) || !((Collection)object).isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                if (!((IInputHandler)object.next()).onInput(INSTANCE.getLastKey(), INSTANCE.getLastAction())) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        if (bl) {
            return true;
        }
        object = ((Iterable)registered).iterator();
        while (object.hasNext()) {
            ((IInputHandler)object.next()).onInput(INSTANCE.getLastKey(), INSTANCE.getLastAction());
        }
        return false;
    }

    @Nullable
    public final IKeybind getCurrentAssigningKeybind() {
        return currentAssigningKeybind;
    }

    public final void setCurrentAssigningKeybind(@Nullable IKeybind iKeybind) {
        pressedFirstKey = false;
        ignoreLeftClick = true;
        currentAssigningKeybind = iKeybind;
    }

    private final void handleAssignKeybind() {
        IKeybind iKeybind = currentAssigningKeybind;
        Object object = iKeybind == null ? null : iKeybind.getSettings().getModifierKey().handleKeys(o.h(INSTANCE.getPressedKeys()));
        IKeybind iKeybind2 = iKeybind = object == null ? o.h(pressedKeys) : object;
        if (lastAction == 1) {
            if (lastKey == -100 && ignoreLeftClick) {
                return;
            }
            pressedFirstKey = true;
            if (lastKey == 256) {
                object = currentAssigningKeybind;
                if (object != null) {
                    object.setKeyCodes(s.a);
                }
                this.setCurrentAssigningKeybind(null);
                return;
            }
            object = currentAssigningKeybind;
            if (object != null) {
                object.setKeyCodes((List)((Object)iKeybind));
                return;
            }
        } else {
            if (lastKey == -100) {
                ignoreLeftClick = false;
            }
            if (iKeybind.isEmpty() && pressedFirstKey) {
                this.setCurrentAssigningKeybind(null);
            }
        }
    }

    public final boolean isKeyDown(int n2, long l2) {
        int n3 = n2;
        if (n2 >= 0) {
            return GLFW.glfwGetKey((long)l2, (int)n2) == 1;
        }
        return (n3 += 100) >= 0 && GLFW.glfwGetMouseButton((long)l2, (int)n3) == 1;
    }

    public final boolean onKey(int n2, int n3, int n4, int n5, boolean bl, long l2) {
        DebugInfos.INSTANCE.onKey(n2, n3, n4, n5);
        if (l2 != 0L && bl && !((Collection)pressedKeys).isEmpty()) {
            Object object = o.j(pressedKeys);
            pressedKeys.clear();
            object = ((Iterable)object).iterator();
            while (object.hasNext()) {
                n5 = ((Number)object.next()).intValue();
                if (!INSTANCE.isKeyDown(n5, l2)) continue;
                INSTANCE.getPressedKeys().add(n5);
            }
        }
        switch (n4) {
            case 1: {
                return this.onKey(n2, n4);
            }
            case 0: {
                return this.onKey(n2, n4);
            }
        }
        return false;
    }

    public final boolean onMouseButton(int n2, int n3, int n4) {
        DebugInfos.INSTANCE.onMouseButton(n2, n3, n4);
        switch (n3) {
            case 0: 
            case 1: {
                return this.onKey(n2 - 100, n3);
            }
        }
        return false;
    }

    public final boolean register(@NotNull IInputHandler iInputHandler) {
        return registered.add(iInputHandler);
    }

    public final boolean unregister(@NotNull IInputHandler iInputHandler) {
        return registered.remove(iInputHandler);
    }

    public final boolean registerCancellable(@NotNull IInputHandler iInputHandler) {
        return registeredCancellable.add(iInputHandler);
    }

    public final boolean unregisterCancellable(@NotNull IInputHandler iInputHandler) {
        return registeredCancellable.remove(iInputHandler);
    }

    static {
        registered = new LinkedHashSet();
        registeredCancellable = new LinkedHashSet();
    }
}

