/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.math2d;

import org.anti_ad.mc.common.math2d.Line;
import org.anti_ad.mc.common.math2d.LineKt;
import org.anti_ad.mc.common.math2d.Point;
import org.anti_ad.mc.common.math2d.Rectangle;
import org.anti_ad.mc.common.math2d.Size;
import org.jetbrains.annotations.NotNull;

public final class Rect2dKt {
    @NotNull
    public static final Size toSize(@NotNull Point point) {
        return new Size(point.getX(), point.getY());
    }

    @NotNull
    public static final Point transpose(@NotNull Point point) {
        return new Point(point.getY(), point.getX());
    }

    @NotNull
    public static final Point toPoint(@NotNull Size size) {
        return new Point(size.getWidth(), size.getHeight());
    }

    @NotNull
    public static final Size transpose(@NotNull Size size) {
        return new Size(size.getHeight(), size.getWidth());
    }

    @NotNull
    public static final Rectangle intersect(@NotNull Rectangle object, @NotNull Rectangle object2) {
        object = LineKt.getDiagonal(Rect2dKt.normalize((Rectangle)object));
        int n2 = ((Line)object).component1();
        int n3 = ((Line)object).component2();
        int n4 = ((Line)object).component3();
        int n5 = ((Line)object).component4();
        object2 = LineKt.getDiagonal(Rect2dKt.normalize((Rectangle)object2));
        int n6 = ((Line)object2).component1();
        int n7 = ((Line)object2).component2();
        int n8 = ((Line)object2).component3();
        int n9 = ((Line)object2).component4();
        n2 = Math.max(n2, n6);
        n3 = Math.max(n3, n7);
        n4 = Math.min(n4, n8);
        n5 = Math.min(n5, n9);
        return Rect2dKt.positiveOrEmpty(LineKt.toRectangle(new Line(n2, n3, n4, n5)));
    }

    @NotNull
    public static final Rectangle positiveOrEmpty(@NotNull Rectangle rectangle) {
        if (rectangle.getWidth() > 0 && rectangle.getHeight() > 0) {
            return rectangle;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private static final Rectangle normalizeWidth(Rectangle rectangle) {
        if (rectangle.getWidth() >= 0) {
            return rectangle;
        }
        return new Rectangle(rectangle.getX() + rectangle.getWidth(), rectangle.getY(), -rectangle.getWidth(), rectangle.getHeight());
    }

    private static final Rectangle normalizeHeight(Rectangle rectangle) {
        if (rectangle.getHeight() >= 0) {
            return rectangle;
        }
        return new Rectangle(rectangle.getX(), rectangle.getY() + rectangle.getHeight(), rectangle.getWidth(), -rectangle.getHeight());
    }

    @NotNull
    public static final Rectangle normalize(@NotNull Rectangle rectangle) {
        return Rect2dKt.normalizeHeight(Rect2dKt.normalizeWidth(rectangle));
    }
}

