/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item.rule.file;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.anti_ad.a.a.a.d;
import org.anti_ad.a.a.a.o;
import org.anti_ad.a.a.f.a.a;
import org.anti_ad.a.a.f.a.b;
import org.anti_ad.mc.common.Log;
import org.anti_ad.mc.ipnext.item.rule.EmptyRule;
import org.anti_ad.mc.ipnext.item.rule.Parameter;
import org.anti_ad.mc.ipnext.item.rule.Rule;
import org.anti_ad.mc.ipnext.item.rule.file.CustomRule;
import org.anti_ad.mc.ipnext.item.rule.file.RuleDefinition;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFile;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFileRegister$RuleFinder;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFileRegister$searchAndPutCustomRule$1;
import org.anti_ad.mc.ipnext.item.rule.natives.NativeRules;
import org.anti_ad.mc.ipnext.item.rule.parameter.NativeParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RuleFileRegister {
    @NotNull
    public static final RuleFileRegister INSTANCE = new RuleFileRegister();
    @NotNull
    private static final Set loadedFileNames = new LinkedHashSet();
    @NotNull
    private static final List ruleFiles = new ArrayList();
    @NotNull
    private static final Map cachedRules = new LinkedHashMap();
    @NotNull
    private static final Set names = new LinkedHashSet();

    private RuleFileRegister() {
    }

    @NotNull
    public final Set getLoadedFileNames() {
        return loadedFileNames;
    }

    public final void reloadRuleFiles(@NotNull List list2) {
        Log.INSTANCE.trace("[-] Rule file parsing...");
        Log.INSTANCE.trace("    step: (1) parse indent -> (2) parse rule -> syntax ok");
        Log.INSTANCE.indent();
        Iterator iterator = ((Iterable)list2).iterator();
        while (iterator.hasNext()) {
            ((RuleFile)iterator.next()).parseContent();
        }
        Log.INSTANCE.unindent();
        this.clear();
        ruleFiles.addAll(list2);
        this.checkOverrides();
        this.validateRules();
    }

    private final void clear() {
        loadedFileNames.clear();
        ruleFiles.clear();
        cachedRules.clear();
        names.clear();
    }

    private final void checkOverrides() {
        Log.INSTANCE.trace("[-] Check overrides...");
        for (RuleFile ruleFile : ruleFiles) {
            for (String string : ruleFile.getRulesMap().keySet()) {
                if (names.contains(string)) {
                    Log.INSTANCE.info("Rule @" + string + " overrode by file " + ruleFile.getFileName());
                }
                names.add(string);
            }
        }
    }

    private final void validateRules() {
        Log.INSTANCE.trace("[-] Validate rules...");
        Log.INSTANCE.indent();
        for (String string : names) {
            Log.INSTANCE.trace("[-] Validating rule @" + string);
            Log.INSTANCE.indent();
            if (this.getCustomRule(string) == null) {
                Log.INSTANCE.debug("rule @" + string + " failed to parse");
            }
            Log.INSTANCE.unindent();
        }
        Log.INSTANCE.unindent();
    }

    @NotNull
    public final Rule getCustomRuleOrEmpty(@NotNull String string) {
        Rule rule2 = this.getCustomRule(string);
        if (rule2 == null) {
            rule2 = EmptyRule.INSTANCE;
            Log.INSTANCE.warn("Rule @" + string + " not found");
            return rule2;
        }
        return rule2;
    }

    @Nullable
    public final CustomRule getCustomRule(@NotNull String object) {
        if ((object = cachedRules.containsKey(object) ? (RuleDefinition)d.a(cachedRules, object) : this.searchAndPutCustomRule((String)object)) == null) {
            return null;
        }
        return ((RuleDefinition)object).createCustomRule();
    }

    @Nullable
    public final Rule getNativeRule(@NotNull String object) {
        object = (a)NativeRules.INSTANCE.getMap().get(object);
        if (object == null) {
            return null;
        }
        return (Rule)object.invoke();
    }

    @Nullable
    public final Parameter getParameter(@NotNull String string) {
        return (Parameter)NativeParameters.INSTANCE.getMap().get(string);
    }

    private final RuleDefinition searchAndPutCustomRule(String string) {
        Log.INSTANCE.trace("[-] Searching rule @" + string + "...");
        Log.INSTANCE.indent();
        RuleDefinition ruleDefinition = new RuleFileRegister$RuleFinder(string).searchCustomRule();
        Log.INSTANCE.unindent();
        if (cachedRules.containsKey(string)) {
            Log.INSTANCE.trace(">> rule " + string + " already exist in cached map... skip putting");
        } else {
            cachedRules.put(string, ruleDefinition);
        }
        o.a(ruleFiles, (b)RuleFileRegister$searchAndPutCustomRule$1.INSTANCE);
        return ruleDefinition;
    }

    public static final /* synthetic */ List access$getRuleFiles$p() {
        return ruleFiles;
    }
}

