/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.client.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.leviathanstudio.craftstudio.CraftStudioApi;
import com.leviathanstudio.craftstudio.client.exception.CSMalformedJsonException;
import com.leviathanstudio.craftstudio.client.exception.CSResourceNotFoundException;
import com.leviathanstudio.craftstudio.client.json.CSReadedAnim;
import com.leviathanstudio.craftstudio.client.json.CSReadedAnimBlock;
import com.leviathanstudio.craftstudio.client.json.CSReadedModel;
import com.leviathanstudio.craftstudio.client.json.CSReadedModelBlock;
import com.leviathanstudio.craftstudio.client.util.EnumFrameType;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.Charsets;

@SideOnly(value=Side.CLIENT)
public class CSJsonReader {
    private JsonObject root;
    private String ress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSJsonReader(ResourceLocation resourceIn) throws CSResourceNotFoundException {
        JsonParser jsonParser = new JsonParser();
        BufferedReader reader = null;
        IResource iResource = null;
        StringBuilder strBuilder = new StringBuilder();
        this.ress = resourceIn.toString();
        try {
            String s;
            iResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceIn);
            reader = new BufferedReader(new InputStreamReader(iResource.func_110527_b(), Charsets.UTF_8));
            while ((s = reader.readLine()) != null) {
                strBuilder.append(s);
            }
            JsonElement object = jsonParser.parse(strBuilder.toString());
            this.root = (JsonObject)object;
        }
        catch (FileNotFoundException fnfe) {
            throw new CSResourceNotFoundException(this.ress);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (iResource != null) {
                    iResource.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public CSReadedModel readModel() throws CSMalformedJsonException {
        CSReadedModel model = new CSReadedModel();
        JsonElement jsEl = this.root.get("title");
        if (jsEl == null) {
            throw new CSMalformedJsonException("title", "String", this.ress);
        }
        model.setName(CSJsonReader.strNormalize(jsEl.getAsString()));
        JsonArray tree = this.root.getAsJsonArray("tree");
        if (tree == null) {
            throw new CSMalformedJsonException("tree", "Array", this.ress);
        }
        for (JsonElement element : tree) {
            if (!element.isJsonObject()) continue;
            JsonObject jsonBlock = element.getAsJsonObject();
            CSReadedModelBlock parent = new CSReadedModelBlock();
            model.getParents().add(parent);
            try {
                CSJsonReader.readModelBlock(jsonBlock, parent);
            }
            catch (ClassCastException | IllegalStateException | NullPointerException e) {
                throw new CSMalformedJsonException(parent.getName() != null ? parent.getName() : "a parent block without name", this.ress);
            }
        }
        return model;
    }

    private static void readModelBlock(JsonObject jsonBlock, CSReadedModelBlock block) {
        CSJsonReader.readModelBlock(jsonBlock, block, null);
    }

    private static void readModelBlock(JsonObject jsonBlock, CSReadedModelBlock block, Vector3f parentOffset) {
        int[] vertexOrderConvert = new int[]{3, 2, 1, 0, 6, 7, 4, 5};
        block.setName(CSJsonReader.strNormalize(jsonBlock.get("name").getAsString()));
        JsonArray array = jsonBlock.getAsJsonArray("size");
        float sizeX = array.get(0).getAsFloat();
        float sizeY = array.get(1).getAsFloat();
        float sizeZ = array.get(2).getAsFloat();
        array = jsonBlock.getAsJsonArray("position");
        float posX = array.get(0).getAsFloat();
        float posY = array.get(1).getAsFloat();
        float posZ = array.get(2).getAsFloat();
        array = jsonBlock.getAsJsonArray("rotation");
        float rotationX = array.get(0).getAsFloat();
        float rotationY = array.get(1).getAsFloat();
        float rotationZ = array.get(2).getAsFloat();
        array = jsonBlock.getAsJsonArray("offsetFromPivot");
        float pivotOffsetX = array.get(0).getAsFloat();
        float pivotOffsetY = array.get(1).getAsFloat();
        float pivotOffsetZ = array.get(2).getAsFloat();
        array = jsonBlock.getAsJsonArray("vertexCoords");
        if (array != null) {
            block.setVertex(new float[8][3]);
            for (int i = 0; i < 8; ++i) {
                JsonArray vertexArray = array.get(vertexOrderConvert[i]).getAsJsonArray();
                block.getVertex()[i][0] = vertexArray.get(0).getAsFloat();
                block.getVertex()[i][1] = -vertexArray.get(1).getAsFloat();
                block.getVertex()[i][2] = -vertexArray.get(2).getAsFloat();
            }
            float stretchx = sizeX != 0.0f ? Math.abs(block.getVertex()[1][0] - block.getVertex()[0][0]) / sizeX : 1.0f;
            float stretchy = sizeY != 0.0f ? Math.abs(block.getVertex()[3][1] - block.getVertex()[0][1]) / sizeY : 1.0f;
            float stretchz = sizeZ != 0.0f ? Math.abs(block.getVertex()[4][2] - block.getVertex()[0][2]) / sizeZ : 1.0f;
            for (int i = 0; i < 8; ++i) {
                float[] vertex = block.getVertex()[i];
                vertex[0] = vertex[0] / stretchx;
                vertex[1] = vertex[1] / stretchy;
                vertex[2] = vertex[2] / stretchz;
            }
            block.setStretch(new Vector3f(stretchx, stretchy, stretchz));
        } else {
            block.setStretch(new Vector3f(1.0f, 1.0f, 1.0f));
        }
        if (parentOffset == null) {
            block.setRotationPoint(new Vector3f(posX, -posY + 24.0f, -posZ));
        } else {
            block.setRotationPoint(new Vector3f(posX, -posY, -posZ));
        }
        block.setRotation(new Vector3f(rotationX, -rotationY, -rotationZ));
        block.setOffset(new Vector3f(pivotOffsetX, -pivotOffsetY, -pivotOffsetZ));
        block.setSize(new Vector3f(sizeX, -sizeY, -sizeZ));
        array = jsonBlock.getAsJsonArray("texOffset");
        block.getTexOffset()[0] = array.get(0).getAsInt();
        block.getTexOffset()[1] = array.get(1).getAsInt();
        array = jsonBlock.getAsJsonArray("children");
        for (JsonElement element : array) {
            JsonObject jsonChild = element.getAsJsonObject();
            CSReadedModelBlock child = new CSReadedModelBlock();
            block.getChilds().add(child);
            CSJsonReader.readModelBlock(jsonChild, child, new Vector3f(pivotOffsetX, -pivotOffsetY, -pivotOffsetZ));
        }
    }

    public CSReadedAnim readAnim() throws CSMalformedJsonException {
        CSReadedAnim anim = new CSReadedAnim();
        JsonElement jsEl = this.root.get("title");
        if (jsEl == null) {
            throw new CSMalformedJsonException("title", "String", this.ress);
        }
        anim.setName(CSJsonReader.strNormalize(jsEl.getAsString()));
        jsEl = this.root.get("duration");
        if (jsEl == null) {
            throw new CSMalformedJsonException("duration", "Integer", this.ress);
        }
        anim.setDuration(jsEl.getAsInt());
        jsEl = this.root.get("holdLastKeyframe");
        if (jsEl == null) {
            throw new CSMalformedJsonException("holdLastKeyframe", "Boolean", this.ress);
        }
        anim.setHoldLastK(jsEl.getAsBoolean());
        jsEl = this.root.get("nodeAnimations");
        if (jsEl == null) {
            throw new CSMalformedJsonException("nodeAnimations", "Object", this.ress);
        }
        JsonObject nodeAnims = jsEl.getAsJsonObject();
        for (Map.Entry entry : nodeAnims.entrySet()) {
            CSReadedAnimBlock block = new CSReadedAnimBlock();
            anim.getBlocks().add(block);
            try {
                CSJsonReader.readAnimBlock(entry, block);
            }
            catch (Exception e) {
                CraftStudioApi.getLogger().error(e.getMessage());
                throw new CSMalformedJsonException(block.getName() != null ? block.getName() : "a block without name", this.ress);
            }
        }
        return anim;
    }

    private static void readAnimBlock(Map.Entry<String, JsonElement> entry, CSReadedAnimBlock block) {
        block.setName(CSJsonReader.strNormalize(entry.getKey()));
        JsonObject objBlock = entry.getValue().getAsJsonObject();
        JsonObject objField = objBlock.get("position").getAsJsonObject();
        CSJsonReader.addKFElement(objField, block, EnumFrameType.POSITION);
        objField = objBlock.get("offsetFromPivot").getAsJsonObject();
        CSJsonReader.addKFElement(objField, block, EnumFrameType.OFFSET);
        objField = objBlock.get("size").getAsJsonObject();
        CSJsonReader.addKFElement(objField, block, EnumFrameType.SIZE);
        objField = objBlock.get("rotation").getAsJsonObject();
        CSJsonReader.addKFElement(objField, block, EnumFrameType.ROTATION);
        objField = objBlock.get("stretch").getAsJsonObject();
        CSJsonReader.addKFElement(objField, block, EnumFrameType.STRETCH);
    }

    private static void addKFElement(JsonObject obj, CSReadedAnimBlock block, EnumFrameType type) {
        for (Map.Entry entry : obj.entrySet()) {
            Vector3f value;
            int keyFrame = Integer.parseInt((String)entry.getKey());
            JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
            switch (type) {
                case STRETCH: 
                case SIZE: {
                    value = new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
                    break;
                }
                default: {
                    value = new Vector3f(array.get(0).getAsFloat(), -array.get(1).getAsFloat(), -array.get(2).getAsFloat());
                }
            }
            block.addKFElement(keyFrame, type, value);
        }
    }

    private static String strNormalize(String str) {
        return str.replaceAll("[^\\dA-Za-z ]", "_").replaceAll("\\s+", "_").replaceAll("[^\\p{ASCII}]", "_");
    }
}

