/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.init;

import com.mrcrayfish.guns.item.ISubItems;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistrationHandler {

    @Mod.EventBusSubscriber(modid="cgm")
    public static class Potions {
        private static final List<Potion> POTIONS = new LinkedList<Potion>();

        static void add(Potion potion) {
            POTIONS.add(potion);
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Potion> event) {
            POTIONS.forEach(potion -> event.getRegistry().register((IForgeRegistryEntry)potion));
        }
    }

    @Mod.EventBusSubscriber(modid="cgm")
    public static class Recipes {
        private static final List<IRecipe> RECIPES = new LinkedList<IRecipe>();

        public static void add(IRecipe recipe) {
            RECIPES.add(recipe);
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<IRecipe> event) {
            RECIPES.forEach(recipe -> event.getRegistry().register((IForgeRegistryEntry)recipe));
        }
    }

    @Mod.EventBusSubscriber(modid="cgm")
    public static class Sounds {
        private static final List<SoundEvent> SOUNDS = new LinkedList<SoundEvent>();

        static void add(SoundEvent sound) {
            SOUNDS.add(sound);
        }

        @SubscribeEvent
        public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
            SOUNDS.forEach(sound -> event.getRegistry().register((IForgeRegistryEntry)sound));
        }
    }

    @Mod.EventBusSubscriber(modid="cgm", value={Side.CLIENT})
    public static class Models {
        @SubscribeEvent
        public static void register(ModelRegistryEvent event) {
            Items.ITEMS.forEach(Models::registerRender);
        }

        private static void registerRender(Item item) {
            if (item instanceof ISubItems) {
                NonNullList<ResourceLocation> modelLocations = ((ISubItems)item).getModels();
                for (int i = 0; i < modelLocations.size(); ++i) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation((ResourceLocation)modelLocations.get(i), "inventory"));
                }
            } else {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="cgm")
    public static class Items {
        private static final List<Item> ITEMS = new LinkedList<Item>();

        static void add(Item item) {
            ITEMS.add(item);
        }

        public static List<Item> getItems() {
            return ITEMS;
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Item> event) {
            ITEMS.forEach(item -> event.getRegistry().register((IForgeRegistryEntry)item));
        }
    }

    @Mod.EventBusSubscriber(modid="cgm")
    public static class Blocks {
        private static final List<Block> BLOCKS = new LinkedList<Block>();

        static void add(Block block) {
            BLOCKS.add(block);
        }

        @SubscribeEvent
        public static void register(RegistryEvent.Register<Block> event) {
            BLOCKS.forEach(block -> event.getRegistry().register((IForgeRegistryEntry)block));
        }
    }
}

