/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.remote;

import java.io.File;
import net.montoyo.mcef.client.ClientProxy;
import net.montoyo.mcef.utilities.IProgressListener;
import net.montoyo.mcef.utilities.Log;
import net.montoyo.mcef.utilities.Util;

public class Resource {
    private String platform;
    private String name;
    private String sum;
    private boolean shouldExtract = false;

    public Resource(String name, String sum, String platform) {
        this.name = name;
        this.sum = sum.trim();
        this.platform = platform;
    }

    public boolean exists() {
        File f = new File(ClientProxy.ROOT, this.name);
        if (!f.exists()) {
            return false;
        }
        String hash = Util.hash(f);
        if (hash == null) {
            Log.warning("Couldn't hash file %s; assuming it doesn't exist.", f.getAbsolutePath());
            return false;
        }
        return hash.equalsIgnoreCase(this.sum);
    }

    public boolean download(IProgressListener ipl) {
        File dst;
        File parent;
        String end = "";
        if (this.shouldExtract) {
            end = end + ".gz";
        }
        if (!(parent = (dst = new File(ClientProxy.ROOT, this.name)).getParentFile()).exists() && !parent.mkdirs()) {
            Log.warning("Couldn't create directory %s... ignoring this error, but this might cause some issues later...", parent.getAbsolutePath());
        }
        return Util.download("1.11/" + this.platform + '/' + this.name + end, dst, this.shouldExtract, ipl);
    }

    public boolean extract(IProgressListener ipl) {
        Util.secure(ipl).onTaskChanged("Extracting " + this.name);
        return Util.extract(new File(ClientProxy.ROOT, this.name), new File(ClientProxy.ROOT));
    }

    public void setShouldExtract() {
        this.shouldExtract = true;
        this.name = this.name.substring(0, this.name.length() - 3);
    }

    public String getFileName() {
        return this.name;
    }

    public static File getLocationOf(String resName) {
        return new File(ClientProxy.ROOT, resName);
    }
}

