/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.setup;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.montoyo.mcef.setup.McLocationPrompt;
import net.montoyo.mcef.setup.SetupUtil;

public class SetupUI
implements ActionListener,
WindowListener,
MouseListener {
    public static SetupUI INSTANCE = null;
    private File selfDestruct = null;
    private JFrame frame = new JFrame("MCEF Setup");
    private GridLayout layout;
    private JPanel mainPane;
    private JButton btnInstall;
    private JButton btnConfigure;
    private JButton btnUninstall;
    private JButton btnExit;
    private JLabel aboutLabel;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        INSTANCE = new SetupUI();
    }

    public SetupUI() {
        this.frame.setMinimumSize(new Dimension(300, 100));
        this.frame.setLocationRelativeTo(null);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(this);
        this.btnInstall = new JButton("Install");
        this.btnConfigure = new JButton("Configure");
        this.btnUninstall = new JButton("Uninstall");
        this.btnExit = new JButton("Exit");
        this.btnInstall.addActionListener(this);
        this.btnConfigure.addActionListener(this);
        this.btnUninstall.addActionListener(this);
        this.btnExit.addActionListener(this);
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new BoxLayout(labelPane, 3));
        labelPane.add(new JLabel("Welcome to the MCEF Setup Wizard."));
        labelPane.add(new JLabel("What do you like to do?"));
        this.mainPane = new JPanel();
        this.layout = new GridLayout(6, 1, 3, 3);
        this.mainPane.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.mainPane.setLayout(this.layout);
        this.mainPane.add(labelPane);
        this.mainPane.add(this.btnInstall);
        this.mainPane.add(this.btnConfigure);
        this.mainPane.add(this.btnUninstall);
        this.mainPane.add(this.btnExit);
        this.aboutLabel = new JLabel("<html><i>MCEF was written by <u><font color=\"#000099\">montoyo</font></u></i>&nbsp;&nbsp;</html>");
        this.aboutLabel.setHorizontalAlignment(4);
        this.aboutLabel.addMouseListener(this);
        this.mainPane.add(this.aboutLabel);
        this.frame.setContentPane(this.mainPane);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnExit) {
            this.windowClosing(null);
        } else if (e.getSource() == this.btnInstall) {
            new McLocationPrompt(this.frame, "install");
        } else if (e.getSource() == this.btnConfigure) {
            new McLocationPrompt(this.frame, "configure");
        } else if (e.getSource() == this.btnUninstall) {
            new McLocationPrompt(this.frame, "uninstall");
        }
    }

    void initiateSelfDestruct(File f) {
        this.selfDestruct = f;
    }

    void abortSelfDestruct() {
        this.selfDestruct = null;
    }

    private void runSelfDestructionUnsafe() throws Throwable {
        int read;
        File tmp = File.createTempFile("mcef-deleter", ".jar");
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tmp));
        InputStream is = SetupUI.class.getResourceAsStream("/net/montoyo/mcef/setup/Deleter.class");
        byte[] buf = new byte[8192];
        zos.putNextEntry(new ZipEntry("net/montoyo/mcef/setup/Deleter.class"));
        while ((read = is.read(buf)) > 0) {
            zos.write(buf, 0, read);
        }
        try {
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SetupUtil.silentClose(zos);
        SetupUtil.silentClose(is);
        String java = "\"" + System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            java = java + "w.exe";
        }
        java = java + "\" -classpath \"";
        java = java + tmp.getAbsolutePath();
        java = java + "\" net.montoyo.mcef.setup.Deleter \"";
        java = java + this.selfDestruct.getAbsolutePath();
        java = java + "\"";
        System.out.println("Running auto-deleter:");
        System.out.println(java);
        Runtime.getRuntime().exec(java);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.frame.dispose();
        if (this.selfDestruct != null) {
            try {
                this.runSelfDestructionUnsafe();
            }
            catch (Throwable t) {
                System.err.println("Failed to destruct myself:");
                t.printStackTrace();
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            Desktop.getDesktop().browse(new URI("https://montoyo.net"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

