/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.utilities.Log;
import org.lwjgl.opengl.GL11;

public class CefRenderer {
    private static final ArrayList<Integer> GL_TEXTURES = new ArrayList();
    private boolean transparent_;
    public int[] texture_id_ = new int[1];
    private int view_width_ = 0;
    private int view_height_ = 0;
    private Rectangle popup_rect_ = new Rectangle(0, 0, 0, 0);
    private Rectangle original_popup_rect_ = new Rectangle(0, 0, 0, 0);

    public static void dumpVRAMLeak() {
        Log.info(">>>>> MCEF: Beginning VRAM leak report", new Object[0]);
        GL_TEXTURES.forEach(tex -> Log.warning(">>>>> MCEF: This texture has not been freed: " + tex, new Object[0]));
        Log.info(">>>>> MCEF: End of VRAM leak report", new Object[0]);
    }

    protected CefRenderer(boolean transparent) {
        this.transparent_ = transparent;
        this.initialize();
    }

    protected boolean isTransparent() {
        return this.transparent_;
    }

    protected void initialize() {
        GlStateManager.func_179098_w();
        this.texture_id_[0] = GL11.glGenTextures();
        if (MCEF.CHECK_VRAM_LEAK) {
            GL_TEXTURES.add(this.texture_id_[0]);
        }
        GlStateManager.func_179144_i((int)this.texture_id_[0]);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexEnvf((int)8960, (int)8704, (float)8448.0f);
        GlStateManager.func_179144_i((int)0);
    }

    protected void cleanup() {
        if (this.texture_id_[0] != 0) {
            if (MCEF.CHECK_VRAM_LEAK) {
                GL_TEXTURES.remove((Object)this.texture_id_[0]);
            }
            GL11.glDeleteTextures((int)this.texture_id_[0]);
        }
    }

    public void render(double x1, double y1, double x2, double y2) {
        if (this.view_width_ == 0 || this.view_height_ == 0) {
            return;
        }
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        GlStateManager.func_179144_i((int)this.texture_id_[0]);
        vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vb.func_181662_b(x1, y1, 0.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        vb.func_181662_b(x2, y1, 0.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        vb.func_181662_b(x2, y2, 0.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        vb.func_181662_b(x1, y2, 0.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, 255).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179144_i((int)0);
    }

    protected void onPopupSize(Rectangle rect) {
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        this.original_popup_rect_ = rect;
        this.popup_rect_ = this.getPopupRectInWebView(this.original_popup_rect_);
    }

    protected Rectangle getPopupRectInWebView(Rectangle rc) {
        if (rc.x < 0) {
            rc.x = 0;
        }
        if (rc.y < 0) {
            rc.y = 0;
        }
        if (rc.x + rc.width > this.view_width_) {
            rc.x = this.view_width_ - rc.width;
        }
        if (rc.y + rc.height > this.view_height_) {
            rc.y = this.view_height_ - rc.height;
        }
        if (rc.x < 0) {
            rc.x = 0;
        }
        if (rc.y < 0) {
            rc.y = 0;
        }
        return rc;
    }

    protected void clearPopupRects() {
        this.popup_rect_.setBounds(0, 0, 0, 0);
        this.original_popup_rect_.setBounds(0, 0, 0, 0);
    }

    protected void onPaint(boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height, boolean completeReRender) {
        int size;
        if (this.transparent_) {
            GlStateManager.func_179147_l();
        }
        if ((size = width * height << 2) > buffer.limit()) {
            Log.warning("Bad data passed to CefRenderer.onPaint() triggered safe guards... (1)", new Object[0]);
            return;
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179144_i((int)this.texture_id_[0]);
        int oldAlignement = GL11.glGetInteger((int)3317);
        GL11.glPixelStorei((int)3317, (int)1);
        if (!popup) {
            if (completeReRender || width != this.view_width_ || height != this.view_height_) {
                this.view_width_ = width;
                this.view_height_ = height;
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.view_width_, (int)this.view_height_, (int)0, (int)32993, (int)5121, (ByteBuffer)buffer);
            } else {
                GL11.glPixelStorei((int)3314, (int)this.view_width_);
                for (Rectangle rect : dirtyRects) {
                    if (rect.x < 0 || rect.y < 0 || rect.x + rect.width > this.view_width_ || rect.y + rect.height > this.view_height_) {
                        Log.warning("Bad data passed to CefRenderer.onPaint() triggered safe guards... (2)", new Object[0]);
                        continue;
                    }
                    GL11.glPixelStorei((int)3316, (int)rect.x);
                    GL11.glPixelStorei((int)3315, (int)rect.y);
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height, (int)32993, (int)5121, (ByteBuffer)buffer);
                }
                GL11.glPixelStorei((int)3316, (int)0);
                GL11.glPixelStorei((int)3315, (int)0);
                GL11.glPixelStorei((int)3314, (int)0);
            }
        } else if (this.popup_rect_.width > 0 && this.popup_rect_.height > 0) {
            int skip_pixels = 0;
            int x = this.popup_rect_.x;
            int skip_rows = 0;
            int y = this.popup_rect_.y;
            int w = width;
            int h = height;
            if (x < 0) {
                skip_pixels = -x;
                x = 0;
            }
            if (y < 0) {
                skip_rows = -y;
                y = 0;
            }
            if (x + w > this.view_width_) {
                w -= x + w - this.view_width_;
            }
            if (y + h > this.view_height_) {
                h -= y + h - this.view_height_;
            }
            GL11.glPixelStorei((int)3314, (int)width);
            GL11.glPixelStorei((int)3316, (int)skip_pixels);
            GL11.glPixelStorei((int)3315, (int)skip_rows);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)x, (int)y, (int)w, (int)h, (int)32993, (int)5121, (ByteBuffer)buffer);
            GL11.glPixelStorei((int)3314, (int)0);
            GL11.glPixelStorei((int)3316, (int)0);
            GL11.glPixelStorei((int)3315, (int)0);
        }
        GL11.glPixelStorei((int)3317, (int)oldAlignement);
        GlStateManager.func_179144_i((int)0);
    }

    public int getViewWidth() {
        return this.view_width_;
    }

    public int getViewHeight() {
        return this.view_height_;
    }
}

