/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.libgdx.Vector3;
import com.mia.craftstudio.minecraft.ModelMetadata;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import team.thegoldenhoe.cameraobscura.TabProps;
import team.thegoldenhoe.cameraobscura.common.craftstudio.TileTypeMap;
import team.thegoldenhoe.cameraobscura.common.network.CameraTypes;
import team.thegoldenhoe.cameraobscura.utils.JsonHelper;

public class CSModelMetadata
extends ModelMetadata {
    public boolean showOutline = true;
    public String name;
    public int decocraftModelID;
    public int lightLevel = 0;
    public int invX = 0;
    public int invY = 0;
    public boolean walkthrough = false;
    public boolean colorable = false;
    public boolean limitRotation = false;
    public boolean hasVariableRendering = false;
    public boolean spiderweb = false;
    public boolean placeable = true;
    public TabProps tab = TabProps.Main;
    public TileTypeMap tileType = TileTypeMap.Props;
    public String sound;
    public String recipe;
    public int placedModel = -1;
    public boolean creativeInv = true;
    public int rotInventory = 8;
    public int rotHeld = 8;
    public Map<Integer, JsonObject> variants = null;
    public transient float itemScale = -1.0f;
    public transient Vector3 itemOffset;
    private transient Map<Integer, AxisAlignedBB> aabbs = new HashMap<Integer, AxisAlignedBB>();
    private static final HashMap<String, Field> fieldMap = new HashMap();

    public CSModelMetadata() {
        if (fieldMap.isEmpty()) {
            for (Field f : CSModelMetadata.class.getFields()) {
                fieldMap.put(f.getName(), f);
            }
        }
    }

    public CSModelMetadata(CSModelMetadata existingMeta, int newID, JsonObject changes) {
        if (fieldMap.isEmpty()) {
            for (Field f : CSModelMetadata.class.getFields()) {
                fieldMap.put(f.getName(), f);
            }
        }
        this.craftstudioAssetName = existingMeta.craftstudioAssetName;
        this.craftstudioAssetID = existingMeta.craftstudioAssetID;
        this.scale = existingMeta.scale;
        this.textureOverride = null;
        this.tileParams = new HashMap(existingMeta.tileParams);
        this.csmodel = existingMeta.csmodel;
        this.name = existingMeta.name;
        this.decocraftModelID = newID;
        this.lightLevel = existingMeta.lightLevel;
        this.invX = existingMeta.invX;
        this.invY = existingMeta.invY;
        this.walkthrough = existingMeta.walkthrough;
        this.colorable = existingMeta.colorable;
        this.limitRotation = existingMeta.limitRotation;
        this.hasVariableRendering = existingMeta.hasVariableRendering;
        this.spiderweb = existingMeta.spiderweb;
        this.tab = existingMeta.tab;
        this.tileType = existingMeta.tileType;
        this.sound = existingMeta.sound;
        this.recipe = null;
        this.variants = null;
        this.itemScale = existingMeta.itemScale;
        this.itemOffset = existingMeta.itemOffset != null ? new Vector3(existingMeta.itemOffset) : null;
        this.showOutline = existingMeta.showOutline;
        this.rotInventory = existingMeta.rotInventory;
        this.rotHeld = existingMeta.rotHeld;
        if (changes != null) {
            Gson gson = new GsonBuilder().create();
            for (Map.Entry entry : changes.entrySet()) {
                Field foundField = fieldMap.get(((String)entry.getKey()).intern());
                if (foundField == null) continue;
                try {
                    foundField.set((Object)this, gson.fromJson((JsonElement)entry.getValue(), foundField.getGenericType()));
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
    }

    public void wrapperCallback() {
        super.wrapperCallback();
        int[] extendBlock = this.wrapper.getExtendBlock(0);
        int width = 1 + extendBlock[3] - extendBlock[0];
        int depth = 1 + extendBlock[5] - extendBlock[2];
        int height = extendBlock[4] - extendBlock[1];
        if (height == 0) {
            ++height;
        }
        Vector3[] extend = this.wrapper.getExtend(8);
        this.itemScale = Math.min(1.0f / Math.abs(extend[1].y - extend[0].y), Math.min(1.0f / Math.abs(extend[1].x - extend[0].x), 1.0f / Math.abs(extend[1].z - extend[0].z)));
        this.itemOffset = new Vector3(-((extend[0].x + extend[1].x) / 2.0f), -((extend[0].y + extend[1].y) / 35.0f + (extend[0].y < 0.0f ? extend[0].y / 2.0f : 0.0f) + (extend[0].y > 0.0f ? extend[0].y : 0.0f) + (extend[1].y > 0.5f ? extend[1].y / 35.0f : 0.0f) + 0.84f), -((extend[0].z + extend[1].z) / 2.2f));
    }

    public void validate() {
        if (this.textureOverride == null) {
            this.textureOverride = this.getDefaultTextureName();
        }
        if (this.csmodel.getRootNode() != null && this.csmodel.getRootNode().hasAttribute(CSModel.ModelNode.Attrb.PASSABLEPROPAGATES)) {
            this.walkthrough = true;
        }
    }

    public String getDefaultTextureName() {
        return String.format("%04d_%s.png", this.decocraftModelID, this.name.toLowerCase().replaceAll("[/\\\\:*?\"<>|' ]", "_"));
    }

    public CameraTypes getCameraType() {
        String cameraType = (String)this.tileParams.get("cameraType");
        if (cameraType == null) {
            return CameraTypes.NOT_A_CAMERA;
        }
        return CameraTypes.valueOf(cameraType);
    }

    public boolean isBlockInList(IBlockState state, String key) {
        String blockListString = this.tileParams.getOrDefault(key, "any");
        if ("any".equals(blockListString)) {
            return true;
        }
        if ("none".equals(blockListString) || blockListString.isEmpty()) {
            return false;
        }
        return JsonHelper.blocksFromString(blockListString).contains(state);
    }

    public int compareTo(ModelMetadata o) {
        if (o instanceof CSModelMetadata) {
            if (this.decocraftModelID < ((CSModelMetadata)o).decocraftModelID) {
                return -1;
            }
            if (this.decocraftModelID > ((CSModelMetadata)o).decocraftModelID) {
                return 1;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    public AxisAlignedBB getBoundingBox(int rotation) {
        AxisAlignedBB aabb = this.aabbs.get(rotation);
        if (aabb == null) {
            Vector3[] extend = this.wrapper.getExtend(rotation);
            aabb = new AxisAlignedBB((double)extend[0].x, (double)extend[0].y, (double)extend[0].z, (double)extend[1].x, (double)extend[1].y, (double)extend[1].z);
            this.aabbs.put(rotation, aabb);
            return aabb;
        }
        return aabb;
    }
}

