/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.client.commands;

import com.google.common.collect.BiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.CSPack;
import com.mia.craftstudio.minecraft.CraftStudioRendererVBO;
import com.mia.craftstudio.minecraft.ModelMetadata;
import com.mia.craftstudio.minecraft.client.CSClientModelWrapperVBO;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import team.thegoldenhoe.cameraobscura.CSModelMetadata;
import team.thegoldenhoe.cameraobscura.TabProps;
import team.thegoldenhoe.cameraobscura.utils.ModelHandler;

public class CommandMakeResources
extends CommandBase {
    File decoOutputDir = new File("DecocraftGeneratedResources");

    public String func_71517_b() {
        return "decomakeres";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/decomakeres [texpack|json|list]";
    }

    private Color averageColorFromArray(int[] pixels) {
        int addCount = 0;
        int totalR = 0;
        int totalG = 0;
        int totalB = 0;
        for (int pixel : pixels) {
            if ((pixel >> 24 & 0xFF) == 0) continue;
            ++addCount;
            Color c = new Color(pixel);
            totalR += c.getRed();
            totalG += c.getGreen();
            totalB += c.getBlue();
        }
        if (addCount > 0) {
            totalR /= addCount;
            totalG /= addCount;
            totalB /= addCount;
        }
        return new Color(totalR, totalG, totalB);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Please choose a resource to export: texturepack, json, list, lang, or all."));
            return;
        }
        String command = args[0].toLowerCase();
        if ("texturepack".equals(command)) {
            this.makeTexturePack(sender);
        } else if ("dumpcolors".equals(command)) {
            Field[] blockFieldList = Blocks.class.getDeclaredFields();
            ArrayList<Block> mcBlockList = new ArrayList<Block>();
            for (Field bf : blockFieldList) {
                try {
                    mcBlockList.add((Block)bf.get(null));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            HashSet<String> existingColors = new HashSet<String>();
            HashSet<String> existingNames = new HashSet<String>();
            HashSet<String> conflictingNames = new HashSet<String>();
            ArrayList<ItemStack> validBlocks = new ArrayList<ItemStack>();
            String output = "Calculated Vanilla MC colors:\r";
            for (Block b : mcBlockList) {
                try {
                    Item bItem = Item.func_150898_a((Block)b);
                    NonNullList subList = NonNullList.func_191196_a();
                    if (bItem != null) {
                        if (bItem.func_77614_k()) {
                            try {
                                b.func_149666_a(b.func_149708_J(), subList);
                            }
                            catch (Throwable throwable) {}
                        } else {
                            try {
                                int end;
                                int n = end = bItem.func_77645_m() ? bItem.func_77612_l() : 0;
                                for (int i = 0; i <= end; ++i) {
                                    subList.add((Object)new ItemStack(b, 1, i));
                                }
                            }
                            catch (Throwable i) {
                                // empty catch block
                            }
                        }
                    }
                    for (ItemStack bStack : subList) {
                        try {
                            TextureAtlasSprite ic = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(b.func_176203_a(bStack.func_77952_i()));
                            if (existingColors.contains(ic.func_94215_i().intern())) continue;
                            existingColors.add(ic.func_94215_i().intern());
                            if (existingNames.contains(bStack.func_82833_r())) {
                                conflictingNames.add(bStack.func_82833_r());
                            } else {
                                existingNames.add(bStack.func_82833_r());
                            }
                            validBlocks.add(bStack);
                        }
                        catch (Throwable ic) {}
                    }
                }
                catch (Throwable bItem) {
                }
            }
            for (ItemStack bStack : validBlocks) {
                try {
                    String name = bStack.func_82833_r();
                    TextureAtlasSprite ic = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(Block.func_149634_a((Item)bStack.func_77973_b()).func_176203_a(bStack.func_77952_i()));
                    if (conflictingNames.contains(name)) {
                        name = "_" + ic.func_94215_i().replaceAll("_top|_bottom|_side|_base|_stage_[0-9]|_layer_[0-9]|_colored|_inside", "");
                    }
                    name = name.replaceAll("\\W", "");
                    StringBuilder nameBuilder = new StringBuilder();
                    for (char c : name.toCharArray()) {
                        if (Character.isUpperCase(c)) {
                            nameBuilder.append('_');
                            nameBuilder.append(Character.toLowerCase(c));
                            continue;
                        }
                        nameBuilder.append(c);
                    }
                    name = nameBuilder.toString().replaceAll("blockof", "block").replaceAll("t_n_t", "tnt").replaceAll("chiseled_quartz_block", "quartz");
                    ResourceLocation resourcelocation = new ResourceLocation(ic.func_94215_i());
                    ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), String.format("%s/%s%s", "textures", resourcelocation.func_110623_a(), ".png"));
                    Color color = this.averageColorFromArray(TextureUtil.func_110986_a((IResourceManager)Minecraft.func_71410_x().func_110442_L(), (ResourceLocation)resourcelocation1));
                }
                catch (Throwable throwable) {}
            }
            System.out.println(validBlocks.size() + " " + output);
        } else if ("json".equals(command)) {
            boolean forceAdd = false;
            boolean updateScale = false;
            boolean updateTabs = false;
            boolean updateNames = false;
            if (args.length >= 2) {
                for (int i = 1; i < args.length; ++i) {
                    if ("forceadd".equals(args[i].toLowerCase())) {
                        forceAdd = true;
                        continue;
                    }
                    if ("updatescale".equals(args[i].toLowerCase())) {
                        updateScale = true;
                        continue;
                    }
                    if ("updatetabs".equals(args[i].toLowerCase())) {
                        updateTabs = true;
                        continue;
                    }
                    if (!"updatenames".equals(args[i].toLowerCase())) continue;
                    updateNames = true;
                }
            }
            this.makeJSON(sender, forceAdd, updateScale, updateTabs, updateNames);
        } else if ("list".equals(command)) {
            this.makeMasterList(sender);
        } else if ("lang".equals(command)) {
            this.makeLanguage(sender);
        } else if ("all".equals(command)) {
            this.makeJSON(sender, true, false, false, false);
            this.makeMasterList(sender);
            this.makeTexturePack(sender);
            this.makeLanguage(sender);
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Unknown subcommand: " + args[0]));
        }
    }

    public int func_82362_a() {
        return 0;
    }

    private void makeTexturePack(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("Exporting default texturepack for skin creation."));
        try {
            this.decoOutputDir.mkdirs();
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(new File(this.decoOutputDir, "Decocraft_Template_TexturePack.zip")));
            zipOut.putNextEntry(new ZipEntry("pack.meta"));
            zipOut.write("{\n  \"pack\": {\n    \"pack_format\": 1,\n    \"description\": \"Decocraft default texture pack!\"\n  }\n}".getBytes());
            zipOut.closeEntry();
            String path = "assets/";
            zipOut.putNextEntry(new ZipEntry(path));
            zipOut.closeEntry();
            path = path + "cameraobscura".toLowerCase() + "/";
            zipOut.putNextEntry(new ZipEntry(path));
            zipOut.closeEntry();
            path = path + "textures/";
            zipOut.putNextEntry(new ZipEntry(path));
            zipOut.closeEntry();
            path = path + "models/";
            zipOut.putNextEntry(new ZipEntry(path));
            zipOut.closeEntry();
            ArrayList<CSModelMetadata> modelList = new ArrayList<CSModelMetadata>(ModelHandler.modelData.values());
            Collections.sort(modelList);
            for (CSModelMetadata metadata : modelList) {
                try {
                    zipOut.putNextEntry(new ZipEntry(path + metadata.textureOverride));
                    zipOut.write(metadata.csmodel.getRawTexture());
                    zipOut.closeEntry();
                }
                catch (ZipException zipException) {}
            }
            zipOut.close();
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isNumber(String str) {
        boolean foundDecimal = false;
        for (char c : str.toCharArray()) {
            if (c == '.') {
                if (foundDecimal) {
                    return false;
                }
                foundDecimal = true;
                continue;
            }
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private void makeJSON(ICommandSender sender, boolean forceAdd, boolean updateScale, boolean updateTabs, boolean updateName) {
        sender.func_145747_a((ITextComponent)new TextComponentString("Creating json descriptor files for packs." + (forceAdd ? " !! Adding new models to live Model Metadata !!" : "")));
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(CSModelMetadata.class, (Object)new DecoMetadataJsonSerializer());
        builder.setPrettyPrinting();
        builder.serializeNulls();
        Gson gson = builder.create();
        try {
            this.decoOutputDir.mkdirs();
            List packs = ModelHandler.csproject.getPacks();
            for (CSPack pack : packs) {
                ArrayList<ModelMetadata> packModelData = new ArrayList<ModelMetadata>();
                BiMap packentries = pack.getEntries();
                for (Map.Entry entry : packentries.entrySet()) {
                    ModelMetadata tempMeta;
                    if (((CSPack.ProjectEntry)entry.getValue()).getType() != 0) continue;
                    String craftstudioAssetName = ((CSPack.ProjectEntry)entry.getValue()).getName();
                    String[] nameParts = craftstudioAssetName.split("_", 3);
                    if (((CSPack.ProjectEntry)entry.getValue()).isFolder() || !this.isNumber(nameParts[0]) && !"item".equals(nameParts[0].toLowerCase())) continue;
                    JsonElement tempElement = ModelHandler.csproject.getDescriptor((Integer)entry.getKey());
                    int decocraftID = 0;
                    float modelScale = 1.0f;
                    String decocraftName = "";
                    TabProps decocraftCreativeTab = TabProps.Main;
                    boolean basicMeta = false;
                    if (tempElement == null || updateScale || updateTabs || updateName) {
                        block32: {
                            if (nameParts.length > 1) {
                                if ("item".equals(nameParts[0].toLowerCase())) {
                                    basicMeta = true;
                                } else {
                                    try {
                                        decocraftID = Integer.valueOf(nameParts[0]);
                                        if (nameParts.length == 3) {
                                            boolean isName = true;
                                            if (this.isNumber(nameParts[1])) {
                                                modelScale = Float.valueOf(nameParts[1]).floatValue();
                                                decocraftName = nameParts[2];
                                                isName = false;
                                            } else if (nameParts[1].startsWith("@")) {
                                                String[] numParts = nameParts[1].substring(1).split(";");
                                                int constantAnim = Integer.parseInt(numParts[0]);
                                                if (numParts.length > 1) {
                                                    modelScale = Float.valueOf(numParts[1]).floatValue();
                                                }
                                                decocraftName = nameParts[2];
                                                isName = false;
                                            }
                                            if (isName) {
                                                decocraftName = String.format("%s_%s", nameParts[1], nameParts[2]);
                                            }
                                            break block32;
                                        }
                                        decocraftName = nameParts[1];
                                    }
                                    catch (NumberFormatException nfe) {
                                        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Model[%] is not an 'Item_' or formatted with a proper DecoCraft 'IDNumber_Decocraftname' format.", craftstudioAssetName)));
                                    }
                                }
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Model[%] is not an 'Item_' or formatted with a proper DecoCraft 'IDNumber_Decocraftname' format.", craftstudioAssetName)));
                                continue;
                            }
                        }
                        try {
                            decocraftCreativeTab = TabProps.valueOf(((CSPack.ProjectEntry)packentries.get((Object)((CSPack.ProjectEntry)entry.getValue()).getParentID())).getName());
                        }
                        catch (Exception nfe) {
                            // empty catch block
                        }
                    }
                    if (!basicMeta) {
                        if (tempElement != null) {
                            tempMeta = ModelHandler.modelData.get(tempElement.getAsJsonObject().get("decocraftModelID").getAsInt());
                            tempMeta.craftstudioAssetName = craftstudioAssetName;
                            if (updateScale) {
                                tempMeta.scale = modelScale;
                            }
                            if (updateTabs) {
                                tempMeta.tab = decocraftCreativeTab;
                            }
                            if (updateName && (tempMeta.variants == null || tempMeta.variants.isEmpty())) {
                                tempMeta.name = decocraftName;
                            }
                        } else {
                            tempMeta = new CSModelMetadata();
                            tempMeta.craftstudioAssetName = craftstudioAssetName;
                            tempMeta.craftstudioAssetID = (Integer)entry.getKey();
                            tempMeta.decocraftModelID = decocraftID;
                            tempMeta.scale = modelScale;
                            tempMeta.name = decocraftName;
                            tempMeta.csmodel = ModelHandler.csproject.getModel(Integer.valueOf(((CSPack.ProjectEntry)entry.getValue()).getID()));
                            tempMeta.textureOverride = tempMeta.getDefaultTextureName();
                            tempMeta.tab = decocraftCreativeTab;
                        }
                        if (forceAdd) {
                            if (tempMeta.wrapper == null) {
                                tempMeta.wrapper = new CSClientModelWrapperVBO(tempMeta);
                            }
                            ((CSClientModelWrapperVBO)tempMeta.wrapper).deleteGlTexture();
                            TextureUtil.func_110987_a((int)((CSClientModelWrapperVBO)tempMeta.wrapper).getGlTextureId(), (BufferedImage)tempMeta.csmodel.getTexture());
                            if (((CSClientModelWrapperVBO)tempMeta.wrapper).topRenderers.size() == 0) {
                                for (CSModel.ModelNode node : tempMeta.csmodel.getTopNodes()) {
                                    ((CSClientModelWrapperVBO)tempMeta.wrapper).addRenderer(new CraftStudioRendererVBO(tempMeta.wrapper.nodeCache.get((Object)node)));
                                }
                            }
                            ModelHandler.modelData.put(tempMeta.decocraftModelID, (CSModelMetadata)tempMeta);
                        }
                        packModelData.add(tempMeta);
                        continue;
                    }
                    tempMeta = new ModelMetadata();
                    tempMeta.craftstudioAssetName = craftstudioAssetName;
                    tempMeta.craftstudioAssetID = (Integer)entry.getKey();
                    if (this.isNumber(nameParts[1])) {
                        tempMeta.scale = Float.valueOf(nameParts[1]).floatValue();
                    }
                    if ("decowand".equals(nameParts[nameParts.length - 1].toLowerCase())) continue;
                    packModelData.add(tempMeta);
                }
                Collections.sort(packModelData);
                for (ModelMetadata meta : packModelData) {
                    String id = meta.craftstudioAssetName.split("_", 3)[0];
                    if (!("item".equals(id.toLowerCase()) || this.isNumber(id) && id.length() == 4)) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Identifier[%s] for Model[%s] is not 'Item' or a four digit number.", id, meta.craftstudioAssetName)));
                    }
                    if (meta.csmodel.getRootNode() != null) continue;
                    sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Model[%s] does not have a properly named 'RootNode'.", meta.craftstudioAssetName)));
                }
                File jsonFile = new File(this.decoOutputDir, pack.getName().replace(".cspack", ".json"));
                jsonFile.setWritable(true);
                PrintWriter fout = new PrintWriter(jsonFile);
                fout.print(gson.toJson(packModelData));
                fout.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void makeMasterList(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("Exporting master model CSV file."));
        try {
            this.decoOutputDir.mkdirs();
            File masterListFile = new File(this.decoOutputDir, "Decocraft_Master_Model_list.csv");
            masterListFile.setWritable(true);
            PrintWriter fout = new PrintWriter(masterListFile);
            fout.print("DecoID,Tab,ModelName\n");
            ArrayList<CSModelMetadata> modelList = new ArrayList<CSModelMetadata>(ModelHandler.modelData.values());
            Collections.sort(modelList);
            for (CSModelMetadata metadata : modelList) {
                fout.print(String.format("%d,%s,%s\n", metadata.decocraftModelID, metadata.tab.name(), metadata.name));
            }
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void makeLanguage(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("Updating and exporting en_us.lang"));
        try {
            this.decoOutputDir.mkdirs();
            File newLangFile = new File(this.decoOutputDir, "en_us.lang");
            newLangFile.setWritable(true);
            Files.copy(CommandMakeResources.class.getResourceAsStream("/assets/cameraobscura/lang/en_us.lang"), newLangFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            PrintWriter fout = new PrintWriter(new BufferedWriter(new FileWriter(newLangFile, true)));
            ArrayList<CSModelMetadata> modelList = new ArrayList<CSModelMetadata>(ModelHandler.modelData.values());
            Collections.sort(modelList);
            for (CSModelMetadata metadata : modelList) {
                String unlocalizedName = "item.cameraobscura." + ModelHandler.modelData.get((Object)Integer.valueOf((int)metadata.decocraftModelID)).name.toLowerCase().replace(" ", "_").replace("'", "_") + ".name";
                String localizedName = "" + I18n.func_74838_a((String)unlocalizedName).trim();
                if (!localizedName.startsWith("item.cameraobscura.")) continue;
                fout.print(String.format("%s=%s\n", unlocalizedName, metadata.name));
            }
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class DecoMetadataJsonSerializer
    implements JsonSerializer<CSModelMetadata> {
        private CSModelMetadata defaultMeta = new CSModelMetadata();
        private List<Field> fieldsToTrim = new ArrayList<Field>();
        private Gson gson = new GsonBuilder().serializeNulls().create();

        public DecoMetadataJsonSerializer() {
            for (Field field : CSModelMetadata.class.getFields()) {
                if ("decocraftModelID".equals(field.getName()) || Modifier.isTransient(field.getModifiers())) continue;
                this.fieldsToTrim.add(field);
            }
        }

        public JsonElement serialize(CSModelMetadata src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject trimmedJsonObject = (JsonObject)this.gson.toJsonTree((Object)src);
            for (Field field : this.fieldsToTrim) {
                try {
                    Object value = field.get((Object)src);
                    if (value == null) {
                        trimmedJsonObject.remove(field.getName());
                    }
                    if (value == null || !value.equals(field.get((Object)this.defaultMeta))) continue;
                    trimmedJsonObject.remove(field.getName());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            trimmedJsonObject.remove("recipe");
            if (src.getDefaultTextureName().equals(src.textureOverride)) {
                trimmedJsonObject.remove("textureOverride");
            }
            return trimmedJsonObject;
        }
    }
}

