/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.thegoldenhoe.cameraobscura.CSModelMetadata;
import team.thegoldenhoe.cameraobscura.CameraObscura;
import team.thegoldenhoe.cameraobscura.TabProps;
import team.thegoldenhoe.cameraobscura.Utils;
import team.thegoldenhoe.cameraobscura.client.ClientProxy;
import team.thegoldenhoe.cameraobscura.common.capability.CameraCapabilities;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraNBT;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraStorageNBT;
import team.thegoldenhoe.cameraobscura.common.craftstudio.BlockProps;
import team.thegoldenhoe.cameraobscura.common.craftstudio.TileProps;
import team.thegoldenhoe.cameraobscura.common.item.ItemRegistry;
import team.thegoldenhoe.cameraobscura.common.network.CameraTypes;
import team.thegoldenhoe.cameraobscura.utils.ModelHandler;
import team.thegoldenhoe.cameraobscura.utils.SoundRegistry;

public class ItemProps
extends Item {
    public ItemProps() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77664_n();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        System.out.println("right click");
        if (stack.func_190916_E() == 0) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        CSModelMetadata data = ModelHandler.getModelFromStack(stack);
        if (!data.placeable) {
            this.takePicOrOpenGui(world, player, hand, data.getCameraType());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    protected void takePicOrOpenGui(World world, EntityPlayer player, EnumHand hand, CameraTypes type) {
        if (type == CameraTypes.NOT_A_CAMERA) {
            return;
        }
        if (hand == EnumHand.OFF_HAND && Utils.isCamera(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return;
        }
        if (player.func_70093_af()) {
            player.openGui((Object)CameraObscura.instance, type.getGuiID(), world, hand.ordinal(), 0, 0);
            return;
        }
        if (world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            switch (type) {
                case VINTAGE: {
                    ICameraNBT vintageCap = (ICameraNBT)stack.getCapability(CameraCapabilities.getCameraCapability(), null);
                    ItemStack vintageStack = vintageCap.getStackInSlot(0);
                    if (vintageStack.func_190926_b()) {
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"cameraobscura.chat.missing_paper", (Object[])new Object[0])), false);
                        break;
                    }
                    ICameraStorageNBT storage = vintageCap.getStorageDevice();
                    if (storage != null && storage.canSave()) {
                        this.takePicture();
                        this.playSound("vintage");
                        break;
                    }
                    player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"cameraobscura.chat.full_paper", (Object[])new Object[0])), false);
                    break;
                }
                case POLAROID: {
                    ICameraNBT polaroidCap = (ICameraNBT)stack.getCapability(CameraCapabilities.getCameraCapability(), null);
                    ItemStack polaroidStack = polaroidCap.getStackInSlot(0);
                    if (polaroidStack.func_190926_b()) {
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"cameraobscura.chat.missing_stacks", (Object[])new Object[0])), false);
                        break;
                    }
                    ICameraStorageNBT storage = polaroidCap.getStorageDevice();
                    if (storage != null && storage.canSave()) {
                        this.takePicture();
                        this.playSound("polaroid");
                        break;
                    }
                    player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"cameraobscura.chat.full_stacks", (Object[])new Object[0])), false);
                    break;
                }
                case DIGITAL: {
                    ICameraNBT cap = (ICameraNBT)stack.getCapability(CameraCapabilities.getCameraCapability(), null);
                    ItemStack sdCard = cap.getStackInSlot(0);
                    if (sdCard.func_190926_b()) {
                        player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"cameraobscura.chat.missing_sd", (Object[])new Object[0])), false);
                        break;
                    }
                    ICameraStorageNBT storage = cap.getStorageDevice();
                    if (storage.canSave()) {
                        this.takePicture();
                        this.playSound("digital");
                        break;
                    }
                    player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"cameraobscura.chat.full_sd", (Object[])new Object[0])), false);
                    break;
                }
                case NOT_A_CAMERA: {
                    System.err.println("Not sure how we got here, but a non camera was trying to save an image. Whoops!");
                    return;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playSound(String name) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_194007_a((SoundEvent)SoundRegistry.get(name), (float)1.0f, (float)5.0f));
    }

    private void takePicture() {
        ClientProxy.photographPending = true;
        ClientProxy.hideGUIDefault = Minecraft.func_71410_x().field_71474_y.field_74319_N;
        Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return CameraCapabilities.getProvider(CameraCapabilities.getCameraCapability(), () -> {
            ICameraNBT.CameraHandler ret = new ICameraNBT.CameraHandler(){

                @Override
                public void markDirty() {
                    NBTTagCompound nbtTmp = this.serializeNBT();
                    stack.func_77982_d(nbtTmp);
                }
            };
            if (stack.func_77942_o()) {
                ret.deserializeNBT((NBTBase)stack.func_77978_p());
            }
            return ret;
        });
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        System.out.println("onItemUse");
        if (stack.func_190916_E() == 0) {
            return EnumActionResult.FAIL;
        }
        CSModelMetadata data = ModelHandler.getModelFromStack(stack);
        if (data.placeable) {
            return this.place(player, world, pos, hand, side, hitX, hitY, hitZ);
        }
        return EnumActionResult.FAIL;
    }

    public EnumActionResult place(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190916_E() == 0) {
            return EnumActionResult.FAIL;
        }
        CSModelMetadata data = ModelHandler.getModelFromStack(stack);
        Block target = world.func_180495_p(pos).func_177230_c();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (target != Blocks.field_150329_H && target != Blocks.field_150431_aC) {
            x += side.func_82601_c();
            y += side.func_96559_d();
            z += side.func_82599_e();
        }
        BlockPos finalPos = new BlockPos(x, y, z);
        if (!player.func_175151_a(pos, side, stack)) {
            return EnumActionResult.FAIL;
        }
        if (data.placedModel != -1) {
            data = ModelHandler.getModelByID(data.placedModel);
        }
        if (!data.isBlockInList(world.func_180495_p(finalPos.func_177977_b()), "canPlaceOn")) {
            return EnumActionResult.FAIL;
        }
        int i1 = 0;
        if (!data.limitRotation) {
            i1 = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
        } else {
            int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            i1 = direction * 4;
        }
        if (!TileProps.canPlace(data.wrapper, world, x, y, z, player.func_70093_af(), i1)) {
            if (world.field_72995_K) {
                TextComponentString error = new TextComponentString("You can't place that here. Something is in the way.");
                error.func_150256_b().func_150217_b(Boolean.valueOf(true));
                error.func_150256_b().func_150238_a(TextFormatting.GRAY);
                player.func_145747_a((ITextComponent)error);
            }
            return EnumActionResult.FAIL;
        }
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        Class<? extends TileProps> tileClass = data.tileType.getTileClass();
        int orient = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)orient);
        if (!world.func_175656_a(finalPos, CameraObscura.blockProps.func_176223_P().func_177226_a((IProperty)BlockProps.FACING, (Comparable)enumfacing))) {
            return EnumActionResult.FAIL;
        }
        TileProps tileProps = TileProps.checkAndGetTileEntity(world, finalPos, data.decocraftModelID);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("savedProp")) {
            tileProps.func_145839_a(stack.func_77978_p().func_74775_l("savedProp"));
            tileProps.func_174878_a(finalPos);
        }
        tileProps.type = data.decocraftModelID;
        tileProps.rotation = i1;
        tileProps.tileParams = data.tileParams;
        tileProps.init();
        tileProps.blockPlaced(world.func_180495_p(finalPos), world, finalPos);
        tileProps.createSlaves();
        tileProps.func_70296_d();
        world.func_175664_x(finalPos);
        SoundType soundtype = CameraObscura.blockProps.func_185467_w();
        world.func_184133_a((EntityPlayer)null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        stack.func_190920_e(stack.func_190916_E() - 1);
        player.func_184597_cx();
        return EnumActionResult.SUCCESS;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        ArrayList<CSModelMetadata> metaList = new ArrayList<CSModelMetadata>(ModelHandler.getAllModelMetadata());
        Collections.sort(metaList);
        for (CSModelMetadata data : metaList) {
            if (!data.creativeInv || tab != data.tab.get() && tab != CreativeTabs.field_78027_g && tab != null) continue;
            subItems.add((Object)new ItemStack(ItemRegistry.itemProps, 1, data.decocraftModelID));
        }
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public String func_77658_a() {
        return "item.cameraobscura.stuffed_creeper";
    }

    public String func_77667_c(ItemStack stack) {
        return "item.cameraobscura." + ModelHandler.getModelFromStack((ItemStack)stack).name.toLowerCase().replace(" ", "_").replace("'", "_");
    }

    public CreativeTabs[] getCreativeTabs() {
        return TabProps.getAll();
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_77640_w() {
        return CreativeTabs.field_78027_g;
    }
}

