/*
 * Decompiled with CFR 0.152.
 */
package team.thegoldenhoe.cameraobscura.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.thegoldenhoe.cameraobscura.common.capability.CameraCapabilities;
import team.thegoldenhoe.cameraobscura.common.capability.ICameraStorageNBT;

public class ItemSDCard
extends Item {
    public ItemSDCard() {
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        ICameraStorageNBT.SDCardStorage storage;
        int numShotsRemaining = 32;
        if (stack.func_77978_p() == null) {
            tooltip.add("Empty");
        }
        if ((storage = (ICameraStorageNBT.SDCardStorage)stack.getCapability(CameraCapabilities.getSDCardStorageCapability(), null)) != null) {
            ArrayList<String> paths = storage.getSavedImagePaths();
            numShotsRemaining = storage.getMaxSaves() - paths.size();
            tooltip.add(TextFormatting.AQUA.toString() + TextFormatting.BOLD + "Shots Remaining: " + numShotsRemaining);
            tooltip.add(TextFormatting.WHITE.toString() + TextFormatting.ITALIC + "Usable in digital camera");
        }
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return CameraCapabilities.getProvider(CameraCapabilities.getSDCardStorageCapability(), () -> {
            ICameraStorageNBT.SDCardStorage ret = new ICameraStorageNBT.SDCardStorage(){

                @Override
                public void saveImage(String path, EntityPlayer player) {
                    super.saveImage(path, player);
                    stack.func_77982_d(this.serializeNBT());
                }
            };
            if (stack.func_77942_o()) {
                ret.deserializeNBT(stack.func_77978_p());
            }
            return ret;
        });
    }
}

