/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.ITextComponent;
import xerca.xercapaint.common.PaletteUtil;

public abstract class BasePalette
extends GuiScreen {
    protected static final ResourceLocation noteGuiTextures = new ResourceLocation("xercapaint", "textures/gui/palette.png");
    static final int dyeSpriteX = 240;
    static final int dyeSpriteSize = 16;
    static final int brushSpriteX = 0;
    static final int brushSpriteY = 247;
    static final int brushSpriteSize = 9;
    static final int dropSpriteWidth = 6;
    static final int paletteWidth = 157;
    static final int paletteHeight = 193;
    static int paletteX;
    static int paletteY;
    static final PaletteUtil.Color waterColor;
    static final PaletteUtil.Color emptinessColor;
    static final PaletteUtil.Color[] basicColors;
    static final Vec2f[] basicColorCenters;
    static final Vec2f[] customColorCenters;
    static final Vec2f waterCenter;
    static final float basicColorRadius = 11.0f;
    static final float customColorRadius = 6.5f;
    boolean isCarryingColor;
    boolean isCarryingWater;
    boolean dirty;
    PaletteUtil.Color carriedColor;
    PaletteUtil.Color currentColor;
    PaletteUtil.CustomColor[] customColors;
    boolean[] basicColorFlags;

    BasePalette(ITextComponent titleIn, NBTTagCompound paletteTag) {
        block6: {
            block5: {
                this.isCarryingColor = false;
                this.isCarryingWater = false;
                this.dirty = false;
                this.currentColor = basicColors[0];
                this.customColors = new PaletteUtil.CustomColor[12];
                this.basicColorFlags = new boolean[16];
                if (paletteTag == null) break block5;
                if (paletteTag.func_74764_b("r") && paletteTag.func_74764_b("g") && paletteTag.func_74764_b("b") && paletteTag.func_74764_b("m") && paletteTag.func_74764_b("n")) {
                    PaletteUtil.readCustomColorArrayFromNBT(paletteTag, this.customColors);
                } else {
                    for (int i = 0; i < this.customColors.length; ++i) {
                        this.customColors[i] = new PaletteUtil.CustomColor();
                    }
                }
                if (!paletteTag.func_74764_b("basic")) break block6;
                byte[] basics = paletteTag.func_74770_j("basic");
                for (int i = 0; i < basics.length; ++i) {
                    this.basicColorFlags[i] = basics[i] > 0;
                }
                break block6;
            }
            for (int i = 0; i < this.customColors.length; ++i) {
                this.customColors[i] = new PaletteUtil.CustomColor();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        int y;
        int x;
        int i;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(noteGuiTextures);
        for (i = 0; i < this.basicColorFlags.length; ++i) {
            x = paletteX + (int)BasePalette.basicColorCenters[i].field_189982_i;
            y = paletteY + (int)BasePalette.basicColorCenters[i].field_189983_j;
            int r = 11;
            if (this.basicColorFlags[i]) {
                BasePalette.func_73734_a((int)(x - r), (int)(y - r), (int)(x + r + 1), (int)(y + r + 1), (int)basicColors[i].rgbVal());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(x - 8, y - 8, 240, i * 16, 16, 16);
                continue;
            }
            BasePalette.func_73734_a((int)(x - r), (int)(y - r), (int)(x + r + 1), (int)(y + r + 1), (int)emptinessColor.rgbVal());
        }
        for (i = 0; i < this.customColors.length; ++i) {
            x = paletteX + (int)BasePalette.customColorCenters[i].field_189982_i;
            y = paletteY + (int)BasePalette.customColorCenters[i].field_189983_j;
            BasePalette.func_73734_a((int)(x - 6), (int)(y - 7), (int)(x + 7), (int)(y + 6), (int)this.customColors[i].getColor().rgbVal());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(paletteX, paletteY, 0, 0, 157, 193);
    }

    public void func_73864_a(int posX, int posY, int mouseButton) throws IOException {
        int mouseY;
        int mouseX = Math.round(posX);
        if (this.paletteClick(mouseX, mouseY = Math.round(posY))) {
            int i;
            int x = mouseX - paletteX;
            int y = mouseY - paletteY;
            Vec2f clickVec = new Vec2f((float)x, (float)y);
            float sqrBasicRadius = 121.0f;
            float sqrCustomRadius = 42.25f;
            boolean colorFound = false;
            for (i = 0; i < basicColorCenters.length; ++i) {
                if (!this.basicColorFlags[i] || !(this.sqrDist(clickVec, basicColorCenters[i]) <= sqrBasicRadius)) continue;
                if (mouseButton == 0) {
                    this.carriedColor = this.currentColor = basicColors[i];
                    this.isCarryingColor = true;
                }
                colorFound = true;
                break;
            }
            if (!colorFound) {
                for (i = 0; i < customColorCenters.length; ++i) {
                    if (!(this.sqrDist(clickVec, customColorCenters[i]) <= sqrCustomRadius)) continue;
                    if (mouseButton == 0 && this.customColors[i].getNumberOfColors() > 0) {
                        this.carriedColor = this.currentColor = this.customColors[i].getColor();
                        this.isCarryingColor = true;
                    }
                    colorFound = true;
                    break;
                }
            }
            if (!colorFound && this.sqrDist(clickVec, waterCenter) <= sqrCustomRadius && mouseButton == 0) {
                this.isCarryingWater = true;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_146286_b(int posX, int posY, int mouseButton) {
        int mouseX = Math.round(posX);
        int mouseY = Math.round(posY);
        if (this.isCarryingColor || this.isCarryingWater) {
            if (this.paletteClick(mouseX, mouseY)) {
                float sqrCustomRadius = 42.25f;
                int x = mouseX - paletteX;
                int y = mouseY - paletteY;
                Vec2f clickVec = new Vec2f((float)x, (float)y);
                for (int i = 0; i < customColorCenters.length; ++i) {
                    if (!(this.sqrDist(clickVec, customColorCenters[i]) <= sqrCustomRadius)) continue;
                    PaletteUtil.CustomColor customColor = this.customColors[i];
                    if (this.isCarryingWater) {
                        customColor.reset();
                    } else {
                        customColor.mix(this.carriedColor);
                        this.currentColor = customColor.getColor();
                    }
                    this.dirty = true;
                    break;
                }
            }
            this.isCarryingColor = false;
            this.isCarryingWater = false;
        }
        super.func_146286_b(posX, posY, mouseButton);
    }

    public boolean func_73868_f() {
        return false;
    }

    boolean paletteClick(int x, int y) {
        return x <= paletteX + 157 && x >= paletteX && y <= paletteY + 193 && y >= paletteY;
    }

    float sqrDist(Vec2f a, Vec2f b) {
        return (a.field_189982_i - b.field_189982_i) * (a.field_189982_i - b.field_189982_i) + (a.field_189983_j - b.field_189983_j) * (a.field_189983_j - b.field_189983_j);
    }

    static {
        waterColor = new PaletteUtil.Color(53, 118, 191);
        emptinessColor = new PaletteUtil.Color(255, 236, 229);
        basicColors = new PaletteUtil.Color[]{new PaletteUtil.Color(-14869215), new PaletteUtil.Color(-5231066), new PaletteUtil.Color(-10585066), new PaletteUtil.Color(-8170446), new PaletteUtil.Color(-12827478), new PaletteUtil.Color(-7785800), new PaletteUtil.Color(-15295332), new PaletteUtil.Color(-6447721), new PaletteUtil.Color(-12103854), new PaletteUtil.Color(-816214), new PaletteUtil.Color(-8337633), new PaletteUtil.Color(-75715), new PaletteUtil.Color(-12930086), new PaletteUtil.Color(-3715395), new PaletteUtil.Color(-425955), new PaletteUtil.Color(-393218)};
        basicColorCenters = new Vec2f[]{new Vec2f(23.5f, 172.5f), new Vec2f(18.5f, 145.5f), new Vec2f(16.5f, 117.5f), new Vec2f(17.5f, 89.5f), new Vec2f(23.5f, 62.5f), new Vec2f(38.5f, 39.5f), new Vec2f(61.5f, 24.5f), new Vec2f(87.5f, 17.5f), new Vec2f(114.5f, 15.5f), new Vec2f(44.5f, 154.5f), new Vec2f(41.5f, 127.5f), new Vec2f(42.5f, 100.5f), new Vec2f(48.5f, 74.5f), new Vec2f(64.5f, 52.5f), new Vec2f(90.5f, 44.5f), new Vec2f(117.5f, 42.5f)};
        customColorCenters = new Vec2f[]{new Vec2f(101.5f, 132.0f), new Vec2f(113.5f, 118.0f), new Vec2f(120.5f, 102.0f), new Vec2f(124.5f, 84.0f), new Vec2f(126.5f, 66.0f), new Vec2f(97.5f, 152.0f), new Vec2f(114.5f, 146.0f), new Vec2f(127.5f, 133.0f), new Vec2f(134.5f, 116.0f), new Vec2f(139.5f, 98.0f), new Vec2f(142.5f, 80.0f), new Vec2f(144.5f, 62.0f)};
        waterCenter = new Vec2f(140.5f, 28.0f);
    }
}

