/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import java.util.Arrays;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xerca.xercapaint.common.CanvasType;

@SideOnly(value=Side.CLIENT)
public class GuiCanvasView
extends GuiScreen {
    private int canvasX = 140;
    private int canvasY = 40;
    private int canvasWidth;
    private int canvasHeight;
    private int canvasPixelScale;
    private int canvasPixelWidth;
    private int canvasPixelHeight;
    private CanvasType canvasType;
    private boolean isSigned = false;
    private int[] pixels;
    private String authorName = "";
    private String canvasTitle = "";
    private String name = "";
    private int version = 0;

    protected GuiCanvasView(NBTTagCompound canvasTag, ITextComponent title, CanvasType canvasType) {
        this.canvasType = canvasType;
        this.canvasPixelScale = canvasType == CanvasType.SMALL ? 10 : 5;
        this.canvasPixelWidth = CanvasType.getWidth(canvasType);
        this.canvasPixelHeight = CanvasType.getHeight(canvasType);
        int canvasPixelArea = this.canvasPixelHeight * this.canvasPixelWidth;
        this.canvasWidth = this.canvasPixelWidth * this.canvasPixelScale;
        this.canvasHeight = this.canvasPixelHeight * this.canvasPixelScale;
        if (canvasType.equals((Object)CanvasType.LONG)) {
            this.canvasY += 40;
        }
        if (canvasType.equals((Object)CanvasType.TALL)) {
            this.canvasX += 40;
        }
        if (canvasTag != null && !canvasTag.func_82582_d()) {
            int[] nbtPixels = canvasTag.func_74759_k("pixels");
            this.authorName = canvasTag.func_74779_i("author");
            this.canvasTitle = canvasTag.func_74779_i("title");
            this.name = canvasTag.func_74779_i("name");
            this.version = canvasTag.func_74762_e("v");
            this.pixels = Arrays.copyOfRange(nbtPixels, 0, canvasPixelArea);
        } else {
            this.isSigned = false;
        }
    }

    private int getPixelAt(int x, int y) {
        return this.pixels == null ? -393218 : this.pixels[y * this.canvasPixelWidth + x];
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        for (int i = 0; i < this.canvasPixelHeight; ++i) {
            for (int j = 0; j < this.canvasPixelWidth; ++j) {
                int x = this.canvasX + j * this.canvasPixelScale;
                int y = this.canvasY + i * this.canvasPixelScale;
                GuiCanvasView.func_73734_a((int)x, (int)y, (int)(x + this.canvasPixelScale), (int)(y + this.canvasPixelScale), (int)this.getPixelAt(j, i));
            }
        }
    }
}

